/**
 * @swcomponent fc_sxm
 * @{
 * @file        fc_sxm_unique_name.h
 * @brief       Declaration and implementation for UniqueName class which will provide
 *              unique name semaphore lock
 * @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 * @}
 */

#ifndef FC_SXM_UNIQUE_NAME_H
#define FC_SXM_UNIQUE_NAME_H

/*
 Utility-class to get a unique name
 */

#include "fc_sxm_tcl_singleton.h"
class fc_sxm_tclUniqueName :
   public fc_sxm_tclSingleton<fc_sxm_tclUniqueName>
{
public:
   ~fc_sxm_tclUniqueName()
   {
      OSAL_s32SemaphoreClose(_hSem);
      OSAL_s32SemaphoreDelete("fc_sxm_uniqueName");
      _hSem = OSAL_C_INVALID_HANDLE;
   }

   string oGetUniqueName()
   {
	 (tVoid) OSAL_s32SemaphoreWait(_hSem, OSAL_C_U32_INFINITE);

      char szName[20];
      sprintf(szName, "fc_sxm_%u", (unsigned int) _u32NumNames);

      string oName(szName);
      _u32NumNames++;
      OSAL_s32SemaphorePost(_hSem);
      return oName;
   }

private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclUniqueName> ;
   fc_sxm_tclUniqueName()
            : _hSem(OSAL_C_INVALID_HANDLE),
              _u32NumNames(0)
   {
      if(OSAL_ERROR == OSAL_s32SemaphoreCreate("fc_sxm_uniqueName", &_hSem, 1))
      {
         _hSem = OSAL_C_INVALID_HANDLE;
         NORMAL_M_ASSERT_ALWAYS();
      }

   }

   OSAL_tSemHandle _hSem;
   tU32 _u32NumNames;
};
#endif
