/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_types.h
* @brief       This file contains fc_sxm application specific types
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TYPES_H_
#define _FC_SXM_TYPES_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <string>
#include <map>
#include <set>
#include <list>
#include <vector>
#include <algorithm>
#include <deque>

using namespace std;

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

// Definition of the Message queue length for the MessageThread
#define CCXDS_MSG_QUEUE_LEN  100

#include "fc_sxm_assert.h"
#include "fc_sxm_tcl_prio_queue.h"

/*
  Generic ttfis-cmds that can be sent for each app
*/
typedef enum {
    fc_sxm_enGenricTtfisCmd_DsrlData=14,
    fc_sxm_enGenricTtfisCmd_StartDataService=15
}fc_sxm_tenGenricTtfisCmd;

/*
  each message has an id u32Action.
  The 2 most significant bytes indicate the sxm-service.
  The 2 other bytes have to be unique inside the used sxm-service
  note: the sxm-service-id is NOT the service id of the related cca-service.
  We can not be sure that we will alway have a 1 to 1 relation betwenn cca-service and sxm-app. 
*/

typedef enum
{
    fc_sxm_enServiceID_Audio = 0x101, // only for audio
    fc_sxm_enServiceID_Channelart = 0x201, //only for channelart
    fc_sxm_enServiceID_Traffic = 0x301, //only for traffic
    fc_sxm_enServiceID_Movies = 0x401, // only for Movies
    fc_sxm_enServiceID_AGW = 0x501, // only for AGW
    fc_sxm_enServiceID_Tabweather = 0x601, // only for weather
    fc_sxm_enServiceID_Fuel = 0x701, // only for fuel
    fc_sxm_enServiceID_Stocks = 0x901, // only for stocks
    fc_sxm_enServiceID_Sports = 0x801,  // only for sports
    fc_sxm_enServiceID_Canadian_Fuel = 0xA01, // canadian fuel
    fc_sxm_enServiceID_WsAlerts = 0xB01, // only for Weather and Security Alerts
    fc_sxm_enServiceID_Parking = 0xC01, // only for parking
    fc_sxm_enServiceID_Phonetics = 0xD01, // only for phonetics
    fc_sxm_enServiceID_Safeview = 0xF01, // only for safeview
    fc_sxm_enServiceID_AllData = 1, // broadcast to all data-threads
    fc_sxm_enServiceID_All = 0, // broadcast to all threads
    fc_sxm_enServiceID_Main = 2, // handle in cca-context
    fc_sxm_enServiceID_AppManager = 3, // handle in cca-context
    fc_sxm_enServiceID_Cca = 4 // handle in cca-context
}
fc_sxm_tenServiceID;

#if 1
struct fc_sxm_tclMessage {
public:
    virtual ~fc_sxm_tclMessage() {};
    virtual tU32 u32GetAction() const=0;
    fc_sxm_tenServiceID enGetServiceId() const {
        return (fc_sxm_tenServiceID)(u32GetAction()>>16);
    }
    tU16 u16GetActionOnly() const {
        return (tU16)(u32GetAction() & 0xFFFF);
    }
    /* Constructor */
    fc_sxm_tclMessage()
       :tMsgPrio(fc_sxm_eMsgPrioNormal) 
    {}
    /* Set message priority */
    tVoid vSetMsgPrioHigh(tVoid) {
       tMsgPrio = fc_sxm_eMsgPrioHigh;
    }
    /* Get message priority */
    fc_sxm_tenMsgPrio enGetMsgPrio(tVoid) {
       return(tMsgPrio);
    }
private:
       fc_sxm_tenMsgPrio tMsgPrio;
};
#endif 

class fc_sxm_tclMsgCallerBase {
 public:
    virtual ~fc_sxm_tclMsgCallerBase() {};
    virtual tVoid vCall()=0;
    virtual tVoid *pvGetTarget()=0;
};

template<class T, class M>
    class fc_sxm_tclMsgCaller: public fc_sxm_tclMsgCallerBase {
 public:
        virtual tVoid vSetMsg(M const &rMsg_) {
            rMsg=rMsg_;
        }

        virtual tVoid vCall() {
            T::instance()->vProcess(&rMsg);
        }
        virtual tVoid *pvGetTarget() {
            return T::instance();
        }

        M rMsg;
    };

inline fc_sxm_tenServiceID fc_sxm_enGetServiceId(tU32 u32Action) {
    return ((fc_sxm_tenServiceID)(u32Action>>16));
}


/* macro to create u32Action from a fc_sxm_tenServiceID and a unique number related to this service-id
   this macro has to be used by each message.
   check fc_sxm_tcl_audio_app.h for examples
*/
#define SXM_MAKE_ACTION(enService, u16Id) \
    static const tU32 u32Action=\
        (((tU16)(enService)<<16)|(u16Id));\
    virtual tU32 u32GetAction() const {return u32Action;}


/*
  note: all message for one service-id should be defined in the corresponding app-header,
  e.g. fc_sxm_tcl_audio_app.h

*/




/*
  struct to hold adressing from received cca-message.
  Data are needed later to answer a method start with a method-result
*/
struct fc_sxm_trAdressing {
    fc_sxm_trAdressing() {
        u16AppId=0;
        u16RegId=0;
        u16CmdCounter=0;
        u16ServiceId=0;
        u16FunctionId=0;
        u8OpCode=0;
        u8ACT=0;
        u16SourceSub=0;
        u16TargetSub=0;
    }
    fc_sxm_trAdressing(amt_tclServiceData const &oMessage) {
        u16AppId=oMessage.u16GetSourceAppID();
        u16RegId=oMessage.u16GetRegisterID();
        u16CmdCounter=oMessage.u16GetCmdCounter();
        u16ServiceId=oMessage.u16GetServiceID();
        u16FunctionId=oMessage.u16GetFunctionID();
        u8OpCode=oMessage.u8GetOpCode();
        u8ACT=oMessage.u8GetACT();
        u16SourceSub=oMessage.u16GetSourceSubID();
        u16TargetSub=oMessage.u16GetTargetSubID();
    }

    tBool bIsValid() const {
        return u16AppId != 0 && u16ServiceId != 0;
    }

    tU16 u16AppId;
    tU16 u16RegId;
    tU16 u16CmdCounter;
    tU16 u16ServiceId;
    tU16 u16FunctionId;
    tU8  u8OpCode;
    tU8  u8ACT;
    tU16 u16SourceSub;
    tU16 u16TargetSub;

};

typedef enum
{
    fc_sxm_enServiceStat_Unknwn = 0x1, 
    fc_sxm_enServiceStat_Subscribed = 0x2, 
    fc_sxm_enServiceStat_NotSubscribed = 0x3,
    fc_sxm_enServiceStat_NotAvailable = 0x4, 
    fc_sxm_enServiceStat_No_Antenna = 0x5, 
    fc_sxm_enServiceStat_NoSignal = 0x6
}fc_sxm_tenServiceSubStatus;

/* start diag-property Test Mode Data*/
struct fc_sxm_trDiagSxmVersionInfo 
{
    string oModuleId;
    string oHdwRev;
    string oSwRev;
    string oSXIRev;
    string oBBRev;
    string oHDecRev;
    string oRFRev;
    string oCapability;
    string oSPLRev;
};

struct fc_sxm_trDiagSxmSubStatus
{
    fc_sxm_trDiagSxmSubStatus():u8SubsStat(0),
         u8ReasonCode(0),u32SusPendDate(0)
    {}

    tU8 u8SubsStat; 
    tU8 u8ReasonCode;
    tU32 u32SusPendDate;
};


enum fc_sxm_enDiagAntennaState 
{
  FC_SXM_DIAG_SAT_TER_ANT_UNDETECTED = 0UL,
  FC_SXM_DIAG_SAT_TER_ANT_DETECTED = 3UL,
  FC_SXM_DIAG_SAT_TER_ANT_SHORTED = 7UL
};

enum fc_sxm_enDiagSignalQuality  
{
  FC_SXM_DIAG_SQ_NO_SIGNAL = 0UL,
  FC_SXM_DIAG_SQ_VERY_WEAK_SIGNAL = 1UL,
  FC_SXM_DIAG_SQ_WEAK_SIGNAL = 2UL,
  FC_SXM_DIAG_SQ_MARGINAL_SIGNAL = 3UL,
  FC_SXM_DIAG_SQ_GOOD_SIGNAL = 4UL
};

typedef struct fc_sxm_trDiagSignalQualityStatus
{
  fc_sxm_enDiagAntennaState enDiagAntennaState;
  fc_sxm_enDiagSignalQuality enDiagSignalQuality;
}fc_sxm_tDiagSignalQualityStatus;


#endif //_FC_SXM_TYPES_H_
