/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_trace_macros.h
* @brief       This file contains fc_sxm trace
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TRACE_MACROS_H_
#define _FC_SXM_TRACE_MACROS_H_

#define TR_COMP_SXM     TR_COMP_RADIODATA //128 (0x80)
#define TR_TTFIS_SXM    TR_TTFIS_RADIODATA // 161 (0xA1)

//todo peha: as long as we don't use a namespace, all types should begin with fc_sxm_ (even enums)
enum tenTrcTraceClassfc_sxm 
{
    TR_CLASS_FC_SXM_APPLICATION            = TR_COMP_SXM + 0,
    TR_CLASS_FC_SXM_CLIENTHANDLER_FC_AUDIO = TR_COMP_SXM + 0 + 0x01,
    TR_CLASS_FC_SXM_SERVICE_SXM_AUDIO      = TR_COMP_SXM + 0 + 0x02,
    TR_CLASS_FC_SXMAPP_MANAGER             = TR_COMP_SXM + 0 + 0x03,
    TR_CLASS_FC_SXM_BASE_APP               = TR_COMP_SXM + 0 + 0x04,
    TR_CLASS_FC_SXM_AUDIO_APP              = TR_COMP_SXM + 0 + 0x05,
    TR_CLASS_FC_SXM_AUDIO_THREAD           = TR_COMP_SXM + 0 + 0x06,
    TR_CLASS_FC_SXM_SMS_INIT               = TR_COMP_SXM + 0 + 0x07,
    TR_CLASS_FC_SXM_SMS_OSAL               = TR_COMP_SXM + 0 + 0x08,
    TR_CLASS_FC_SXM_SERVICE_SXM_FUEL       = TR_COMP_SXM + 0 + 0x09,
    TR_CLASS_FC_SXM_FUEL_APP               = TR_COMP_SXM + 0 + 0x0A,
    TR_CLASS_FC_SXM_FUEL_THREAD            = TR_COMP_SXM + 0 + 0x0B,
    TR_CLASS_FC_SXM_FUEL_REQUEST           = TR_COMP_SXM + 0 + 0x0C,
    TR_CLASS_FC_SXM_CHANNEL_LIST           = TR_COMP_SXM + 0 + 0x0D,
    TR_CLASS_FC_SXM_UTIL                   = TR_COMP_SXM + 0 + 0x0E,
    TR_CLASS_FC_SXM_BASE_DSRL              = TR_COMP_SXM + 0 + 0x0F,
    TR_CLASS_FC_SXM_FUEL_DSRL              = TR_COMP_SXM + 0 + 0x10,
    TR_CLASS_FC_SXM_SERVICE_SXM_TRAFFIC    = TR_COMP_SXM + 0 + 0x11,
    TR_CLASS_FC_SXM_TRAFFIC_APP            = TR_COMP_SXM + 0 + 0x12,
    TR_CLASS_FC_SXM_SERVICE_SXM_MOVIES     = TR_COMP_SXM + 0 + 0x13,
    TR_CLASS_FC_SXM_MOVIES_APP             = TR_COMP_SXM + 0 + 0x14,
    TR_CLASS_FC_SXM_MOVIES_DSRL            = TR_COMP_SXM + 0 + 0x15,
    TR_CLASS_FC_SXM_AGW_APP                = TR_COMP_SXM + 0 + 0x16,
    TR_CLASS_FC_SXM_SERVICE_SXM_AGW        = TR_COMP_SXM + 0 + 0x17,
    TR_CLASS_FC_SXM_SERVICE_SXM_TABWEATHER = TR_COMP_SXM + 0 + 0x18,
    TR_CLASS_FC_SXM_TABWEATHER_APP         = TR_COMP_SXM + 0 + 0x19,
    TR_CLASS_FC_SXM_AGW_DSRL               = TR_COMP_SXM + 0 + 0x1A,
    TR_CLASS_FC_SXM_SERVICE_SXM_CHANNELART = TR_COMP_SXM + 0 + 0x1B,
    TR_CLASS_FC_SXM_CHANNELART_APP         = TR_COMP_SXM + 0 + 0x1C,
    TR_CLASS_FC_SXM_TRAFFIC_DATA           = TR_COMP_SXM + 0 + 0x1D,
    TR_CLASS_FC_SXM_SERVICE_SXM_SAFEVIEW   = TR_COMP_SXM + 0 + 0x1E,
    TR_CLASS_FC_SXM_SAFEVIEW_APP           = TR_COMP_SXM + 0 + 0x1F,
    TR_CLASS_FC_SXM_SERVICE_SXM_STOCKS     = TR_COMP_SXM + 0 + 0x20,
    TR_CLASS_FC_SXM_STOCKS_APP             = TR_COMP_SXM + 0 + 0x21,  
    TR_CLASS_FC_SXM_TABWEATHER_DSRL        = TR_COMP_SXM + 0 + 0x22,
    TR_CLASS_FC_SXM_AGW_SHARED_MEMORY      = TR_COMP_SXM + 0 + 0x23,
    TR_CLASS_FC_SXM_CATEGORY_LIST          = TR_COMP_SXM + 0 + 0x24,
    TR_CLASS_FC_SXM_CHANNELART_DATA        = TR_COMP_SXM + 0 + 0x25,
    TR_CLASS_FC_SXM_AUDIOROUTING_LIB       = TR_COMP_SXM + 0 + 0x26,
    TR_CLASS_FC_SXM_PRESETS                = TR_COMP_SXM + 0 + 0x27,
    TR_CLASS_FC_SXM_STOCKS_DSRL            = TR_COMP_SXM + 0 + 0x28,
    TR_CLASS_FC_SXM_ADVISORIES             = TR_COMP_SXM + 0 + 0x29,
    TR_CLASS_FC_SXM_REPORT                 = TR_COMP_SXM + 0 + 0x2A,
    TR_CLASS_FC_SXM_SAFEVIEW_DSRL          = TR_COMP_SXM + 0 + 0x2B,
    TR_CLASS_FC_SXM_DIAGHANDLER            = TR_COMP_SXM + 0 + 0x2C,
    TR_CLASS_FC_SXM_CONFIG                 = TR_COMP_SXM + 0 + 0x2D,
    TR_CLASS_FC_SXM_TIMER                  = TR_COMP_SXM + 0 + 0x2E,
    TR_CLASS_FC_SXM_TIME_PROFILE           = TR_COMP_SXM + 0 + 0x2F,
    TR_CLASS_FC_SXM_CHANNEL                = TR_COMP_SXM + 0 + 0x30,
    TR_CLASS_FC_SXM_STATES                 = TR_COMP_SXM + 0 + 0x31,
    TR_CLASS_FC_SXM_SEM                    = TR_COMP_SXM + 0 + 0x32,
    TR_CLASS_FC_SXM_PLAYBACK               = TR_COMP_SXM + 0 + 0x33,
    TR_CLASS_FC_SXM_SERVICE_SXM_SPORTS     = TR_COMP_SXM + 0 + 0x34,
    TR_CLASS_FC_SXM_SPORTS_APP             = TR_COMP_SXM + 0 + 0x35,
    TR_CLASS_FC_SXM_SPORTS_BASE            = TR_COMP_SXM + 0 + 0x36,
    TR_CLASS_FC_SXM_SPORTS_TEAMSPORTS      = TR_COMP_SXM + 0 + 0x37,
    TR_CLASS_FC_SXM_SPORTS_NONTEAMSPORTS   = TR_COMP_SXM + 0 + 0x38,
    TR_CLASS_FC_SXM_AUDIO_RAPIDCHANNEL_BROWSE   = TR_COMP_SXM + 0 + 0x39,
    TR_CLASS_FC_SXM_AUDIO_TWNOW   	       = TR_COMP_SXM + 0 + 0x3A,
    TR_CLASS_FC_SXM_AUDIO_SPORTS_FLASH     = TR_COMP_SXM + 0 + 0x3B,
    TR_CLASS_FC_SXM_AUDIO_CONTENT_ALERT    = TR_COMP_SXM + 0 + 0x3C,
    TR_CLASS_FC_SXM_CANADIAN_FUEL_APP      = TR_COMP_SXM + 0 + 0x3D,
    TR_CLASS_FC_SXM_CANADIAN_FUEL_DSRL     = TR_COMP_SXM + 0 + 0x3E,
    TR_CLASS_FC_SXM_SERVICE_SXM_CAN_FUEL   = TR_COMP_SXM + 0 + 0x3F,
    //Weather Alerts Data service
    TR_CLASS_FC_SXM_WEATHER_ALERTS         = TR_COMP_SXM + 0 + 0X40,
    TR_CLASS_FC_SXM_WSALERTS_APP           = TR_COMP_SXM + 0 + 0X41,
    TR_CLASS_FC_SXM_WSALERTS_DSRL          = TR_COMP_SXM + 0 + 0X42,
    TR_CLASS_FC_SXM_SERVICE_SXM_WSALERTS   = TR_COMP_SXM + 0 + 0x43,
    //Parking Data service
    TR_CLASS_FC_SXM_PARKING_APP           = TR_COMP_SXM + 0 + 0X44,
    TR_CLASS_FC_SXM_SERVICE_SXM_PARKING   = TR_COMP_SXM + 0 + 0x45,
    //Phonetics Data service
    TR_CLASS_FC_SXM_PHONETICS_APP         = TR_COMP_SXM + 0 + 0x46,
    TR_CLASS_FC_SXM_SERVICE_SXM_PHONETICS   = TR_COMP_SXM + 0 + 0x47,
	
	TR_CLASS_FC_SXM_PARKING_BASE           = TR_COMP_SXM + 0 + 0X48,
    TR_CLASS_FC_SXM_PARKING_NEARBY         = TR_COMP_SXM + 0 + 0x49,
    TR_CLASS_FC_SXM_PARKING_NEARDEST       = TR_COMP_SXM + 0 + 0X50,
	TR_CLASS_FC_SXM_PARKING_FILTERCONFIG   = TR_COMP_SXM + 0 + 0X51,
	TR_CLASS_FC_SXM_PHONETICS_BASE         = TR_COMP_SXM + 0 + 0x52,
    TR_CLASS_FC_SXM_PHONETICS_CHANNELS     = TR_COMP_SXM + 0 + 0x53,
    TR_CLASS_FC_SXM_PARKING_FAVORITES      = TR_COMP_SXM + 0 + 0X54,
    //0x80 to 0x8f are reserved for sms-lib, please add fc_sxm-classes above
    TR_CLASS_FC_SXM_SMSLIB_SERIAL         = TR_COMP_SXM + 0 + 0x80,
    TR_CLASS_FC_SXM_SMSLIB_SXILL          = TR_COMP_SXM + 0 + 0x81,
    TR_CLASS_FC_SXM_SMSLIB_DECODER        = TR_COMP_SXM + 0 + 0x82,
    TR_CLASS_FC_SXM_SMSLIB_OBJ            = TR_COMP_SXM + 0 + 0x83,
    TR_CLASS_FC_SXM_SMSLIB_DATASRV        = TR_COMP_SXM + 0 + 0x84,
    TR_CLASS_FC_SXM_SMSLIB_RADIO          = TR_COMP_SXM + 0 + 0x85,
    TR_CLASS_FC_SXM_SMSLIB_TASK           = TR_COMP_SXM + 0 + 0x86,
    TR_CLASS_FC_SXM_SMSLIB_PRESETS        = TR_COMP_SXM + 0 + 0x87,
    TR_CLASS_FC_SXM_SMSLIB_QUEUE          = TR_COMP_SXM + 0 + 0x88,
    TR_CLASS_FC_SXM_SMSLIB_SMS_LOGGING    = TR_COMP_SXM + 0 + 0x89	
};


#endif //_FC_SXM_TRACE_MACROS_H_
