/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_time_profile.h
* @brief       Utility class to print time profile for one particular code of execution
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TIME_PROFILE_H_
#define _FC_SXM_TIME_PROFILE_H_

/**OSAL's time function interfaces are defined in header file ostime.h **/
#include "ostime.h"

typedef enum {
    fc_sxm_enProfilerOp_Start,
    fc_sxm_enProfilerOp_Lap,
    fc_sxm_enProfilerOp_Stop
} fc_sxm_tenProfilerOp;

class fc_sxmProfiler {
    
 public:
    /** Default Constructor**/
    /** Parameterised Constructor **/
    fc_sxmProfiler(string oName="", tBool bStart=FALSE):_oName(oName)
    { 
        if (bStart) {
            vStart("");
        }
    }
        tVoid vStart(string oComment="") {
            vReadTime(_rStartTime, _rStartTimeCpu);
            vPrint(fc_sxm_enProfilerOp_Start, oComment);
            _rEndTime=_rStartTime;
            _rEndTimeCpu=_rStartTimeCpu;
        }
        tVoid vLap(string oComment="") {
            vReadTime(_rEndTime, _rEndTimeCpu);
            vPrint(fc_sxm_enProfilerOp_Lap, oComment);
       }
        tVoid vStop(string oComment="") {
            vReadTime(_rEndTime, _rEndTimeCpu);
            vPrint(fc_sxm_enProfilerOp_Stop, oComment);
        }

 protected:
        virtual tVoid vPrint(fc_sxm_tenProfilerOp enOp, string oComment="");
        tU32 u32GetMSec(struct timespec &rTime) {
            return     (tU32)(((unsigned long)(rTime.tv_sec) * 1000000UL)
                        + ((unsigned long)(rTime.tv_nsec) / 1000UL));;
        }
        tU32 u32GetMSecDiff();
        
 private:
        tVoid vReadTime(struct timespec &rTime, struct timespec &rTimeCpu) {
            clock_gettime(CLOCK_REALTIME, &rTime);
            clock_gettime(CLOCK_THREAD_CPUTIME_ID, &rTimeCpu);
        }
        struct timespec _rStartTime;
        struct timespec _rStartTimeCpu;
        struct timespec _rEndTime;
        struct timespec _rEndTimeCpu;
        string _oName;
};

class fc_sxmTimeProfile {
public:
	tVoid vStart();
	tVoid vStop();
   inline tVoid vReset() { _msecStartTime = 0 ; } 

public:
   /** Default Constructor**/
	fc_sxmTimeProfile() : _msecStartTime (0), _strUseCase("") { }

   /** Parameterised Constructor **/
   fc_sxmTimeProfile(tCString chString) : _msecStartTime (0), _strUseCase(chString) { }

private:
   tVoid vPrintFormattedOutput(const OSAL_tMSecond& msecElapsedTime) const;

private:
	OSAL_tMSecond _msecStartTime;
   string _strUseCase ;
};


#endif // _FC_SXM_TIME_PROFILE_H_

