/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_tts_states.cpp
* @brief       Implementation of TTS state and states
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_tcl_tts_states.h"
#include "fc_sxm_clienthandler_tts.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_APPLICATION
#include "trcGenProj/Header/fc_sxm_tcl_tts_states.cpp.trc.h"
#endif

/**
 * Default CTOR
 */
fc_sxm_tclTTSState::fc_sxm_tclTTSState()
{
}

/**
 * Default DTOR
 */
fc_sxm_tclTTSState::~fc_sxm_tclTTSState()
{
}

/**
 * Compare the two object TTS state
 * @param oTTSState1
 * @param oTTSState2
 */
tBool fc_sxm_tclTTSState::operator ==(const fc_sxm_tclTTSState* oTTSState1)
{
   return (this == oTTSState1);
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSStateInitial::fc_sxm_tclTTSStateInitial()
   : fc_sxm_tclTTSState()
{

}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStateInitial::~fc_sxm_tclTTSStateInitial()
{
}

/**
 * Perform action after state change
 */
tVoid fc_sxm_tclTTSStateInitial::vDoAction()
{
}

/**
 * Print current state info on state chage
 */
tVoid fc_sxm_tclTTSStateInitial::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_INITIAL"));
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSStatePending::fc_sxm_tclTTSStatePending()
   : fc_sxm_tclTTSState()
{

}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStatePending::~fc_sxm_tclTTSStatePending()
{
}

/**
 * Perform action after state change
 */
tVoid fc_sxm_tclTTSStatePending::vDoAction()
{
	ETG_TRACE_USR4(("TTS_CLIENT_PENDING vDoAction"));
	tBool bResult = fc_sxm_tclTTSClient::instance()->bRequestAudioChannel();
}

/**
 * Print current state info on state chage
 */
tVoid fc_sxm_tclTTSStatePending::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_PENDING"));
}



/**
 * Default CTOR
 */
fc_sxm_tclTTSStateReady::fc_sxm_tclTTSStateReady()
   : fc_sxm_tclTTSState()
{
}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStateReady::~fc_sxm_tclTTSStateReady()
{
}

/**
 * Perform action after state change
 */
tVoid fc_sxm_tclTTSStateReady::vDoAction()
{
   fc_sxm_tclTTSClient::instance()->bSendPrepareVoiceOutput();
}

/**
 * Print current state info on state chage
 */
tVoid fc_sxm_tclTTSStateReady::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_READY"));
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSStatePrepared::fc_sxm_tclTTSStatePrepared()
   : fc_sxm_tclTTSState()
{
}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStatePrepared::~fc_sxm_tclTTSStatePrepared()
{
}

/**
 * Perform action after state change
 */

tVoid fc_sxm_tclTTSStatePrepared::vDoAction()
{
   fc_sxm_tclTTSClient::instance()->bSendSynthesizeSpeakToTTS();
}

/**
 * Print current state info on state chage
 */
tVoid fc_sxm_tclTTSStatePrepared::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_PREPARED"));
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSStateStarted::fc_sxm_tclTTSStateStarted()
   : fc_sxm_tclTTSState()
{
}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStateStarted::~fc_sxm_tclTTSStateStarted()
{
}

/**
 * Perform action after state change
 */
tVoid fc_sxm_tclTTSStateStarted::vDoAction()
{
}

/**
 * Print current state info on state chage
 */
tVoid fc_sxm_tclTTSStateStarted::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_STARTED"));
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSStateQueued::fc_sxm_tclTTSStateQueued()
   : fc_sxm_tclTTSState()
{
}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStateQueued::~fc_sxm_tclTTSStateQueued()
{
}

/**
 * Perform action after state change
 */

tVoid fc_sxm_tclTTSStateQueued::vDoAction()
{
}

/**
 * Print current state info on state chage
 */
tVoid fc_sxm_tclTTSStateQueued::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_QUEUED"));
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSStatePaused::fc_sxm_tclTTSStatePaused()
   : fc_sxm_tclTTSState()
{
}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStatePaused::~fc_sxm_tclTTSStatePaused()
{
}

/**
 * Perform action after state change
 */
tVoid fc_sxm_tclTTSStatePaused::vDoAction()
{
}

/**
 * Print current state info on state chage
 */
tVoid fc_sxm_tclTTSStatePaused::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_PAUSED"));
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSStateResumed::fc_sxm_tclTTSStateResumed()
   : fc_sxm_tclTTSState()
{
}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStateResumed::~fc_sxm_tclTTSStateResumed()
{
}

/**
 * Perform action after state change
 */
tVoid fc_sxm_tclTTSStateResumed::vDoAction()
{
}

/**
 * Print current state info on state chage
 */
tVoid fc_sxm_tclTTSStateResumed::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_RESUMED"));
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSStateAborted::fc_sxm_tclTTSStateAborted()
   : fc_sxm_tclTTSState()
{
}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStateAborted::~fc_sxm_tclTTSStateAborted()
{
}

/**
 * Perform action after state change
 */
tVoid fc_sxm_tclTTSStateAborted::vDoAction()
{
}

/**
 * Print current state info on state chage
 */
tVoid fc_sxm_tclTTSStateAborted::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_ABORTED"));
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSStateStopped::fc_sxm_tclTTSStateStopped()
   : fc_sxm_tclTTSState()
{
}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStateStopped::~fc_sxm_tclTTSStateStopped()
{
}

/**
 * Perform action after state change
 */
tVoid fc_sxm_tclTTSStateStopped::vDoAction()
{
}

/**
 * Print current state info on state chage
 */
tVoid fc_sxm_tclTTSStateStopped::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_STOPPED"));
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSStateError::fc_sxm_tclTTSStateError()
   : fc_sxm_tclTTSState()
{
}

/**
 * Default DTOR
 */
fc_sxm_tclTTSStateError::~fc_sxm_tclTTSStateError()
{
}

/**
 * Perform action after state change
 */
tVoid fc_sxm_tclTTSStateError::vDoAction()
{
}

tVoid fc_sxm_tclTTSStateError::vPrintStateChangeInfo()
{
   ETG_TRACE_USR4(("Current state is TTS_CLIENT_ERROR"));
}
