/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_tts_context.cpp
* @brief       Implementation of TTSContext class
*              It provides the interfacse to set TTS state, get TTS state and do action
*              after state get changed.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_tcl_tts_context.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_APPLICATION
#include "trcGenProj/Header/fc_sxm_tcl_tts_context.cpp.trc.h"
#endif

/**
 * Default CTOR
 */
fc_sxm_tclTTSContext::fc_sxm_tclTTSContext()
   : _poTTSState(OSAL_NULL)

{
   _TTSStateList.push_back(fc_sxm_tclTTSStateInitial::instance());
   _TTSStateList.push_back(fc_sxm_tclTTSStateReady::instance()),
   _TTSStateList.push_back(fc_sxm_tclTTSStatePrepared::instance());
   _TTSStateList.push_back(fc_sxm_tclTTSStateStarted::instance());
   _TTSStateList.push_back(fc_sxm_tclTTSStateQueued::instance());
   _TTSStateList.push_back(fc_sxm_tclTTSStatePaused::instance());
   _TTSStateList.push_back(fc_sxm_tclTTSStateResumed::instance());
   _TTSStateList.push_back(fc_sxm_tclTTSStateAborted::instance());
   _TTSStateList.push_back(fc_sxm_tclTTSStateStopped::instance());
   _TTSStateList.push_back(fc_sxm_tclTTSStateError::instance());
   _poTTSState = fc_sxm_tclTTSStateInitial::instance();
}

/**
 * Default CTOR
 */
fc_sxm_tclTTSContext::~fc_sxm_tclTTSContext()
{
   for(list<fc_sxm_tclTTSState*>::iterator iter = _TTSStateList.begin();
            iter != _TTSStateList.end(); iter++)
   {
      FC_SXM_MEMORY_CLEAR(*iter);
   }
   FC_SXM_MEMORY_CLEAR(_poTTSState);
}

/**
 * Set new state of TTS
 * @param poNewTTSClientState
 */
tVoid fc_sxm_tclTTSContext::vSetState(fc_sxm_tclTTSState* poNewTTSState)
{
   _poTTSState = poNewTTSState;
   _poTTSState->vPrintStateChangeInfo();
}

/**
 * Get current state of the TTS
 * @return _poTTSState current state of the TTS
 */
fc_sxm_tclTTSState* fc_sxm_tclTTSContext::poGetCurrentState()
{
   return _poTTSState;
}

/**
 * Perform the action after state change
 */
tVoid fc_sxm_tclTTSContext::vDoAction()
{
   if(_poTTSState)
   {
      _poTTSState->vDoAction();
   }
}


