/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_timer.cpp
* @brief       Implementation of timer functionality
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "fc_sxm_assert.h"
#include "fc_sxm_tcl_timer.h"
#include "fc_sxm_tcl_base_app.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_TIMER
#include "trcGenProj/Header/fc_sxm_tcl_timer.cpp.trc.h"
#endif

tVoid fc_sxm_vTimerCallbackFn(tVoid *pvArg) {
    fc_sxm_tclTimerBase *poTimer=(fc_sxm_tclTimerBase *)pvArg;
    poTimer->vOnCallback();
};



fc_sxm_tclTimerBase::fc_sxm_tclTimerBase():
_bFired(FALSE), 
_bRunning(FALSE),
_hOsalTmrHandle(OSAL_C_INVALID_HANDLE)
{
    ETG_TRACE_USR3(("fc_sxm_tclTimerBase CTOR 0x%08x", this));
}

fc_sxm_tclTimerBase::~fc_sxm_tclTimerBase() {
    if (!bIsInitialized()) {
        return;
    }
    ETG_TRACE_USR3(("fc_sxm_tclTimerBase DTOR 0x%08x", this));
    vStop();
    tS32 s32OsalRet;
    s32OsalRet = OSAL_s32TimerDelete(_hOsalTmrHandle);
    SXM_ASSERT_RETURN(OSAL_OK == s32OsalRet);
    _hOsalTmrHandle=(tU32)OSAL_C_INVALID_HANDLE;

       
}


tBool fc_sxm_tclTimerBase::bIsFired() const {
    ETG_TRACE_USR3(("fc_sxm_tclTimerBase:bIsFired 0x%08x = %d", this, _bFired));
    return _bFired;
}

tBool fc_sxm_tclTimerBase::bIsRunning() const{
    ETG_TRACE_USR3(("fc_sxm_tclTimerBase:bIsRunning 0x%08x = %d", this, _bRunning));
    return _bRunning;
}

tVoid fc_sxm_tclTimerBase::vStart(tU32 u32Ms) {
    ETG_TRACE_USR2(("fc_sxm_tclTimerBase:vStart 0x%08x ms=%d", this, u32Ms));

    if (!bIsInitialized()) {
        tS32 s32OsalRet;
        s32OsalRet = OSAL_s32TimerCreate(fc_sxm_vTimerCallbackFn, (tPVoid)this, &_hOsalTmrHandle);
        SXM_ASSERT_RETURN(OSAL_OK == s32OsalRet);
        ETG_TRACE_USR3(("fc_sxm_tclTimerBase:vStart 0x%08x OSAL_s32TimerCreate=%d", this, s32OsalRet));

        vRegisterApp();
    }
    tS32 s32OsalRet;
    s32OsalRet = OSAL_s32TimerSetTime(_hOsalTmrHandle, u32Ms, 0);
    ETG_TRACE_USR3(("fc_sxm_tclTimerBase:vStart 0x%08x OSAL_s32TimerSetTime=%d", this, s32OsalRet));
    
    SXM_ASSERT_RETURN(OSAL_OK == s32OsalRet);
    _bRunning=TRUE; 
    _bFired=FALSE; 
}

tVoid fc_sxm_tclTimerBase::vStop() {
    if (!bIsInitialized()) {
        return;
    }

    _bRunning=FALSE;
    _bFired=FALSE;
    
    tS32 s32OsalRet;
    s32OsalRet = OSAL_s32TimerSetTime(_hOsalTmrHandle, 0, 0);
    SXM_ASSERT_RETURN(OSAL_OK == s32OsalRet);
    ETG_TRACE_USR2(("fc_sxm_tclTimerBase:vStop 0x%08x OSAL_s32TimerSetTime(0)=%d", this, s32OsalRet));
}

tU32 fc_sxm_tclTimerBase::u32GetRemainingMs() const {
    OSAL_tMSecond MSec = 0;
    if (bIsInitialized()) {
        OSAL_tMSecond Interval;
        (tVoid)OSAL_s32TimerGetTime(_hOsalTmrHandle,
                             &MSec,
                             &Interval);
    }
    ETG_TRACE_USR2(("fc_sxm_tclTimerBase:u32GetRemainingMs(0x%08x) %d", this, MSec));
    return MSec;
}

tBool fc_sxm_tclTimerBase::bIsInitialized() const {
    ETG_TRACE_USR3(("fc_sxm_tclTimerBase:bIsInitialized 0x%08x =%d", this, _hOsalTmrHandle!=OSAL_C_INVALID_HANDLE));

    return _hOsalTmrHandle!=OSAL_C_INVALID_HANDLE;
}

tVoid fc_sxm_tclTimerBase::vOnCallback_(fc_sxm_tclBaseApp *poApp) const {
    poApp->vPostTimerEvent();
}

tVoid fc_sxm_tclTimerBase::vTraceExecute() {
    ETG_TRACE_USR2(("fc_sxm_tclTimerBase:vExecute 0x%08x _bFired=%d _bRunning=%d", this, _bFired, _bRunning));
    
}
