/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_reg_util.h
* @brief       Declaration of utility for registry operation. It perform open, read,
*              write, close operation on registry
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_REG_UTIL_H
#define FC_SXM_TCL_REG_UTIL_H

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#include "fc_sxm_common.h"

class fc_sxm_tclRegUtil
{
 public:

    fc_sxm_tclRegUtil(const char *pcPath);
    ~fc_sxm_tclRegUtil();

    tBool bOpen();
    tVoid vClose();
    tBool bIsOpen() const;
    tBool bWrite(char const *pKey, char *pValue, tU32 u32Len);
    tBool bRead(char const *pKey, char *pValue, tU32 u32Len);

 private:
    char const *m_pcPath;
    tBool m_bOpen;
    reg_tclRegKey m_oReg;
};

#endif
