/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_reg_util.cpp
* @brief       Implementation of utility to perform registry operation
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_tcl_reg_util.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_BASE_APP
#include "trcGenProj/Header/fc_sxm_tcl_reg_util.cpp.trc.h"
#endif

fc_sxm_tclRegUtil::fc_sxm_tclRegUtil(const char *pcPath): m_pcPath(pcPath),m_bOpen(FALSE)
{};

fc_sxm_tclRegUtil::~fc_sxm_tclRegUtil() 
{
    vClose();
    m_pcPath=OSAL_NULL;
}

tBool fc_sxm_tclRegUtil::bOpen()
{
    if (!m_bOpen && m_pcPath !=OSAL_NULL) 
    {
        m_bOpen = m_oReg.bOpen(m_pcPath);
        if (!m_bOpen) {
            ETG_TRACE_ERR(("Open REG-path (%s) failed !!!", m_pcPath));
        }
    }
    return m_bOpen;
};

tVoid fc_sxm_tclRegUtil::vClose()
{
    if (m_bOpen) {
        m_oReg.vClose();
        m_bOpen=FALSE;
    }
};

tBool fc_sxm_tclRegUtil::bIsOpen() const 
{
    return m_bOpen;
};

tBool fc_sxm_tclRegUtil::bWrite(char const *pKey, char *pValue, tU32 u32Len)
{
    tBool bSuccess=FALSE;
    if (bOpen()) 
    {
        bSuccess =m_oReg.bSetString(pKey,pValue,u32Len);
        if (!bSuccess) {
            ETG_TRACE_ERR(("Write REG (%s) failed !!!", pKey));
        }
    }
    return bSuccess;
}

tBool fc_sxm_tclRegUtil::bRead(char const *pKey, char *pValue, tU32 u32Len)
{
    tBool bSuccess=FALSE;
    if (bOpen()) 
    {
        bSuccess =m_oReg.bQueryString(pKey,pValue,u32Len);
        if (!bSuccess) {
            ETG_TRACE_ERR(("Read REG (%s) failed !!!", pKey));
        }
    }
    return bSuccess;
}

