/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_personalization_if.h
* @brief       Profile Manager Interface.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PERSONALIZATION_IF_H_
#define FC_SXM_TCL_PERSONALIZATION_IF_H_

typedef enum {
	FC_SXM_EN_FAILED,
	FC_SXM_EN_PROFILE_CHANGED,
	FC_SXM_EN_COPY_PROFILE,
	FC_SXM_EN_DELETE_PROFILE
}fc_sxm_tenAckProfileMgr;

class Ifc_sxm_tclPersonalization {
public:
	virtual ~Ifc_sxm_tclPersonalization() { }

	virtual tVoid vChangeProfileUpdate(tBool) = 0;
	virtual tVoid vCopyProfileUpdate() = 0;
	virtual tVoid vDeleteProfileUpdate() = 0;
};


#endif /* FC_SXM_TCL_PERSONALIZATION_IF_H_ */
