/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_pers_data.h
* @brief       Declaration of persistance related & datapool apis to applications
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PERS_DATA_H_
#define _FC_SXM_TCL_PERS_DATA_H_

#define AHL_S_IMPORT_INTERFACE_GENERIC

#include "fc_sxm_types.h"
#include "fc_sxm_tcl_singleton.h"
#include "fc_sxm_tcl_pers_sports_data.h"
#include "fc_sxm_tcl_pers_app_data.h"
#include "fc_sxm_sms.h"

/* Interface between persistance & sports data class */
struct trUserConfig 
{
public:
    /* Constructor */
    trUserConfig();
    /* Destructor */
    ~trUserConfig();
    /* Get data */
    tVoid vGetData(tVoid);
    /* Set data */
    tVoid vSetData(tVoid);
};

class fc_sxm_tclPersData:
public fc_sxm_tclSingleton<fc_sxm_tclPersData>

{
 public:
#define FC_SXM_PERS_DATA_APP_FLAG_SXM_DB_ERR_DETECTED 0x01

    // todo: put following defines to fc_sxm_config.h
#define FC_SXM_PERS_DATA_NUM_DATA_APP_MAX 16

    struct trDPConfig {
        trDPConfig() {
            OSAL_pvMemorySet(au8AppFlags, 0, FC_SXM_PERS_DATA_NUM_DATA_APP_MAX);
            
        }
        tU8 au8AppFlags[FC_SXM_PERS_DATA_NUM_DATA_APP_MAX];
    };

    // reset to default-setting
    tVoid vSetDefaultSettings(tBool bResetAllUsers=TRUE);
    // read config-data
    tVoid vLoadData();
    // save config-data
    tVoid vSaveData();

      // interface for users
      tVoid vSetPersistentDbError(tBool bSet, fc_sxm_tenServiceID enServiceId=fc_sxm_enServiceID_All);
      tBool bGetPersistentDbError(fc_sxm_tenServiceID enServiceId=fc_sxm_enServiceID_All);


    tVoid vGetDPSportsList(tSXMAudio_ProtectedSportList& trSportsData);
    tVoid vSetDPSportsList(tSXMAudio_ProtectedSportList& trSportsData);
    tVoid vGetDPRootList(tSXMAudio_ProtectedRootList& trRootData);
    tVoid vSetDPRootList(tSXMAudio_ProtectedRootList& trRootData);
    tVoid vGetDPFavoriteList(tSXMAudio_ProtectedFavoriteList& trFavData);
    tVoid vSetDPFavoriteList(tSXMAudio_ProtectedFavoriteList& trFavData);
    /* MOVIES */
    tVoid vGetDPMoviesFavoriteList(tSXMDataService_ProtectedMoviesFavoriteList& trAppData);
    tVoid vSetDPMoviesFavoriteList(tSXMDataService_ProtectedMoviesFavoriteList& trAppData);

    /* FUEL */
    tVoid vGetDPFuelFavoriteList(tSXMDataService_ProtectedFuelFavoriteList& trAppData);
    tVoid vSetDPFuelFavoriteList(tSXMDataService_ProtectedFuelFavoriteList& trAppData);

    /* CANADIAN FUEL */
    tVoid vGetDPCanFuelFavoriteList(tSXMDataService_ProtectedCanFuelFavoriteList& trAppData);
    tVoid vSetDPCanFuelFavoriteList(tSXMDataService_ProtectedCanFuelFavoriteList& trAppData);

    /* STOCKS */
    tVoid vGetDPStocksFavoriteList(tSXMDataService_ProtectedStocksFavoriteList& trAppData);
    tVoid vSetDPStocksFavoriteList(tSXMDataService_ProtectedStocksFavoriteList& trAppData);

    tU32 u32GetSmsCfgVersion() const;
    tU32 u32GetFuelVersion() const;
    tU32 u32GetCanadianFuelVersion() const;
    tU32 u32GetTrafficVersion() const;
    tU32 u32GetMoviesVersion() const;
    tU32 u32GetAgwVersion() const;
    tU32 u32GetTabWeatherVersion() const;
    tU32 u32GetStocksVersion() const;
    tU32 u32GetSportsVersion() const;
    tU32 u32GetWsAlertsVersion() const;
    tU32 u32GetParkingVersion() const;
    tU32 u32GetPhoneticsVersion() const;
    tU32 u32GetStatesVersion() const;
    tU32 u32GetChannelArtVersion() const;


    tVoid vClearDPAppsFavoriteList();
    tVoid vSetSmsCfgVersion(tU32 u32DpAppDbVersion);
    tVoid vSetFuelVersion(tU32 u32DpAppDbVersion);
    tVoid vSetCanadianFuelVersion(tU32 u32DpAppDbVersion);
    tVoid vSetTrafficVersion(tU32 u32DpAppDbVersion);
    tVoid vSetMoviesVersion(tU32 u32DpAppDbVersion);
    tVoid vSetAgwVersion(tU32 u32DpAppDbVersion);
    tVoid vSetTabWeatherVersion(tU32 u32DpAppDbVersion);
    tVoid vSetStocksVersion(tU32 u32DpAppDbVersion);
    tVoid vSetSportsVersion(tU32 u32DpAppDbVersion);
    tVoid vSetWsAlertsVersion(tU32 u32DpAppDbVersion);
    tVoid vSetParkingVersion(tU32 u32DpAppDbVersion);
    tVoid vSetPhoneticsVersion(tU32 u32DpAppDbVersion);
    tVoid vSetStatesVersion(tU32 u32DpAppStatesVersion);
    tVoid vSetChannelArtVersion(tU32 u32DpAppDbVersion);
    tVoid vGetDPProfileId(tU8& u16DpSIDs);
    tVoid vSetDPProfileId(tU8 u16DpSIDs);
    tVoid vGetPresetData(SERVICE_ID *u16DpSIDs);
    tVoid vSetPresetData(SERVICE_ID *u16DpSIDs);

    tBool bGetDPPresetType() const;
    tVoid vSetDPPresetType(tBool presetType);

 private:
        friend class fc_sxm_tclSingleton<fc_sxm_tclPersData>;
        fc_sxm_tclPersData();
    trDPConfig _rDPConfig;
    trUserConfig _rUserConfig;
    tU8 _u8NumberOfPresets;
    tBool _bIsMixedPreset;

    tVoid vGetDPSportsListSize(tU32& dpu32SportsListSize ) const;
    tVoid vSetDPSportsListSize(tU32 dpu32SportsListSize) const;
    tVoid vGetDPRootListSize(tU32& dpu32RootListSize) const;
    tVoid vSetDPRootListSize(tU32 dpu32RootListSize) const;
    tVoid vGetDPFavoriteListSize(tU32& dpu32FavoriteListSize) const;
    tVoid vSetDPFavoriteListSize(tU32 dpu32FavoriteListSize) const;
    tVoid vGetDBErrorConfig();
    tVoid vSetDBErrorConfig();

    tVoid vGetDPMoviesFavoriteListSize(tU32& u32DpMoviesFavoriteListSize) const;
    tVoid vSetDPMoviesFavoriteListSize(tU32 u32DpMoviesFavoriteListSize) const;

    tVoid vGetDPFuelFavoriteListSize(tU32& u32DpFuelFavoriteListSize) const;
    tVoid vSetDPFuelFavoriteListSize(tU32 u32DpFuelFavoriteListSize) const;

    tVoid vGetDPCanFuelFavoriteListSize(tU32& u32DpCanFuelFavoriteListSize) const;
    tVoid vSetDPCanFuelFavoriteListSize(tU32 u32DpCanFuelFavoriteListSize) const;

    tVoid vGetDPStocksFavoriteListSize(tU32& u32DpStocksFavoriteListSize) const;
    tVoid vSetDPStocksFavoriteListSize(tU32 u32DpStocksFavoriteListSize) const;

    tVoid vClearDPMoviesFavoriteList();
    tVoid vClearDPFuelFavoriteList();
    tVoid vClearDPCanFuelFavoriteList();
    tVoid vClearDPStocksFavoriteList();
};

#endif
