/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_pers_app_data.cpp
* @brief       
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_common.h"
#include "fc_sxm_tcl_pers_data.h"
#include "fc_sxm_tcl_pers_app_data.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_CONFIG
#include "trcGenProj/Header/fc_sxm_tcl_pers_app_data.cpp.trc.h"
#endif

/* Sports user data class constructor */
trAppUserData::trAppUserData()
{
    ETG_TRACE_USR4(("trAppUserData() constructor"));

    /* Clear all list data */
    vClearMoviesFavoriteList();
    vClearFuelFavoriteList();
    vClearCanFuelFavoriteList();
    vClearStocksFavoriteList();
}

/* Sports user data class destructor */
trAppUserData::~trAppUserData()
{
    ETG_TRACE_USR4(("trAppUserData() destructor"));

    /* Clear all list data */
    vClearMoviesFavoriteList();
    vClearFuelFavoriteList();
    vClearCanFuelFavoriteList();
    vClearStocksFavoriteList();
}

tVoid trAppUserData::vClearInternalFavoriteList(tVoid)
{
    ETG_TRACE_USR4(("trAppUserData::vClearInternalFavoriteList()"));
    /* Clear all list data */
    vClearMoviesFavoriteList();
    vClearFuelFavoriteList();
    vClearCanFuelFavoriteList();
    vClearStocksFavoriteList();
}

/* Show sport list data */
tVoid trAppUserData::vPrintAppList(tVoid)
{
    ETG_TRACE_USR4(("trAppUserData::vPrintAppList()"));

    /*vector<trAppListElement>::const_iterator iter;
	tSXMDataService_ProtectedMoviesFavoriteList trData = _mProtectedMoviesFavoriteList.rGet();
	for(iter=trData.vMoviesFavoriteList.begin(); iter!=trData.vMoviesFavoriteList.end(); ++iter) {
		ETG_TRACE_USR2(("App list: Loc ID - %d", (*iter).u32LocID));
	}*/
}

/* Clear Movies list */
tVoid trAppUserData::vClearMoviesFavoriteList(tVoid)
{
    ETG_TRACE_USR4(("trAppUserData::vClearMoviesFavoriteList()"));

    tSXMDataService_ProtectedMoviesFavoriteList trData = _mProtectedMoviesFavoriteList.rGet();
    trData.vMoviesFavoriteList.clear();
    _mProtectedMoviesFavoriteList.vSet(trData);
}

/* Clear Fuel list */
tVoid trAppUserData::vClearFuelFavoriteList(tVoid)
{
    ETG_TRACE_USR4(("trAppUserData::vClearFuelFavoriteList()"));

    tSXMDataService_ProtectedFuelFavoriteList trData = _mProtectedFuelFavoriteList.rGet();
    trData.vFuelFavoriteList.clear();
    _mProtectedFuelFavoriteList.vSet(trData);
}

/* Clear Canadian fuel list */
tVoid trAppUserData::vClearCanFuelFavoriteList(tVoid)
{
    ETG_TRACE_USR4(("trAppUserData::vClearCanFuelFavoriteList()"));

    tSXMDataService_ProtectedCanFuelFavoriteList trData = _mProtectedCanFuelFavoriteList.rGet();
    trData.vCanFuelFavoriteList.clear();
    _mProtectedCanFuelFavoriteList.vSet(trData);
}

/* Clear Stocks list */
tVoid trAppUserData::vClearStocksFavoriteList(tVoid)
{
    ETG_TRACE_USR4(("trAppUserData::vClearStocksFavoriteList()"));

    tSXMDataService_ProtectedStocksFavoriteList trData = _mProtectedStocksFavoriteList.rGet();
    trData.vStocksFavoriteList.clear();
    _mProtectedStocksFavoriteList.vSet(trData);
}



/* Set Favorite list based on service ID */
tVoid trAppUserData::vSetFavoriteList(fc_sxm_tenServiceID u32ServiceID, const vector<tU32>& vecLocID)
{
    ETG_TRACE_USR4(("trAppUserData::vSetAppList() ServiceId; %d", u32ServiceID));

    switch(u32ServiceID)
    {
    case fc_sxm_enServiceID_Movies:
    {
        /* Get list */
        tSXMDataService_ProtectedMoviesFavoriteList trData = _mProtectedMoviesFavoriteList.rGet();

        /* Update list */
        trData.vMoviesFavoriteList = vecLocID;
        /* Store list */
        _mProtectedMoviesFavoriteList.vSet(trData);
        vSetMoviesFavoriteListData();
    }
    break;
    case fc_sxm_enServiceID_Fuel:
    {
        /* Get list */
        tSXMDataService_ProtectedFuelFavoriteList trData = _mProtectedFuelFavoriteList.rGet();

        /* Update list */
        trData.vFuelFavoriteList = vecLocID;
        /* Store list */
        _mProtectedFuelFavoriteList.vSet(trData);
        vSetFuelFavoriteListData();
    }
    break;
    case fc_sxm_enServiceID_Canadian_Fuel:
    {
        /* Get list */
        tSXMDataService_ProtectedCanFuelFavoriteList trData = _mProtectedCanFuelFavoriteList.rGet();

        /* Update list */
        trData.vCanFuelFavoriteList = vecLocID;
        /* Store list */
        _mProtectedCanFuelFavoriteList.vSet(trData);
        vSetCanFuelFavoriteListData();
    }
    break;
    default :
        break;
    }
}

/* Set Favorite list for Stocks */
tVoid trAppUserData::vSetFavoriteList(const vector<string>& vecStringID)
{
    ETG_TRACE_USR4(("trAppUserData::vSetStocksFavoriteList()"));
    tSXMDataService_ProtectedStocksFavoriteList trData = _mProtectedStocksFavoriteList.rGet();

    /* Update list */
    trData.vStocksFavoriteList = vecStringID;
    /* Store list */
    _mProtectedStocksFavoriteList.vSet(trData);
    vSetStocksFavoriteListData();
}


/* Get Favorite list based on service ID */
tVoid trAppUserData::vGetFavoriteList(fc_sxm_tenServiceID u32ServiceID, vector<tU32>& vecLocID)
{
    ETG_TRACE_USR4(("trAppUserData::vGetAppList() service ID: %d", u32ServiceID));

    switch(u32ServiceID)
    {
    case fc_sxm_enServiceID_Movies:
    {
        tSXMDataService_ProtectedMoviesFavoriteList trData = _mProtectedMoviesFavoriteList.rGet();
        vecLocID = trData.vMoviesFavoriteList;
    }
    break;
    case fc_sxm_enServiceID_Fuel:
    {
        tSXMDataService_ProtectedFuelFavoriteList trData = _mProtectedFuelFavoriteList.rGet();
        vecLocID = trData.vFuelFavoriteList;
    }
    break;
    case fc_sxm_enServiceID_Canadian_Fuel:
    {
        tSXMDataService_ProtectedCanFuelFavoriteList trData = _mProtectedCanFuelFavoriteList.rGet();
        vecLocID = trData.vCanFuelFavoriteList;
    }
    break;
    default :
        break;
    }

}

/* Get Favorite list for Stocks */
tVoid trAppUserData::vGetFavoriteList(vector<string>& vecStringID)
{
    tSXMDataService_ProtectedStocksFavoriteList trData = _mProtectedStocksFavoriteList.rGet();
    vecStringID = trData.vStocksFavoriteList;

    ETG_TRACE_USR4(("vGetStocksFavoriteList::vecStringID size: %d", (tU32)(vecStringID.size())));

}

/* Get data */
tVoid trAppUserData::vGetData(tVoid)
{
    ETG_TRACE_USR4(("trAppUserData::vGetData()"));

    vGetMoviesFavoriteListData();     /* App list */
    vGetFuelFavoriteListData();     /* Fuel list */
    vGetCanFuelFavoriteListData();     /* Canadian Fuel list */
    vGetStocksFavoriteListData();
}


/* Get data from persistence memory and store it in movies list */
tVoid trAppUserData::vGetMoviesFavoriteListData()
{
    tSXMDataService_ProtectedMoviesFavoriteList trData = _mProtectedMoviesFavoriteList.rGet();
    //Before writing,Clear of our old internal data if any
    trData.vMoviesFavoriteList.clear();

    fc_sxm_tclPersData::instance()->vGetDPMoviesFavoriteList(trData);
    ETG_TRACE_USR4(("trAppUserData::vGetMoviesFavoriteListData() u32MoviesFavoriteListSize=%d",(tU32)(trData.vMoviesFavoriteList.size())));

    _mProtectedMoviesFavoriteList.vSet(trData);

}

/* Get data from persistence memory and store it in fuel list */
tVoid trAppUserData::vGetFuelFavoriteListData()
{
    tSXMDataService_ProtectedFuelFavoriteList trData = _mProtectedFuelFavoriteList.rGet();
    //Before writing,Clear of our old internal data if any
    trData.vFuelFavoriteList.clear();

    fc_sxm_tclPersData::instance()->vGetDPFuelFavoriteList(trData);
    ETG_TRACE_USR4(("trAppUserData::vGetFuelFavoriteListData() u32FuelFavoriteListSize=%d",(tU32)(trData.vFuelFavoriteList.size())));

    _mProtectedFuelFavoriteList.vSet(trData);

}

/* Get data from persistence memory and store it in canadian fuel list */
tVoid trAppUserData::vGetCanFuelFavoriteListData()
{
    tSXMDataService_ProtectedCanFuelFavoriteList trData = _mProtectedCanFuelFavoriteList.rGet();
    //Before writing,Clear of our old internal data if any
    trData.vCanFuelFavoriteList.clear();

    fc_sxm_tclPersData::instance()->vGetDPCanFuelFavoriteList(trData);
    ETG_TRACE_USR4(("trAppUserData::vGetCanFuelFavoriteListData() u32CanFuelFavoriteListSize=%d",(tU32)(trData.vCanFuelFavoriteList.size())));

    _mProtectedCanFuelFavoriteList.vSet(trData);

}

/* Get data from persistence memory and store it in canadian fuel list */
tVoid trAppUserData::vGetStocksFavoriteListData()
{
    tSXMDataService_ProtectedStocksFavoriteList trData = _mProtectedStocksFavoriteList.rGet();
    //Before writing,Clear of our old internal data if any
    trData.vStocksFavoriteList.clear();

    fc_sxm_tclPersData::instance()->vGetDPStocksFavoriteList(trData);
    ETG_TRACE_USR4(("trAppUserData::vGetStocksFavoriteListData() u32StocksFavoriteListSize=%d",(tU32)(trData.vStocksFavoriteList.size())));

    _mProtectedStocksFavoriteList.vSet(trData);
}


/* Set data */
tVoid trAppUserData::vSetData(tVoid)
{
    ETG_TRACE_USR4(("trAppUserData::vSetData()"));

    vSetMoviesFavoriteListData();     /* movies list */
    vSetFuelFavoriteListData();       /* fuel list */
    vSetCanFuelFavoriteListData();     /* Canadian fuel list */
    vSetStocksFavoriteListData();
}

/* Set Movies list data into binary data to persist across power cycle */
tVoid trAppUserData::vSetMoviesFavoriteListData(tVoid)
{
    tSXMDataService_ProtectedMoviesFavoriteList trData = _mProtectedMoviesFavoriteList.rGet();
    tU32 u32MoviesFavoriteListSize = (tU32)(trData.vMoviesFavoriteList.size());
    ETG_TRACE_USR4(("trAppUserData::vSetMoviesFavoriteListData() u32MoviesFavoriteListSize=%d",u32MoviesFavoriteListSize));

    fc_sxm_tclPersData::instance()->vSetDPMoviesFavoriteList(trData);

    //Finally Clear of our old internal data
    trData.vMoviesFavoriteList.clear();
}

/* Set Fuel list data into binary data to persist across power cycle */
tVoid trAppUserData::vSetFuelFavoriteListData(tVoid)
{
    tSXMDataService_ProtectedFuelFavoriteList trData = _mProtectedFuelFavoriteList.rGet();
    tU32 u32FuelFavoriteListSize = (tU32)(trData.vFuelFavoriteList.size());
    ETG_TRACE_USR4(("trAppUserData::vSetFuelFavoriteListData() u32FuelFavoriteListSize=%d",u32FuelFavoriteListSize));

    fc_sxm_tclPersData::instance()->vSetDPFuelFavoriteList(trData);

    //Finally Clear of our old internal data
    trData.vFuelFavoriteList.clear();
}

/* Set Canadian fuel list data into binary data to persist across power cycle */
tVoid trAppUserData::vSetCanFuelFavoriteListData(tVoid)
{
    tSXMDataService_ProtectedCanFuelFavoriteList trData = _mProtectedCanFuelFavoriteList.rGet();
    tU32 u32CanFuelFavoriteListSize = (tU32)(trData.vCanFuelFavoriteList.size());
    ETG_TRACE_USR4(("trAppUserData::vSetCanFuelFavoriteListData() u32CanFuelFavoriteListSize=%d",u32CanFuelFavoriteListSize));

    fc_sxm_tclPersData::instance()->vSetDPCanFuelFavoriteList(trData);

    //Finally Clear of our old internal data
    trData.vCanFuelFavoriteList.clear();
}

/* Set stocks list data into binary data to persist across power cycle */
tVoid trAppUserData::vSetStocksFavoriteListData(tVoid)
{
    tSXMDataService_ProtectedStocksFavoriteList trData = _mProtectedStocksFavoriteList.rGet();
    tU32 u32StocksFavoriteListSize = (tU32)(trData.vStocksFavoriteList.size());
    ETG_TRACE_USR4(("trAppUserData::vSetStocksFavoriteListData() u32StocksFavoriteListSize=%d",u32StocksFavoriteListSize));

    fc_sxm_tclPersData::instance()->vSetDPStocksFavoriteList(trData);

    //Finally Clear of our old internal data
    trData.vStocksFavoriteList.clear();
}

