/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_data_lists.h
* @brief       Declaration of data lists handling
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCK_DATA_LISTS_H
#define FC_SXM_TCK_DATA_LISTS_H
#include "fc_sxm_tcl_data_list.hpp"

// state of data-lists of a data-app
class fc_sxm_tclDataLists {
 public:
    fc_sxm_tclDataLists():
        _u16TraceClass(TR_CLASS_FC_SXM_BASE_APP)
    {}
    tVoid vAdd(fc_sxm_tclDataListBase *poDataList, fc_sxm_listStatusInfo const &rListInfo);
    tVoid vRemove(fc_sxm_tclDataListBase *poDataList);

    fc_sxm_tclDataListBase *poGetById(tU32 u32Id);
    fc_sxm_tclDataListBase *poGetListByDsrl(fc_sxm_tclBaseDSRL const *poBaseDsrl);

    // update info according to given list poList
    tBool bUpdate(fc_sxm_tclDataListBase *poList);

    // utility to copy data to fi-type
    tVoid vCopyListInfosToFi(midw_ext_fi_tcl_SxmListInfos &rFiOut) const;
    /* 
       we store a copy of state-data of each list because we must know, which items have changed.
       notifications will only be sent if specific data have changed
    */
    map<fc_sxm_tclDataListBase *, fc_sxm_listStatusInfo> mapLists;

    tVoid vPrintReport() const;

 private:
    tU16 _u16TraceClass;

};

#endif
