/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_data_app.cpp
* @brief       Implementation of data apps apis
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

// just take any data-fi
#include "fc_sxm_fuel_fi.h"
#include "fc_sxm_sms_util.h"
#include "fc_sxm_tcl_pers_data.h"
#include "fc_sxm_tcl_audio_app.h"
#include "fc_sxm_tcl_diag_defset.h"
#include "fc_sxm_tcl_diagtm_handler.h"
#include "fc_sxm_tcl_pers_app_data.h"

#include "fc_sxm_tcl_sxmapp_manager.h"
#include "fc_sxm_tcl_data_app.h"

#include "fc_sxm_tcl_states.h"

#ifndef FC_SXM_SPORTS_UTEST
#include "fc_sxm_tcl_sports_app.h"
#else
#include "sports/fc_sxm_tcl_sports_app.h"
#endif //end of FC_SXM_SPORTS_UTEST

#ifndef FC_SXM_PARKING_UTEST
#include "fc_sxm_tcl_parking_app.h"
#endif


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"


/*
  todo: create reasonable trace-classes.
  one trace-class per file is too much.
*/
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_BASE_APP
#include "trcGenProj/Header/fc_sxm_tcl_data_app.cpp.trc.h"
#endif

tVoid fc_sxm_tclDsrlList::vSetLocation(fc_sxm_trDsrlLocation const &rLocation, fc_sxm_tenDSRLType enDsrlType) {
    SXM_FOREACH(deque<fc_sxm_tclBaseDSRL *>, iter, _oQ) {
        fc_sxm_tclBaseDSRL *poDsrl=*iter;
        if (OSAL_NULL != poDsrl) {
            if (poDsrl->enGetDSRLType()==enDsrlType) {
                poDsrl->vSetLocation(rLocation);                    
            }
        }
    }
}

tVoid fc_sxm_tclDsrlList::vRestart() {
    SXM_FOREACH(deque<fc_sxm_tclBaseDSRL *>, iter, _oQ) {
        fc_sxm_tclBaseDSRL *poDsrl=*iter;
        if (OSAL_NULL != poDsrl) {
            poDsrl->vSetNextConfig();
        }
    }
}

tVoid fc_sxm_tclDsrlList::vOnSmsServiceStateChanged(tBool bSmsServiceStopping) {
    SXM_FOREACH(deque<fc_sxm_tclBaseDSRL *>, iter, _oQ) {
        fc_sxm_tclBaseDSRL *poDsrl=*iter;
        if (OSAL_NULL != poDsrl) {
            poDsrl->vOnSmsServiceStateChanged(bSmsServiceStopping);
        }
    }
}

tVoid fc_sxm_tclDsrlList::vPrintReport() {
    SXM_FOREACH(deque<fc_sxm_tclBaseDSRL *>, iter, _oQ) {
        fc_sxm_tclBaseDSRL *poDsrl=*iter;
        if (OSAL_NULL != poDsrl) {
            poDsrl->vPrintReport();
        }
    }
}


fc_sxm_tclDataListBase* fc_sxm_tclDataApp::poGetActiveListbyDSRL(fc_sxm_tclBaseDSRL *poBaseDsrl) {
    fc_sxm_tclDataListBase *poNewActiveList=_oDataLists.poGetListByDsrl(poBaseDsrl);
    if (NULL != poNewActiveList) {
        poNewActiveList->vOnDsrlUpdateStart();
    }
    return poNewActiveList;
}

tVoid fc_sxm_tclDataApp::vOnDsrlState(fc_sxm_tclBaseDSRL *poBaseDsrl, fc_sxm_tenDsrlState enDsrlState,tBool bDataAvailable) {
    fc_sxm_tclDataListBase *poList=_oDataLists.poGetListByDsrl(poBaseDsrl);
    ETG_TRACE_USR2_DCL((_u16TraceClass, "fc_sxm_tclDataApp(%10s) ::vOnDsrlState(poBaseDsrl=0x%08x Type=%d enDsrlState=%d bDataAvailable=%d poList=0x%08x)",
                    szGetName(),
                    poBaseDsrl,
                    ETG_CENUM(fc_sxm_tenDSRLType, poBaseDsrl->enGetDSRLType()),
                    ETG_CENUM(fc_sxm_tenDsrlState, enDsrlState),
                    bDataAvailable,
                    poList));

    if (NULL != poList)
    {
        poList->vOnSmsDsrlState(enDsrlState,bDataAvailable);
    }
}

tVoid fc_sxm_tclDataApp::vUpdateListInfo(fc_sxm_tclDataListBase *poDataList) {
    if (_oDataLists.bUpdate(poDataList)) {
        vOnListStateChanged(poDataList);
    }
}

/*
  generic dispatch-method for all thread-messages
*/
// todo: make poThreadMsg const --> all vProcess must be changed to const parameter first
tVoid fc_sxm_tclDataApp::vDispatchMsgFromQInternal(fc_sxm_tclMessage const *poThreadMsg) {
    tU32 u32Action=poThreadMsg->u32GetAction();
    fc_sxm_tenServiceID enServiceId=fc_sxm_enGetServiceId(u32Action);
        ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vDispatchMsgFromQInternal(): u32Action=0x%x bWantsMsg=%d enServiceId=%d",
                            u32Action, bWantsMsg(u32Action), ETG_CENUM(fc_sxm_tenServiceID, enServiceId)));
    if (!bWantsMsg(u32Action)) {
        /* message is not for us */
    }
    else if (enServiceId==fc_sxm_enServiceID_All) {
        // dispatch messge that are for all services
        fc_sxm_tclBaseApp::vDispatchMsgFromQInternal(poThreadMsg);
    } else if (enServiceId==fc_sxm_enServiceID_AllData) {
        // dispatch messge that are for all data-services
        switch (u32Action) {
            // commands from cca-context
       
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgCmdDataAppStartService);
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgCmdDataAppStopService);
 
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataSmsEvtServiceUp);
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgCmdDataAppCreateDsrl);
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataAppSetDeviceLocation);
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataAppNavPosition);
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataAppSetDestLocation);
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgCmdDataAppAntennaState);
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgCmdDataAppSignalState);
            
            // messages representing sms-callbacks
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataSmsEvtServiceState);

            /* DSRL-state is directly dispatched to the specific DSRL */
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataSmsEvtDsrlState);
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataAppSetClockParams);
        SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataAppSetClockParameters);

#if 0
            SXM_MSGQ_DISPATCH(fc_sxm_trMsgCmdDataAppStartService);
                  SXM_MSGQ_DISPATCH(fc_sxm_trMsgCmdDataAppStopService);
                  SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataSmsEvtServiceUp);
                  SXM_MSGQ_DISPATCH(fc_sxm_trMsgCmdDataAppCreateDsrl);
                  SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataAppSetDeviceLocation);
                  SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataAppSetDestLocation);
                  SXM_MSGQ_DISPATCH(fc_sxm_trMsgCmdDataAppAntennaState);
                  SXM_MSGQ_DISPATCH(fc_sxm_trMsgCmdDataAppSignalState);

                  // messages representing sms-callbacks
                  SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataSmsEvtServiceState);

                  /* DSRL-state is directly dispatched to the specific DSRL */
                  SXM_MSGQ_DISPATCH(fc_sxm_trMsgDataSmsEvtDsrlState);
#endif
            default:
                ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vDispatchMsgFromQInternal(): calling vDispatchMsgFromQ on fc_sxm_enServiceID_AllData"));
                vDispatchMsgFromQ(poThreadMsg);
                break;  
        }
    }  else {
        vDispatchMsgFromQ(poThreadMsg);
    }
}



tVoid fc_sxm_tclDataApp::vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtDsrlState const *prMsg){
    fc_sxm_tclBaseDSRL *poDsrl=poGetDsrl(prMsg->u32DsrlId);
    if (OSAL_NULL != poDsrl) {
        /* OK,  dsrl is still valid */
        poDsrl->vOnSmsDsrlState(prMsg->enState);
    }
}


fc_sxm_tclBaseDSRL *fc_sxm_tclDataApp::poGetDsrl(tU32 u32DsrlId) {
    fc_sxm_tclBaseDSRL *poResObj=_oDsrlList.poGetAhlObject((tU16)u32DsrlId);
    if ( OSAL_NULL != poResObj )
    {
        ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::poGetDsrl(u32DsrlId=0x%08x) --> poResObj=0x%08x (_hSmsDSRL=0x%08x)",
                        u32DsrlId, poResObj, poResObj->hGetSMSDSRL()));       
    }
    return poResObj;
}
fc_sxm_tclBaseDSRL *fc_sxm_tclDataApp::poRegisterDsrl(fc_sxm_tclBaseDSRL *poDsrl) {
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::poRegisterDsrl(u32DsrlId=0x%08x) --> poResObj=0x%08x (_hSmsDSRL=0x%08x)",
                    poDsrl->u32GetId(), poDsrl, poDsrl->hGetSMSDSRL()));       
    return _oDsrlList.poAdd(poDsrl);
}

tVoid fc_sxm_tclDataApp::vUnregisterDsrl(fc_sxm_tclBaseDSRL *poDsrl) {
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vUnregisterDsrl(u32DsrlId=0x%08x) --> poResObj=0x%08x (_hSmsDSRL=0x%08x)",
                    poDsrl->u32GetId(), poDsrl, poDsrl->hGetSMSDSRL()));       
    _oDsrlList.vRemoveAhlObject(poDsrl->u32GetId());
}

tVoid fc_sxm_tclDataApp::vAddDataList(fc_sxm_tclDataListBase *poDataList, fc_sxm_listStatusInfo const &rListInfo) {
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vAddDataList(poDataList=0x%08x)",poDataList));
    _oDataLists.vAdd(poDataList, rListInfo);
}

tVoid fc_sxm_tclDataApp::vRemoveDataList(fc_sxm_tclDataListBase *poDataList) {
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vRemoveDataList(poDataList=0x%08x)",poDataList));
    _oDataLists.vRemove(poDataList);
}

tVoid fc_sxm_tclDataApp::vOnListStateChanged(fc_sxm_tclDataListBase *poDataList) {
    ETG_TRACE_ERR_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vOnListStateChanged(poDataList=0x%08x) PLEASE OVERWRITE",poDataList));
}

tVoid fc_sxm_tclDataApp::vSendList(tU32 u32ListId, fc_sxm_trAdressing const &rAdressing) {
    fc_sxm_tclDataListBase *poList=_oDataLists.poGetById(u32ListId);
    if (OSAL_NULL == poList) {
        ETG_TRACE_ERR_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vSendList(u32ListId=%d) not found",u32ListId));
        fc_sxm_vSendError(rAdressing); // todo: add error-code for unknown list-id to fi
        return;
    }
    poList->vRequest(rAdressing);
}

tVoid fc_sxm_tclDataApp::vSetListMode(tU32 u32ListId, fc_sxm_trAdressing const &rAdressing, fc_sxm_tenListMode enListMode) {
    fc_sxm_tclDataListBase *poList=_oDataLists.poGetById(u32ListId);
    if (OSAL_NULL == poList) {
        ETG_TRACE_ERR_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vSetListMode(u32ListId=%d) list not found", u32ListId));
        return;
    }
    _u32ListID = u32ListId;
    poList->vSetListMode(rAdressing, enListMode);
}

DATASERVICE_STATE_ENUM fc_sxm_tclDataApp::enGetSmsServiceState() const {
    if  (_bSmsServiceStopping) {
        return DATASERVICE_STATE_STOPPED;
    } else {
        return _enSmsServiceState;
    }
}
DATA_PRODUCT_STATE_ENUM fc_sxm_tclDataApp::enGetDataProductState(DATASERVICE_MGR_OBJECT hDataService) const {
   (tVoid)hDataService;
   return DATA_PRODUCT_STATE_READY;
}

tVoid fc_sxm_tclDataApp::vProcessGenericMsg(fc_sxm_trMsgDataAppSetDestLocation const *prMsg){

   /* Check If same Location is set again */ 
   if((_rDestLocation.s32Latitude==prMsg->rLocation.s32Latitude)&&
            (_rDestLocation.s32Longitude==prMsg->rLocation.s32Longitude))
    {
        ETG_TRACE_USR4_DCL((_u16TraceClass,"Same lat lon receive from NAVI"));
        return;
    }
    _rDestLocation=prMsg->rLocation;

    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::fc_sxm_trMsgDataAppSetDestLocation: lat=%d lon=%d",
                    _rDestLocation.s32Latitude, _rDestLocation.s32Longitude));

    _oDsrlList.vSetDestLocation(_rDestLocation);

    /* Send updating state to HMI to show "loading..." popup to user
       till we recieve DSRL state ready from SMS */
    fc_sxm_tclDataListBase *poList=_oDataLists.poGetById((tU32)fc_sxm_tenListType_NearDest);
    if (OSAL_NULL != poList) {
        poList->vNotifyUpdatingState();
    }
}

tVoid fc_sxm_tclDataApp::vProcessGenericMsg(fc_sxm_trMsgDataAppSetDeviceLocation const *prMsg){
    _rDeviceLocation=prMsg->rLocation;
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::fc_sxm_trMsgDataAppSetDeviceLocation: lat=%d lon=%d",
                    _rDeviceLocation.s32Latitude, _rDeviceLocation.s32Longitude));
    fc_sxm_tclDataListBase *poNearbyList=_oDataLists.poGetById((tU32)fc_sxm_tenListType_NearBy);
    if (OSAL_NULL != poNearbyList) {
        poNearbyList->vSetLocation(prMsg->rLocation);
    }

    fc_sxm_tclDataListBase *poFavList=_oDataLists.poGetById((tU32)fc_sxm_tenListType_Favorites);
    if (OSAL_NULL != poFavList) {
        poFavList->vSetLocation(prMsg->rLocation);
    }
    fc_sxm_tclDataListBase *poList=_oDataLists.poGetById((tU32)fc_sxm_tenListType_NearDest);
    if (OSAL_NULL != poList) {
        poList->vSetLocation(prMsg->rLocation);
    }
}
tVoid fc_sxm_tclDataApp::vProcessGenericMsg(fc_sxm_trMsgDataAppNavPosition const *prMsg){
    if(_rNavLocation!=prMsg->rNavLocation)
    {
        ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::fc_sxm_trMsgDataAppNavPosition: lat=%d lon=%d",
                prMsg->rNavLocation.s32Latitude, prMsg->rNavLocation.s32Longitude));

        _rNavLocation=prMsg->rNavLocation;

        //finally inform about new Navi Position
        vOnNewDevicePosition(_rNavLocation);
    }
}
tVoid fc_sxm_tclDataApp::vProcessGenericMsg(fc_sxm_trMsgCmdDataAppAntennaState const *prMsg)
{
    (void)prMsg;
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vProcess(fc_sxm_trMsgCmdDataAppAntennaState()"));
}

tVoid fc_sxm_tclDataApp::vProcessGenericMsg(fc_sxm_trMsgCmdDataAppSignalState const *prMsg)
{
    (void)prMsg;
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vProcess(fc_sxm_trMsgCmdDataAppSignalState()"));
}

tVoid fc_sxm_tclDataApp::cb_vDataServiceEventCallback(DATASERVICE_MGR_OBJECT hDataService,
                                   DATASERVICE_EVENT_MASK tEventMask,
                                   tVoid *pvEventCallback) {
    fc_sxm_tclDataApp *poThis= (fc_sxm_tclDataApp *)pvEventCallback;
    if (OSAL_NULL == poThis) {
        return;
    }

    fc_sxm_trMsgDataSmsEvtServiceState rMsg;
    rMsg.eState = poThis->enRequestSmsServiceState(hDataService);
    rMsg.enErrorCode =poThis->enRequestSmsServiceErrorCode(hDataService);
    ETG_TRACE_USR2_DCL((poThis->u16GetTraceClass(), "fc_sxm_tclDataApp(%10s)::cb_vDataServiceEventCallback: State=%d, Product State=%d, enError=%d tEventMask=0x%08x DATASERVICE_EVENT_STATE=%d",
                        poThis->szGetName(), ETG_CENUM(DATASERVICE_STATE_ENUM, rMsg.eState),
                        ETG_CENUM(DATA_PRODUCT_STATE_ENUM, rMsg.eProductState),
                        ETG_CENUM(DATASERVICE_ERROR_CODE_ENUM, rMsg.enErrorCode), tEventMask,
                        (tEventMask & DATASERVICE_EVENT_STATE) ? 1 : 0));
   if (tEventMask & DATASERVICE_EVENT_STATE || tEventMask & CHANNEL_ART_SERVICE_EVENT_CHAN_PROD_STATE || tEventMask & CHANNEL_ART_SERVICE_EVENT_ALBUM_PROD_STATE)
   {
        if (rMsg.eState == DATASERVICE_STATE_READY)
           rMsg.eProductState = poThis->enGetDataProductState(hDataService);

        //Send a message to process the state transition
        poThis->vPostMsgNew(rMsg);
   }

}


tVoid fc_sxm_tclDataApp::cb_vDataGenericServiceEventCallback(
                                                             DATASERVICE_MGR_OBJECT hDataService,
                                                             DATASERVICE_EVENT_MASK tCurrentEvent,
                                                             tVoid *pvEventArg,
                                                             tVoid *pvEventCallbackArg)
{

    fc_sxm_tclDataApp *poThis= (fc_sxm_tclDataApp *)pvEventCallbackArg;
    if (OSAL_NULL == poThis) {
        return;
    }    
 
    /* check the event state received from SMS */
    if (tCurrentEvent & DATASERVICE_EVENT_STATE)
    {
        fc_sxm_trMsgDataSmsEvtServiceState rMsg;
        rMsg.eState = DATA.eState((DATASERVICE_MGR_OBJECT)hDataService );
        rMsg.eProductState = poThis->enGetDataProductState(hDataService);
        rMsg.enErrorCode=poThis->enRequestSmsServiceErrorCode(hDataService);
        ETG_TRACE_USR2_DCL((poThis->u16GetTraceClass(), "fc_sxm_tclDataApp(%10s)::cb_vDataGenericServiceEventCallback(DATASERVICE_EVENT_STATE): State=%d enError=%d",
                        poThis->szGetName(), ETG_CENUM(DATASERVICE_STATE_ENUM, rMsg.eState), 
                        ETG_CENUM(DATASERVICE_ERROR_CODE_ENUM, rMsg.enErrorCode)));
        /* Send a message to process the state transition */
        poThis->vPostMsgNew(rMsg);
    }
 
    if (tCurrentEvent & DATASERVICE_EVENT_NEW_DATA)
    {
        ETG_TRACE_USR4_DCL((poThis->u16GetTraceClass(), "fc_sxm_tclDataApp(%10s)::DATASERVICE_EVENT_NEW_DATA", poThis->szGetName()));

        OSAL_BUFFER_HDL pvPayload = (OSAL_BUFFER_HDL)pvEventArg;
        if(OSAL_INVALID_BUFFER_HDL != pvPayload)
        {
           fc_sxm_trMsgDataPayLoad rPayloadMsg;
           if(poThis->bParseServiceSpecificPayloadHeader(pvPayload, rPayloadMsg))
           {
               /* Send the payload message to fetch the TMC data */
               poThis->vPostMsgNew(rPayloadMsg);
           }
           /* free the memory allocated by sms */
           OSAL.eBufferFree(pvPayload);
        }       
    }
}


tVoid fc_sxm_tclDataApp::cb_vDataSportsServiceCallback(tS32 s32SportsStae, tS32 s32SubscritionStatus)
{
    ETG_TRACE_USR4(("fc_sxm_tclDataApp::cb_vDataServiceSpoprtsCallback"));
    fc_sxm_tclDataApp *poThis = (fc_sxm_tclDataApp *) (fc_sxm_tclSportsApp::instance()->pGetSportsAppReference());
    if (OSAL_NULL == poThis) {
        return;
    }
    fc_sxm_trMsgDataSmsEvtServiceState rMsg;
    tS32 s32SXMSportsServiceStatus;
    SXMStatus rSXMSportsServiceStatus;
    switch(s32SportsStae)
    {
       case SXM_CALLBACK_SPORTS_UPDATED:
       {
           ETG_TRACE_USR4(("Sports service is ready"));
           // send a message to sports app to retrive the data
           fc_sxm_trMsgDataSportsState rSportsUpdateState;
           rSportsUpdateState.s32SportsState = SXM_CALLBACK_SPORTS_UPDATED;
           poThis->vPostMsgNew(rSportsUpdateState);
       }
       break;
       case SXM_CALLBACK_SPORTS_UPDATING:
       {
           ETG_TRACE_USR4(("wait sports service is updating "));
           // send a message to sports app not to retrive the data
           fc_sxm_trMsgDataSportsState rSportsUpdateState;
           rSportsUpdateState.s32SportsState = SXM_CALLBACK_SPORTS_UPDATING;
           poThis->vPostMsgNew(rSportsUpdateState);
       }
       break;
       case SXM_CALLBACK_ERROR:
       {
           ETG_TRACE_USR4(("Sports service reports error:%d param %d ",s32SportsStae,s32SubscritionStatus));
           rMsg.eState = DATASERVICE_STATE_ERROR;
           rMsg.eProductState = DATA_PRODUCT_STATE_READY;
           rMsg.enErrorCode = DATASERVICE_ERROR_CODE_NONE;
           poThis->vPostMsgNew(rMsg);
       }
       break;
       case SXM_CALLBACK_SUBS:
       {
           s32SXMSportsServiceStatus = sxm_sports_status(&rSXMSportsServiceStatus);
           ETG_TRACE_USR4(("Sports service: status %d",s32SXMSportsServiceStatus));
           tBool bSend = bGetSDKServiceStatus(rMsg,rSXMSportsServiceStatus.service,s32SubscritionStatus);
           if(bSend)
           {
               poThis->vPostMsgNew(rMsg);
           }
       }
       break;
       default:
       {
           ETG_TRACE_USR4(("Sports service default state:%d param %d ",s32SportsStae,s32SubscritionStatus));
       }
       break;

    }

}
/*
 * callback function to receive parking module-level event indications
 */
tVoid fc_sxm_tclDataApp::cb_vDataParkingServiceCallback(tS32 s32ParkingState, tS32 s32SubscritionStatus)
{
    ETG_TRACE_USR4(("fc_sxm_tclDataApp::cb_vDataParkingServiceCallback"));

    //take pakring app reference
    fc_sxm_tclDataApp *poThis = (fc_sxm_tclDataApp *) (fc_sxm_tclParkingApp::instance());

    //check for null
    if (OSAL_NULL == poThis) {
        ETG_TRACE_USR4(("fc_sxm_tclParkingApp reference not valid..."));
        return;
    }
    //Check parking state for subscription
    switch(s32ParkingState)
    {
        case SXM_CALLBACK_SUBS:
        {
            SXMStatus rSXMParkingServiceStatus;
            //find current parking state
            tS32 s32SXMParkingServiceStatus = sxm_parking_status(&rSXMParkingServiceStatus);

            ETG_TRACE_USR4(("Parking service: status %d",s32SXMParkingServiceStatus));

            fc_sxm_trMsgDataSmsEvtServiceState rMsg;
            tBool bSend = bGetSDKServiceStatus(rMsg, rSXMParkingServiceStatus.service, s32SubscritionStatus);
            if(bSend)
            {
                poThis->vPostMsgNew(rMsg);
            }
        }
        break;

        case SXM_CALLBACK_ERROR:
        {
            ETG_TRACE_USR4(("Parking service reports error:%d param %d ",s32ParkingState,s32SubscritionStatus));
            fc_sxm_trMsgDataSmsEvtServiceState rMsg;
            rMsg.eState = DATASERVICE_STATE_ERROR;
            rMsg.eProductState = DATA_PRODUCT_STATE_READY;
            rMsg.enErrorCode = DATASERVICE_ERROR_CODE_NONE;
            poThis->vPostMsgNew(rMsg);
        }
        break;

        default:
        {
            ETG_TRACE_USR4(("Parking service default state:%d param %d ",s32ParkingState,s32SubscritionStatus));
        }
        break;
    }
}
/*
 * prepares message based on Service & Subscription status
 */
tBool fc_sxm_tclDataApp::bGetSDKServiceStatus(fc_sxm_trMsgDataSmsEvtServiceState &rMsg, tS32 s32ServiceStatus, tS32 s32SubscritionStatus)
{
    tBool bSend = TRUE;
    //check Service status is OK
    if(s32ServiceStatus == SXM_SERVICE_OK)
    {
       //check for different Subscriptions possible
       if(s32SubscritionStatus == SXM_SUBS_NONE || s32SubscritionStatus == SXM_SUBS_PARTIAL )
       {
           ETG_TRACE_USR4(("sdk service is unsubscribed:%d",s32SubscritionStatus));
           rMsg.eState = DATASERVICE_STATE_UNSUBSCRIBED;
           rMsg.eProductState = DATA_PRODUCT_STATE_READY;
           rMsg.enErrorCode = DATASERVICE_ERROR_CODE_NONE;
       }
       else if(s32SubscritionStatus == SXM_SUBS_FULL)
       {

           ETG_TRACE_USR4(("sdk service is fully subscribed"));
           rMsg.eState = DATASERVICE_STATE_READY;
           rMsg.eProductState = DATA_PRODUCT_STATE_READY;
           rMsg.enErrorCode = DATASERVICE_ERROR_CODE_NONE;
       }
       else
       {
           ETG_TRACE_USR4(("sdk service subscription is unknown: %d ",s32SubscritionStatus));
           rMsg.eState = DATASERVICE_STATE_UNAVAILABLE;
           rMsg.eProductState = DATA_PRODUCT_STATE_READY;
           rMsg.enErrorCode = DATASERVICE_ERROR_CODE_NONE;
       }

    }
    //check Service is still in starting
    else if(s32ServiceStatus == SXM_SERVICE_STOPPING)
    {
       ETG_TRACE_USR4(("sdk service is stopping"));
       bSend = FALSE;
    }
    //check Service status is stopped
    else if(s32ServiceStatus == SXM_SERVICE_STOPPED)
    {
       ETG_TRACE_USR4(("sdk service stopped"));
       rMsg.eState = DATASERVICE_STATE_STOPPED;
       rMsg.eProductState = DATA_PRODUCT_STATE_READY;
       rMsg.enErrorCode = DATASERVICE_ERROR_CODE_NONE;
    }
    //check Service status is in error condition
    else
    {
       ETG_TRACE_USR4(("sdk service substatus state:%d param %d ",s32ServiceStatus,s32SubscritionStatus));
       bSend = FALSE;
    }
    return bSend;

}
tVoid fc_sxm_tclDataApp::vPrintReport() {
    ETG_TRACE_FATAL_CLS((TR_CLASS_FC_SXM_REPORT, ""));
    ETG_TRACE_FATAL_CLS((TR_CLASS_FC_SXM_REPORT, "\t%s:", szGetName()));
    ETG_TRACE_FATAL_CLS((TR_CLASS_FC_SXM_REPORT, "\t\tSmsServiceState=%u", 
                         ETG_CENUM(DATASERVICE_STATE_ENUM, _enSmsServiceState)));
    ETG_TRACE_FATAL_CLS((TR_CLASS_FC_SXM_REPORT, "\t\tSmsServiceError=%u", 
                         ETG_CENUM(DATASERVICE_ERROR_CODE_ENUM, _enSmsServiceErrorCode)));                         
    ETG_TRACE_FATAL_CLS((TR_CLASS_FC_SXM_REPORT, "\t\tDSRLS:"));
    _oDsrlList.vPrintReport();
    ETG_TRACE_FATAL_CLS((TR_CLASS_FC_SXM_REPORT, "\t\tLISTS:"));
    _oDataLists.vPrintReport();
    vPrintReportSpecific();
    //    ETG_TRACE_FATAL_CLS((TR_CLASS_FC_SXM_REPORT, "fc_sxm_tclDataApp::vPrintReport(%s) END", szGetName()));

}

tVoid fc_sxm_tclDataApp::vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceState const *prMsg) {
    DATASERVICE_STATE_ENUM enState=prMsg->eState;
    DATASERVICE_ERROR_CODE_ENUM enErrorCode=prMsg->enErrorCode;
    tBool bStopSmsService=FALSE;
    ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vProcessServiceState(%10s), State = %d-->%d Error-code=%d",
                    szGetName(),
                    ETG_CENUM(DATASERVICE_STATE_ENUM, _enSmsServiceState),
                    ETG_CENUM(DATASERVICE_STATE_ENUM, enState),
                    ETG_CENUM(DATASERVICE_ERROR_CODE_ENUM, enErrorCode)));

    if ( enState == DATASERVICE_STATE_INVALID ) {
      return;
    }
    
    // No need to make a transition from STOPPED to ERROR state. Fix for NCG3D-3826
    if ((_enSmsServiceState == DATASERVICE_STATE_STOPPED) &&
        (enState == DATASERVICE_STATE_ERROR)) {
      return;
    } 

    // Check the product state updates in READY state 
    if (enState == DATASERVICE_STATE_READY) {

       // Check if data products already enabled
       if (_bSmsServiceStopping == FALSE && _bDataProductsEnabled == FALSE) {
           _bDataProductsEnabled = bEnableDataProducts();
           return;
       }

       // If the product state not yet READY, nothing to do
       if(prMsg->eProductState != DATA_PRODUCT_STATE_READY) {
           //fix for NCG3D-2230
           if(prMsg->eProductState == DATA_PRODUCT_STATE_UNSUBSCRIBED)
           {
               enState =  DATASERVICE_STATE_UNSUBSCRIBED;
           }
           else
               return;
       }
    }
    else if (_enSmsServiceState == enState) {
            return;
    }

    midw_ext_fi_tcl_e8_SxmDataServiceStatus enOldFiSrvState=fc_sxm_oSmsDataServiceState2Fi(_enSmsServiceState);
    _enSmsServiceState=enState;
    _enSmsServiceErrorCode=enErrorCode;
    midw_ext_fi_tcl_e8_SxmDataServiceStatus enNewFiSrvState=fc_sxm_oSmsDataServiceState2Fi(_enSmsServiceState);

    switch(enState)
    {
        case DATASERVICE_STATE_INITIAL:
            break;

        case DATASERVICE_STATE_POI_UPDATES_ONLY:
            break;

        case DATASERVICE_STATE_UNSUBSCRIBED:
            break;

        case DATASERVICE_STATE_STOPPED:
        {
            ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vProcessServiceState(DATASERVICE_STATE_STOPPED):_bRestoreSmsDb=%d _u32StartCounter=%d bIsStartRequested=%d maxTrials=%d _oSmsConfigDir=%s",
                            _bRestoreSmsDb, _u32StartCounter, bIsStartRequested(), FC_SXM_MAX_DATA_APP_RESTARTS, _oSmsConfigDir.c_str()));

            _bDataProductsEnabled = bResetProductState();
            _bSmsServiceStopping = FALSE;

            if (_bRestoreSmsDb) {
                _bRestoreSmsDb=FALSE;
                if (_oSmsConfigDir!= "") {
                    fc_sxm_tclSmsDirRestorer::instance()->bRestore(_oSmsConfigDir);
                    /*Inform Diagnosis regarding DB change*/
                    fc_sxm_trMsgDiagSxmDbReplaced rMsg;
                    fc_sxm_tclAudioApp::instance()->vPostMsgNew(rMsg);
                }
            }

            vSetSmsServiceRefInvalid();
            

            // todo: put define FC_SXM_MAX_DATA_APP_RESTARTS into config.h
            if (bIsStartRequested() && !(fc_sxm_tclSystemStates::instance()->bIsSMSLIBCvOn()) && !(fc_sxm_tclSystemStates::instance()->bIsSMSDecoderError())) {
                if (_u32StartCounter <= FC_SXM_MAX_DATA_APP_RESTARTS) {
                    _u32StartCounter++;
                    OSAL_s32ThreadWait(5000);
                    vStartSmsService();
                    if (hGetSmsServiceRef()==DATASERVICE_MGR_INVALID_OBJECT) {
                        ETG_TRACE_FATAL_DCL((_u16TraceClass, "PEHA could not start data-service"));
                        fc_sxm_trMsgDataSmsEvtServiceState rMsg;
                        rMsg.eState=DATASERVICE_STATE_STOPPED;
                        rMsg.enErrorCode=DATASERVICE_ERROR_CODE_GENERAL;
                        vProcessGenericMsg(&rMsg);
                    }
                }
            }
        }
        break;

        case DATASERVICE_STATE_ERROR:
        {
            // On Critical Voltage & When Decoder is in Error state, We should not stop the service
            // Services will be stopped together later by AppManager
            if (!(fc_sxm_tclSystemStates::instance()->bIsSMSLIBCvOn()) && !(fc_sxm_tclSystemStates::instance()->bIsSMSDecoderError())) {
                if (enErrorCode==DATASERVICE_ERROR_CODE_DATABASE_CORRUPT 
                    || enErrorCode==DATASERVICE_ERROR_CODE_DATABASE_NOT_FOUND
                    || enErrorCode==DATASERVICE_ERROR_CODE_DATABASE_VERSION_MISMATCH
                    || enErrorCode==DATASERVICE_ERROR_CODE_DATABASE_ACCESS_FAILURE) {
                    // disable further retries
                    _u32StartCounter = FC_SXM_MAX_DATA_APP_RESTARTS+1;
                    vOnDataBaseCorrupted();
                }
                bStopSmsService=TRUE;
            }
        }
            break;
        case DATASERVICE_STATE_UNAVAILABLE:
        {
            // Stop the SMS service
            vStopSmsService();
            break;
        }
        case DATASERVICE_STATE_READY:
        {
            vAllowService(TRUE);

            fc_sxm_tclPersData::instance()->vSetPersistentDbError(FALSE, enGetServiceId());
            _u32StartCounter=0;

            if (_bSmsServiceStopping == FALSE)
            {
                fc_sxm_trMsgDataSmsEvtServiceUp rMsg;
                vPostMsgNew(rMsg);
            }
        }
        break;
        default:
            break;
    }
    _oDsrlList.vOnSmsServiceStateChanged(FALSE);

    midw_ext_fi_tcl_SxmDataSrvState oFiSrvState;
    oFiSrvState.Status=enNewFiSrvState;
    if (!(enNewFiSrvState == enOldFiSrvState)) {
        // inform app about new state:
        vOnFiServiceStateChanged(oFiSrvState);
    }

    fc_sxm_trMsgAppMgrDataAppServiceStatus rMsg;
    rMsg.eState = _enSmsServiceState;
    rMsg.enServiceID = enGetServiceId();
    //Send a message to AppManager
    fc_sxm_tclAppManager::instance()->vPostMsgNew(rMsg);

    if (bStopSmsService) {
        vStopSmsService();
    }

}
/* 
   Method to be Overriden by each Service 
   to clear Service specifi internal data
*/
tVoid fc_sxm_tclDataApp::vClearServiceData() {
   ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vClearServiceData - Please Override to Clear your Service specific data"));
};

tVoid fc_sxm_tclDataApp::vProcessBaseAppMsg(fc_sxm_trMsgAppRestoreSmsDb const *prMsg)
{
    ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp(%10s)::fc_sxm_trMsgAppRestoreSmsDb, bIsStartRequested()=%d _enSmsServiceState=%d _bRestoreSmsDb=%d _oSmsConfigDir=%s",
        szGetName(), bIsStartRequested(),
        ETG_CENUM(DATASERVICE_STATE_ENUM, _enSmsServiceState),
        _bRestoreSmsDb, _oSmsConfigDir.c_str()));

    (tVoid)prMsg;//not used resolving prio 2 lint
    _u32StartCounter=0;
    if (_enSmsServiceState != DATASERVICE_STATE_INVALID && _enSmsServiceState != DATASERVICE_STATE_STOPPED) {
        // stop the sms-service first
        _bRestoreSmsDb=TRUE;
        vStopSmsService();
    }
}

tVoid fc_sxm_tclDataApp::vOnDataBaseCorrupted() const {
    // let app-mgr handle the problem
    fc_sxm_trMsgAppMgrSmsDbError rMsg(enGetServiceId());
    fc_sxm_tclAppManager::instance()->vPostMsgNew(rMsg);

}

tVoid fc_sxm_tclDataApp::vTraceStopSmsService() const
{
    ETG_TRACE_USR4_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vTraceStopSmsService(%10s)",
                    szGetName()));
}
/*
 * method to initialize Favorite List from Persistent
 */
tVoid fc_sxm_tclDataApp::vLoadFavorites()
{
    ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vLoadFavorites"));

    //Clear If any old Data
    _vecFavoriteList.clear();

    //Get Favorite List from Persistent
    trAppUserData::instance()->vGetFavoriteList(enGetServiceId(),_vecFavoriteList);
    
    ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vLoadFavorites size=%d",_vecFavoriteList.size()));
}
/*
 * method to Add particular LOCID to internal list
 */
tVoid fc_sxm_tclDataApp::vAddFavorite(tU32 u32LOCID)
{
    ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vAddFavorite u32LOCID=%d",u32LOCID));

    //Add entry to internal list
    _vecFavoriteList.push_back(u32LOCID);

    trAppUserData::instance()->vSetFavoriteList(enGetServiceId(),_vecFavoriteList);
}
/*
 * method to remove particular LOCID from internal list
 */
tVoid fc_sxm_tclDataApp::vRemoveFavorite(tU32 u32LOCID)
{
    ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vRemoveFavorite u32LOCID=%d",u32LOCID));

    //Remove entry form internal list
    SXM_FOREACH(vector<tU32>, itr, _vecFavoriteList)
    {
        //Check if LOCID found
        if(*itr == u32LOCID)
        {
            _vecFavoriteList.erase(itr);
            break;
        }
    }

    trAppUserData::instance()->vSetFavoriteList(enGetServiceId(),_vecFavoriteList);
}
/*
 * method to initialize Favorite List from Persistent
 */
tVoid fc_sxm_tclDataApp::vSaveFavorites()
{
    //Set Current List
    trAppUserData::instance()->vSetFavoriteList(enGetServiceId(),_vecFavoriteList);

    ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vSaveFavorites size=%d",_vecFavoriteList.size()));

}
/*
 * method to initialize Favorite List from Persistent
 */
tVoid fc_sxm_tclDataApp::vClearFavorites()
{
    ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vClearFavorites"));

    _vecFavoriteList.clear();

    //Set Empty list to persistent
    trAppUserData::instance()->vSetFavoriteList(enGetServiceId(),_vecFavoriteList);

    ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::vClearFavorites size=%d",_vecFavoriteList.size()));

}
/*
 * method to find & return Favorite Index value per a entry
 */
tU32 fc_sxm_tclDataApp::u32GetFavoriteIndex(tU32 u32LOCID) const
{
    tU32 u32FavoriteIndex = 0;
    //loop through our internal list
    //find for entry:LOCID
    for(; u32FavoriteIndex < _vecFavoriteList.size(); ++u32FavoriteIndex)
    {
        if(_vecFavoriteList[u32FavoriteIndex] == u32LOCID)
            break;
    }

    ETG_TRACE_USR1_DCL((_u16TraceClass, "fc_sxm_tclDataApp::u32GetFavoriteIndex u32Index=%d",u32FavoriteIndex));

    //return Favorite Index
    return u32FavoriteIndex;
}

tU32 fc_sxm_u32GetNewDsrlId(fc_sxm_tclDataApp *prDataApp) {
    return prDataApp->u32GetNextDsrlId();
}

