/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_config_file.h
* @brief       Declaration of config file utillity
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_CONFIG_FILE_H_
#define _FC_SXM_TCL_CONFIG_FILE_H_

#if 0
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif 

#include <string>
#include <map>
#include <vector>

#include "fc_sxm_types.h"

typedef vector<string> fc_sxm_trValuesList;
typedef map<string, fc_sxm_trValuesList > fc_sxm_trKeyValuesMap;

class fc_sxm_tclConfigFile {
 public:
    fc_sxm_tclConfigFile() {};
    virtual ~fc_sxm_tclConfigFile() {};

    tBool bGetHex(string oVal, tU32 *pU32Res) const;
    tBool bGetDec(string oVal, tU32 *pU32Res) const;

    tBool bGetVals(string const &oKey, vector<string> &oVals);

    tBool bGetVal(string const &oKey, string &oVal, tU32 u32Index=0);


 protected:
    tVoid vInit(string const &oConfigFileName);
    tVoid vStoreToMap(string const &oKey, vector<string> const &oVals) {
        _mapKeyValues[oKey]=oVals;
    }
    virtual tVoid vReadEntry(string const &oKey, vector<string> const &oVals);
    
    
 private:
    fc_sxm_trKeyValuesMap  _mapKeyValues;

};


#endif
