/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_config_file.cpp
* @brief       Implementation of config file utillity
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_common.h"
#include "fc_sxm_tcl_config_file.h"

#include <ctype.h>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_CONFIG
#include "trcGenProj/Header/fc_sxm_tcl_config_file.cpp.trc.h"
#endif



tBool fc_sxm_tclConfigFile::bGetDec(string oVal, tU32 *pU32Res) const {
    ETG_TRACE_USR3(("bGetDec: val=%s", oVal.c_str()));
    *pU32Res=(tU32)strtol(oVal.c_str(), NULL, 10);
    ETG_TRACE_USR3(("bGetDec: Res=%u", *pU32Res));
    return TRUE;
}

tBool fc_sxm_tclConfigFile::bGetHex(string oVal, tU32 *pU32Res) const {
    ETG_TRACE_USR3(("bGetHex: val=%s", oVal.c_str()));
    
    size_t offset;
    offset=oVal.find("0x");
    if (offset==string::npos) {
        ETG_TRACE_USR1(("bGetHex: invalid val=%s", oVal.c_str()));
        return FALSE;
    }
    ETG_TRACE_USR3(("bGetHex: offset=%d", (tU32)offset));
    
    oVal=oVal.substr(offset+2);
    if (oVal.empty()) {
        ETG_TRACE_USR1(("bGetHex: empty substr"));
        return FALSE;
    }
    ETG_TRACE_USR4(("bGetHex: substr=%s", oVal.c_str()));
    
    *pU32Res=(tU32)strtol(oVal.c_str(), NULL, 16);
    ETG_TRACE_USR3(("bGetHex: Res=0x%08x", *pU32Res));
    return TRUE;    
}

tBool fc_sxm_tclConfigFile::bGetVals(string const &oKey, vector<string> &oVals) {
    fc_sxm_trKeyValuesMap::const_iterator keyIter = _mapKeyValues.find(oKey);
    if  (keyIter != _mapKeyValues.end()) {
        oVals=keyIter->second;
        return TRUE;
    }
    return FALSE;
}

tBool fc_sxm_tclConfigFile::bGetVal(string const &oKey, string &oVal, tU32 u32Index) {
    fc_sxm_trKeyValuesMap::const_iterator keyIter = _mapKeyValues.find(oKey);
    if  (keyIter != _mapKeyValues.end()) {
        if (keyIter->second.size()  <= u32Index) {
            return FALSE;
        }
        oVal= keyIter->second[u32Index];
        return TRUE;
    }
    return FALSE;
}

tVoid fc_sxm_tclConfigFile::vInit(string const &oConfigFileName) {
    tS32 s32NumBytes=0;
    tU8 input[1000];
    ETG_TRACE_USR2(("fc_sxm_tclConfigFile CTOR START"));

#if 1
    FILE *fp=fopen(oConfigFileName.c_str(), "r");
    if (OSAL_NULL == fp) {
        ETG_TRACE_USR2(("Xfc_sxm_tclConfig::vInit: could not open %s", oConfigFileName.c_str()));
        return;
    }
    s32NumBytes=(tS32)fread(input, 1, 998, fp);
    ETG_TRACE_USR3(("X fc_sxm_tclConfig::fread returned %d (%s)", s32NumBytes, oConfigFileName.c_str()));

    fclose(fp);
#else    
    OSAL_tIODescriptor hFile= OSAL_IOOpen(oConfigFileName.c_str(), 
                                                            OSAL_EN_READONLY);
    if (OSAL_ERROR==hFile) {
        ETG_TRACE_USR2(("fc_sxm_tclConfig::vInit: could not open %s", oConfigFileName.c_str()));
        return;
    }
       
    s32NumBytes= OSAL_s32IORead(hFile, (tPS8) input, 998);
    if (s32NumBytes<=0) {
        ETG_TRACE_ERR(("fc_sxm_tclConfig::vInit: could not read (ret=%d) hFile=0x%08x OSAL_ERROR=0x%08x %s", s32NumBytes, hFile, OSAL_ERROR, oConfigFileName.c_str()));
    }
#endif


    // make sure string ends with new-line
    input[s32NumBytes]='\n';
    input[s32NumBytes+1]=0;
    ETG_TRACE_USR4(("fc_sxm_tclConfig::cfg:!%s!", input));


    string oCur;
    string oKey;
    vector<string> oVals;

    typedef enum {
        enState_Key,
        enState_Val
    } tenState;
    tenState enState=enState_Key;
        
    // for each character
    tU8 *pu8Cur=input;
    tBool bWaitEnd=FALSE;
    while(*pu8Cur) {

        tU8 u8Byte=*pu8Cur;
        ETG_TRACE_USR4(("u8Byte=0x%x (%c) bWaitEnd=%d", u8Byte, u8Byte, bWaitEnd));
        if (bWaitEnd) {
            if (iscntrl(u8Byte)) {
                bWaitEnd=FALSE;
                // don't increment, take same letter again
                continue;
            }
        }
        else if (isblank(u8Byte)) {
            ETG_TRACE_USR4(("blanc"));
        }
        else if (u8Byte=='#') {
            ETG_TRACE_USR4(("#->WaitEnd"));
            bWaitEnd=TRUE;
        }
            
        else if (u8Byte=='=') {
            if (!oCur.empty() || enState==enState_Key) {
                oKey=oCur;
                oCur="";
                ETG_TRACE_USR4(("Key->Val: key=%s", oKey.c_str()));
                enState=enState_Val;
            }
            else {
                ETG_TRACE_USR3(("=->WaitEnd"));
                bWaitEnd=TRUE;
                oCur="";
            }
        }
        else if (isalnum(u8Byte)) {
            if (enState==enState_Key || enState==enState_Val) {
                oCur+=u8Byte;
                ETG_TRACE_USR4(("isalnum:oCur=%s",oCur.c_str()));
            }
        } 
        else if (u8Byte==',') {
            if (enState==enState_Val && !oCur.empty()) {
                ETG_TRACE_USR4((",->Val: oCur=%s", oCur.c_str()));
                oVals.push_back(oCur);
                oCur="";
            }
            else {
                bWaitEnd=TRUE;
                ETG_TRACE_USR3((",=->WaitEnd"));
            }
        }
        else if (iscntrl(u8Byte)) {
            ETG_TRACE_USR3(("iscntrl state=%d", enState));
            // all control-byte are regarded as EOL
            if (enState==enState_Val || !oVals.empty()) {
                ETG_TRACE_USR3(("iscntrl state OK"));
                // only in this state we 
                if (!oCur.empty()) {
                    ETG_TRACE_USR2(("iscntrl: push val %s", oCur.c_str()));
                    oVals.push_back(oCur);
                    oCur="";
                }
                if (!oKey.empty() && !oVals.empty()) {
                    ETG_TRACE_USR3(("iscntrl have KEY and VAL"));
                    vReadEntry(oKey, oVals);
                }
            }
            oCur="";
            oKey="";
            oVals.clear();
            enState=enState_Key;
        }
        // increment
        pu8Cur++;
    }
    ETG_TRACE_USR2(("fc_sxm_tclConfig::CTOR END"));
}


tVoid fc_sxm_tclConfigFile::vReadEntry(string const &oKey, vector<string> const &oVals) {
    ETG_TRACE_USR2(("fc_sxm_tclConfigFile::vReadEntry(%s)",oKey.c_str()));
    vStoreToMap(oKey, oVals);
}
