/**
 * @swcomponent fc_sxm
 * @{
 * @file        fc_sxm_tcl_config.h
 * @brief       Provides declaration and implementation of  configuration for sxm services
 *              like SMS, Audio, Data, device position etc. Is is also providing configuarion
 *              class declaration for preset and dsrls.
 * @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 * @}
 */

#ifndef _FC_SXM_TCL_CONFIG_H_
#define _FC_SXM_TCL_CONFIG_H_

#include "fc_sxm_types.h"
#include "fc_sxm_tcl_singleton.h"
#include "fc_sxm_tcl_config_file.h"
#include "fc_sxm_tcl_base_dsrl.h"

class fc_sxm_tclConfig :
   public fc_sxm_tclConfigFile,
   public fc_sxm_tclSingleton<fc_sxm_tclConfig>
{
   friend class fc_sxm_tclSingleton<fc_sxm_tclConfig> ;

public:

   tBool bIsAppEnabled(fc_sxm_tenServiceID enServiceId) const;
   tU32 u32GetDelaySmsStartMs() const
   {
      return _u32DelaySmsStartMs;
   }
   tU32 u32GetDelayDataStartMs() const
   {
      return _u32DelayDataStartMs;
   }
   tU32 u32GetDelayAudioStartMs() const
   {
      return _u32DelayAudioStartMs;
   }
   tU32 u32GetDataServiceMaxStartTimeMs() const
   {
      return _u32DataServiceMaxStartTimeMs;
   }
   tU32 u32GetDevicePosTimeMs() const
   {
      return _u32DelayDevicePosTimeMs;
   }
   tU32 u32GetWatchdogMaxCyclesTimeMs() const
   {
      return _u32WatchdogMaxCycleTimeMs;
   }
   tBool bGetPresetType() const
   {
     return _bIsMixedPreset;
   }
   tU8 u8GetNumberOfPresets() const
   {
     return _u8NumberOfPresets;
   }
   tVoid vCheckKDSPresetType();

private:
   fc_sxm_tclConfig();
   virtual tVoid vReadEntry(string const &oKey, vector<string> const &oVals);
   set<fc_sxm_tenServiceID> _setDisabledApps;
   tU32 _u32DelaySmsStartMs;
   tU32 _u32DelayDataStartMs;
   tU32 _u32DelayAudioStartMs;
   tU32 _u32DataServiceMaxStartTimeMs;
   tU32 _u32DelayDevicePosTimeMs;
   tU32 _u32WatchdogMaxCycleTimeMs;
   tBool _bIsMixedPreset;
   tU8 _u8NumberOfPresets;
};

   class fc_sxm_tclDbVersionConfig :
      public fc_sxm_tclConfigFile,
      public fc_sxm_tclSingleton<fc_sxm_tclDbVersionConfig>
   {
      friend class fc_sxm_tclSingleton<fc_sxm_tclDbVersionConfig> ;

   public:
      fc_sxm_tclDbVersionConfig();
      ~fc_sxm_tclDbVersionConfig();
    //  tBool bIsAppEnabled(fc_sxm_tenServiceID enServiceId) const;
      tU32 u32GetSmsCfgDbVersion() const
      {
         return _u32SmsCfgDbVersion;
      }
      tU32 u32GetFuelDbVersion() const
      {
         return _u32FuelDbVersion;
      }
      tU32 u32GetTrafficDbVersion() const
      {
         return _u32TrafficDbVersion;
      }
      tU32 u32GetMoviesDbVersion() const
      {
         return _u32MoviesDbVersion;
      }
      tU32 u32GetAgwDbVersion() const
      {
         return _u32AgwDbVersion;
      }
      tU32 u32GetTabWeatherDbVersion() const
      {
         return _u32TabWeatherDbVersion;
      }
      tU32 u32GetStocksDbVersion() const
      {
         return _u32StocksDbVersion;
      }
      tU32 u32GetSportsDbVersion() const
      {
         return _u32SportsDbVersion;
      }
      tU32 u32GetCanadianFuelDbVersion() const
      {
         return _u32CanadianFuelDbVersion;
      }
      tU32 u32GetWsAlertsDbVersion() const
      {
         return _u32WsAlertsDbVersion;
      }
      tU32 u32GetParkingDbVersion() const
      {
         return _u32ParkingDbVersion;
      }
      tU32 u32GetPhoneticsDbVersion() const
      {
         return _u32PhoneticsDbVersion;
      }
      tU32 u32GetStatesVersion() const
      {
         return _u32StatesVersion;
      }
      tU32 u32GetChannelArtVersion() const
      {
    	  return _u32ChannelArtDbVersion;
      }
      tVoid vCheckDBVersion();
   private:
      fc_sxm_tclSem _oSem;
      virtual tVoid vReadEntry(string const &oKey, vector<string> const &oVals);
//      set<fc_sxm_tenServiceID> _setDisabledApps;
      tU32 _u32SmsCfgDbVersion;
      tU32 _u32FuelDbVersion;
      tU32 _u32TrafficDbVersion;
      tU32 _u32MoviesDbVersion;
      tU32 _u32AgwDbVersion;
      tU32 _u32TabWeatherDbVersion;
      tU32 _u32StocksDbVersion;
      tU32 _u32SportsDbVersion;
      tU32 _u32CanadianFuelDbVersion;
      tU32 _u32WsAlertsDbVersion;
      tU32 _u32ParkingDbVersion;
      tU32 _u32PhoneticsDbVersion;
      tU32 _u32StatesVersion;
      tU32 _u32ChannelArtDbVersion;

      tVoid vRestore(string const &oSubDir="");
      tVoid vUpdateDbVersion(tU32 u32Service);
      tBool bIsDbValid(tU32 u32CfgVersion, tU32 u32DpVersion);
   };

struct fc_sxm_trDefaultPreset
{
   fc_sxm_trDefaultPreset()
            : u32Bank(0),
              u32Preset(0),
              u32Channel(0)
   {
   }

   tU32 u32Bank;
   tU32 u32Preset;
   tU32 u32Channel;
};

class fc_sxm_tclConfigPresets :
   public fc_sxm_tclConfigFile,
   public fc_sxm_tclSingleton<fc_sxm_tclConfigPresets>
{
   friend class fc_sxm_tclSingleton<fc_sxm_tclConfigPresets> ;

public:

   vector<fc_sxm_trDefaultPreset> const &roGetDefaultPresets()
   {
      return _vecPresets;
   }

private:
   fc_sxm_tclConfigPresets();
   virtual tVoid vReadEntry(string const &oKey, vector<string> const &oVals);
   vector<fc_sxm_trDefaultPreset> _vecPresets;

};

////////////////////////////////////////////////////////////////////////////////////
/***************              DSRL Configuration                *******************/
////////////////////////////////////////////////////////////////////////////////////

/* Map to hold dsrl configuration values */
typedef map<tU32, fc_sxm_trDSRLBaseCfg> fc_sxm_tclMapDsrlConfigs;

class fc_sxm_tclConfigDsrls :
   public fc_sxm_tclConfigFile,
   public fc_sxm_tclSingleton<fc_sxm_tclConfigDsrls>
{
   friend class fc_sxm_tclSingleton<fc_sxm_tclConfigDsrls> ;

public:
   //Expose Function to be define here

   /* Called by App to Get DSRL Configuration */
   tVoid vPatchDsrlConfig(fc_sxm_tenServiceID enServiceID, fc_sxm_tenDSRLType enDSRLType, fc_sxm_trDSRLBaseCfg &rCfg);

private:
   /* my constuctor */
   fc_sxm_tclConfigDsrls();

   /* Method overriden from fc_sxm_tclConfigFile class */
   virtual tVoid vReadEntry(string const &oKey, vector<string> const &oVals);

private:
   fc_sxm_tclMapDsrlConfigs _mapDsrlConfigs;
   tU32 u32GenKey(fc_sxm_tenServiceID enServiceID, fc_sxm_tenDSRLType enDsrlType)
   {
      return ((tU16) enServiceID >> 4) | enDsrlType;
   }

};
#endif
