/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_base_service.h
* @brief       Declaration of Base service which is providing  interface to send method result,
*              methos error to client using CCA. Also defines macro to distribute method stast
*              particuler applicaton or service
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

/*******************************************************************************
*                                                                               
* Wrapper for ahl_tclBaseOneThreadService to add some sxm-specific functionality                     
*                                                                               
*******************************************************************************/

#ifndef _FC_SXM_SERVICE_BASE_H_
#define _FC_SXM_SERVICE_BASE_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION_DEMO
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw).
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"



/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
/* 2 Macros to handle a get-request from a client for function-id "FNID"
   read a property-object "PROPERTY" 
   and use its conversion-operator to convert it to the fi-message of type "OUTFITYPE"  
   and hand it over to "roOutMsg" */
// 1.) property has to provide conversion-operator
#define SXM_PGET_ENTRY(FNID, OUTFITYPE, PROPERTY)  \
      case FNID: \
          {                                                     \
              OUTFITYPE oFiDataObject =                                 \
                  PROPERTY.rGet();               \
              fi_tclVisitorMessage visitorMessage(oFiDataObject, u16GetFiMajorVersion());   \
              bResult= visitorMessage.bHandOver(&roOutMsg); \
              oFiDataObject.vDestroy(); \
              break;                    \
          }  

// 2.)for properties that already contain the fi-message in member "oFiMsg"
#define SXM_PGET_ENTRY_FIMSG(FNID, OUTFITYPE, PROPERTY)  \
      case FNID: \
          {                                                     \
              OUTFITYPE oFiDataObject =                                 \
                  PROPERTY.rGet().oFiMsg;               \
              fi_tclVisitorMessage visitorMessage(oFiDataObject, u16GetFiMajorVersion());   \
              bResult= visitorMessage.bHandOver(&roOutMsg); \
              oFiDataObject.vDestroy(); \
              break;                    \
          }  
// 2.)for properties want to ignore the updates.
#define SXM_PGET_ENTRY_IGNORE(FNID)  \
      case FNID: \
          {                                                     \
              bResult= TRUE; \
              break;                    \
          }  

/*
Macro to handle a method-start for function-id FNID:
  copy the method-start message "poMessage" 
  of type "MSTARTFITYPE"
  to internal thread-message ("rAdressing" and "oFiMsg") of type "THREADMSG"
*/
#define SXM_MSTART_ENTRY(FNID, MSTARTFITYPE, THREADMSG)    \
      case FNID: \
          {                                                     \
              THREADMSG oThreadMsg;                          \
              oThreadMsg.rAdressing=*poMessage;\
              MSTARTFITYPE &oRxFIObj=oThreadMsg.oFiMsg; \
              fi_tclVisitorMessage oMsg( poMessage );\
              oMsg.s32GetData(oRxFIObj, u16GetFiMajorVersion());                   \
              fc_sxm_tclAppManager::instance()->vDistributeMessage(oThreadMsg); \
              oRxFIObj.vDestroy();                                      \
          }                                                             \
              break


/*
Macro to handle a property-set for function-id FNID:
  copy the property-set message "poMessage" 
  of type "PROPERTYTYPE"
  to internal thread-message ("rAdressing" and "oFiMsg") of type "THREADMSG"
*/
#define SXM_PSET_ENTRY(FNID, PSETFITYPE, THREADMSG)    \
      case FNID: \
          {                                                     \
              THREADMSG oThreadMsg;                          \
              oThreadMsg.rAdressing=*poMessage;\
              PSETFITYPE &oRxFIObj=oThreadMsg.oFiMsg; \
              fi_tclVisitorMessage oMsg( poMessage );\
              oMsg.s32GetData(oRxFIObj, u16GetFiMajorVersion());                   \
              fc_sxm_tclAppManager::instance()->vDistributeMessage(oThreadMsg); \
              oRxFIObj.vDestroy();                                      \
              bResult = TRUE;                                           \
          }                                                             \
              break


class fc_sxm_tclApp;

class fc_sxm_tclBaseService : 
public ahl_tclBaseOneThreadService
{
  public:

    fc_sxm_tclBaseService(tU16 u16ServiceId,
                       tU16 u16FiMajorVersion,
                       tU16 u16FiMinorVersion=0,
                       tU16 u16FiPatchVersion=0);  

    virtual ~fc_sxm_tclBaseService(){};

    // interface to send a fi-answer-message "roSendFiObj" to client according to "rAdressing" 
    ail_tenCommunicationError enSendFiMessage( fc_sxm_trAdressing const &rAdressing, const fi_tclMessageBase& roSendFiObj );
    static tVoid vSendError(fc_sxm_trAdressing const &rAdressing, tU16 u16ErrorCode);
    
    virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

    tU16 u16GetFiMajorVersion() {
        return _u16FiMajorVersion;
    }
    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    // interface for app-manager to tell the service that a property of "u16FunctionId" has to be updated
    tVoid vHandlePropertyChanged(tU16 u16FunctionId) {
        eUpdateClients(u16FunctionId);
    }
    // interface for app-manager to allow/forbid to enable the service.
    tVoid bAllowService(tBool bAllow);

    tU32 u32GetId() const { 
        return (tU32) u16GetServiceID();
    }

  protected:

 private:
    tU16 _u16FiMajorVersion;
};

#endif // _FC_SXM_SERVICE_SXM_AUDIO_H_

