/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_base_client.h
* @brief       Declaration for Base client which is used to send the method start.
*              Also provides Macro to distribute recevied method result, internal message etc to
*              particular service/app.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_CLIENT_BASE_H_
#define _FC_SXM_CLIENT_BASE_H_


/*******************************************************************************
*                                                                               
* Wrapper for ahl_tclBaseOneThreadClientHandler to add some sxm-specific functionality
* examples can be found in fc_sxm_clienthandler_fc_audio.h/cpp                     
*                                                                               
*******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;

class fc_sxm_tclBaseClient:
public ahl_tclBaseOneThreadClientHandler
{
 public:
    fc_sxm_tclBaseClient(tU16 u16ServiceId,
                       tU16 u16FiMajorVersion,
                       tU16 u16FiMinorVersion=0,
                         tU16 u16SrvAppId=AMT_C_U16_APPID_INVALID);
    virtual ~fc_sxm_tclBaseClient(){};

    // interface to send a fi-message "roSendFiObj" (Get or MethodStart) to the server 
    ail_tenCommunicationError enSendFiMessage(fi_tclMessageBase const & roSendFiObj ) const;

    virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

    tU32 u32GetId() const { 
        return (tU32) u16GetServiceID();
    }


};

/*
  Macro tho handle received fi-status-message "pServiceDataMessage" with function-id "FNID":
  populate thread-message of type "THREADMSG" 
  containing member oFiMsg of type "PSTATUSFITYPE" 
  according to "pServiceDataMessage"
*/
#define SXM_PSTATUS_ENTRY(FNID, PSTATUSFITYPE, THREADMSG)    \
      case FNID: \
          {                                                     \
              PSTATUSFITYPE oRxFIObj; \
              fi_tclVisitorMessage oMsg( pServiceDataMessage );\
              THREADMSG oThreadMsg;                 \
              oMsg.s32GetData( oThreadMsg.oFiMsg );\
              fc_sxm_tclAppManager::instance()->vDistributeMessage(oThreadMsg); \
              oRxFIObj.vDestroy();                                      \
          }                                                             \
              break

/*
  Macro tho handle received fi-method-result-message "pServiceDataMessage" with function-id "FNID":
  populate thread-message of type "THREADMSG" 
  containing member oFiMsg of type "MRESULTFITYPE" 
  according to "pServiceDataMessage"
*/
#define SXM_MRESULT_ENTRY(FNID, MRESULTFITYPE, THREADMSG)    \
      case FNID: \
          {                                                     \
              MRESULTFITYPE oRxFIObj; \
              fi_tclVisitorMessage oMsg( pServiceDataMessage );\
              THREADMSG oThreadMsg;                 \
              oMsg.s32GetData( oThreadMsg.oFiMsg );\
              fc_sxm_tclAppManager::instance()->vDistributeMessage(oThreadMsg); \
              oRxFIObj.vDestroy();                                      \
          }                                                             \
              break


/*
  Macro tho handle received fi-method-error-message "pServiceDataMessage" with function-id "FNID":
  populate thread-message of type "THREADMSG"
  containing member oFiMsg of type "MRESULTFITYPE"
  according to "pServiceDataMessage"
*/
#define SXM_MERROR_ENTRY(FNID, ECODE, THREADMSG)    \
      case FNID: \
          {                                                     \
              THREADMSG oThreadMsg;                 \
              oThreadMsg.u16FID = FNID; \
              oThreadMsg.u16ErrorCode = ECODE;\
              fc_sxm_tclAppManager::instance()->vDistributeMessage(oThreadMsg); \
          }                                                             \
              break

#endif
