/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_ahl_object_list.h
* @brief       Declaration and implementation of Objectlist using deque
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_AHL_OBJECT_LIST_HPP
#define FC_SXM_TCL_AHL_OBJECT_LIST_HPP

/*
  template for a list of ahl-objects.
  objects have to provide method u32GetId()
*/


#include "fc_sxm_tcl_base_service.h"
#include "fc_sxm_tcl_base_client.h"


template <typename CLASS>
class fc_sxm_tclObjectList {
 public:
    // add an object
    //lint -esym(1551, fc_sxm_tclAhlObjectList::~fc_sxm_tclAhlObjectList) prio3 Function may throw exception '...' in destructor
    CLASS *poAdd(CLASS *pMh) {
        if (OSAL_NULL !=pMh) {
            _oQ.push_back(pMh);
        }
        return pMh;
    };
    // clear the list by deleting all objects in reverse order they have been added
    tVoid vClear(tVoid) {
        for (typename deque< CLASS * >::reverse_iterator iter=_oQ.rbegin();
             iter!=_oQ.rend();
             ++iter) {
            if (OSAL_NULL != *iter) {
                OSAL_DELETE *iter;
            }
        }
        //lint -restore
        _oQ.clear();   
    };

    virtual ~fc_sxm_tclObjectList() {
        vClear();
    };

 protected:
    deque<CLASS *>_oQ;

};    

template <typename CLASS>
    class fc_sxm_tclAhlObjectList:
    public fc_sxm_tclObjectList<CLASS> {
 public:

    // get pointer to object with sxm-service-id "u32Id" (this is not the cca-service-id)
    CLASS *poGetAhlObject(tU32 u32Id) {
        //lint -save -esym(1702, operator!=) both member and non-member ops
        for (typename deque<CLASS *>::iterator iter = fc_sxm_tclObjectList<CLASS>::_oQ.begin(); iter!=fc_sxm_tclObjectList<CLASS>::_oQ.end();++iter) {
            if (OSAL_NULL != *iter) {
                if ((*iter)->u32GetId()==u32Id) {
                    return (*iter);
                }
            }
        }
        return OSAL_NULL;
        //lint -restore
    }


    // get pointer to object with sxm-service-id "u32Id" (this is not the cca-service-id)
    tVoid vRemoveAhlObject(tU32 u32Id) {
        //lint -save -esym(1702, operator!=) both member and non-member ops
        for (typename deque<CLASS *>::iterator iter = fc_sxm_tclObjectList<CLASS>::_oQ.begin(); iter!=fc_sxm_tclObjectList<CLASS>::_oQ.end();++iter) {
            if (OSAL_NULL != *iter) {
                if ((*iter)->u32GetId()==u32Id) {
                    OSAL_DELETE (*iter);
                    fc_sxm_tclObjectList<CLASS>::_oQ.erase(iter);
                    return;
                }
            }
        }
        //lint -restore
    }



    
};


#endif
