/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_sms_util.cpp
* @brief       Implementation for utility functions
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

// just take any data-fi

#define FC_SXM_DEFAUL_SMS_STRING_LEN 50

#include "fc_sxm_sms_util.h"
#include "math.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_BASE_APP
#include "trcGenProj/Header/fc_sxm_sms_util.cpp.trc.h"
#endif

/*********************************************************************
 *FUNCTION:     fc_sxm_vCopySmsString2Fi
 *DESCRIPTION:  
 *PARAMETER:  STRING_OBJECT hSmsStringObj, midw_ext_fi_tclString &rFiString, tU32 u32MaxLen
 *RETURNVALUE:  None
 ********************************************************************/
tVoid fc_sxm_vCopySmsString2Fi(STRING_OBJECT hSmsStringObj, midw_ext_fi_tclString &rFiString) {
    string rStlString;
    fc_sxm_vCopySmsString2Stl(hSmsStringObj, rStlString);
    fc_sxm_vString2Fi(rStlString.c_str(), rFiString);

    rStlString.erase();
}

/*********************************************************************
 *FUNCTION:     fc_sxm_vCopySmsString2Stl
 *DESCRIPTION:  
 *PARAMETER:  STRING_OBJECT hSmsStringObj, string &rStlString
 *RETURNVALUE:  None
 ********************************************************************/
tVoid fc_sxm_vCopySmsString2Stl(STRING_OBJECT hSmsStringObj, string &rStlString) {
    char string_buffer[FC_SXM_DEFAUL_SMS_STRING_LEN + 1];
    char *pBufNew=OSAL_NULL;
    char *pBuf=string_buffer;

    /*The length excluding the string Terminator */
    tU32 u32MaxLen= (tU32)((STRING.tSize(hSmsStringObj)) + 1u);
    if (u32MaxLen < 1) {
        rStlString="";
        return;
    }

    /*Checking for size 0.If 0, providing max length value to
    tCopyToCStr() so that the function will ensure a NULL
    termination to the destination string
    Condition to put null terminator for tCopyToCStr(): valid
    destination pointer and a non-zero size */
    /*if (!u32MaxLen) {
        u32MaxLen=FC_SXM_DEFAUL_SMS_STRING_LEN;
    }*/
    if (u32MaxLen>FC_SXM_DEFAUL_SMS_STRING_LEN) {
        pBufNew=OSAL_NEW char[u32MaxLen];
        pBuf=pBufNew;
    }

    if(OSAL_NULL != pBuf)
    {
        pBuf[0]=0;
        STRING.tCopyToCStr(hSmsStringObj, pBuf,u32MaxLen);
        rStlString=pBuf;
    }

    if (OSAL_NULL != pBufNew) {
        OSAL_DELETE[] pBufNew;
    }
}

/*********************************************************************
 *FUNCTION:     fc_sxm_vConvertSmsString2Int_base16
 *DESCRIPTION:  
 *PARAMETER:  STRING_OBJECT hSmsStringObj
 *RETURNVALUE:  
 ********************************************************************/
tS32 fc_sxm_vConvertSmsString2Int_base16(STRING_OBJECT hSmsStringObj)
{
    tS32 s32Value= 0;
    char string_buffer[FC_SXM_DEFAUL_SMS_STRING_LEN + 1];
    char *pBufNew=OSAL_NULL;
    char *pBuf=string_buffer;

    tU32 u32MaxLen= (tU32)((STRING.tSize(hSmsStringObj)) +  1u);
    if (u32MaxLen < 1) {
        return 0;
    }

    /*if (!u32MaxLen) {
        u32MaxLen=FC_SXM_DEFAUL_SMS_STRING_LEN;
    }*/
    if (u32MaxLen>FC_SXM_DEFAUL_SMS_STRING_LEN) {
        pBufNew=OSAL_NEW char[u32MaxLen];
        pBuf=pBufNew;
    }

    if(OSAL_NULL != pBuf)
    {
        pBuf[0]=0;
        STRING.tCopyToCStr(hSmsStringObj, pBuf,u32MaxLen);
        /*SMS giving hexadecimal value as x12 instead of 0x12.
          This x12 will not be recognised by below function as hex*/
        s32Value= (tS32)(OSAL_s32StringToS32(&pBuf[1],OSAL_NULL,16));
    }

    if (OSAL_NULL != pBufNew) {
        OSAL_DELETE[] pBufNew;
    }

    return s32Value;
}

/*********************************************************************
 *FUNCTION:     fc_sxm_vConvertSmsString2Double
 *DESCRIPTION:  
 *PARAMETER:  STRING_OBJECT hSmsStringObj
 *RETURNVALUE:  
 ********************************************************************/
tDouble fc_sxm_vConvertSmsString2Double(STRING_OBJECT hSmsStringObj)
{
    tDouble dRetVal= 0;
    char string_buffer[FC_SXM_DEFAUL_SMS_STRING_LEN + 1];
    char *pBufNew=OSAL_NULL;
    char *pBuf=string_buffer;

    tU32 u32MaxLen= (tU32)((STRING.tSize(hSmsStringObj)) + 1u);
    if (u32MaxLen < 1) {
        return 0;
    }

    if (u32MaxLen>FC_SXM_DEFAUL_SMS_STRING_LEN) {
        pBufNew=OSAL_NEW char[u32MaxLen];
        pBuf=pBufNew;
    }


    if(OSAL_NULL != pBuf)
    {
        pBuf[0]=0;
        STRING.tCopyToCStr(hSmsStringObj, pBuf,u32MaxLen);
        dRetVal=OSAL_dStringToDouble(pBuf,OSAL_NULL);
    }

    if (OSAL_NULL != pBufNew) {
        OSAL_DELETE[] pBufNew;
    }
    return dRetVal;
}

/*********************************************************************
 *FUNCTION:     fc_sxm_vConvertSmsString2int
 *DESCRIPTION:  
 *PARAMETER:  STRING_OBJECT hSmsStringObj
 *RETURNVALUE:  
 ********************************************************************/
tS32 fc_sxm_vConvertSmsString2int(STRING_OBJECT hSmsStringObj)
{
    tS32 s32RetVal = 0;
    char string_buffer[FC_SXM_DEFAUL_SMS_STRING_LEN + 1];
    char *pBufNew=OSAL_NULL;
    char *pBuf=string_buffer;

    tU32 u32MaxLen= (tU32)((STRING.tSize(hSmsStringObj)) + 1u);
    if (u32MaxLen < 1) {
        return 0;
    }

    if (u32MaxLen>FC_SXM_DEFAUL_SMS_STRING_LEN) {
        pBufNew=OSAL_NEW char[u32MaxLen];
        pBuf=pBufNew;
    }


    if(OSAL_NULL != pBuf)
    {
        pBuf[0]=0;
        STRING.tCopyToCStr(hSmsStringObj, pBuf,u32MaxLen);
        s32RetVal= (tS32)(OSAL_s32StringToS32(pBuf,OSAL_NULL,10));
    }

    if (OSAL_NULL != pBufNew) {
        OSAL_DELETE[] pBufNew;
    }
    return s32RetVal;
}

/*********************************************************************
 *FUNCTION:     fc_sxm_vCopySmsString2CStr
 *DESCRIPTION:  
 *PARAMETER:  STRING_OBJECT hSmsStringObj, tPS8 ps8DstPath,tU32 u32MaxLen=0
 *RETURNVALUE:  
 ********************************************************************/
tVoid fc_sxm_vCopySmsString2CStr(STRING_OBJECT hSmsStringObj, tPS8 ps8DstPath,tU32 u32MaxLen=0)
{
   if(OSAL_NULL != ps8DstPath)
   {
       STRING.tCopyToCStr(hSmsStringObj,(char *)ps8DstPath,u32MaxLen);
   }
}

/*********************************************************************
 *FUNCTION:     fc_sxm_vCopyInt2FiString
 *DESCRIPTION:  
 *PARAMETER:  tU32 u32Int, midw_ext_fi_tclString &rFiString,tU32 u32MaxLen
 *RETURNVALUE:  
 ********************************************************************/
tVoid fc_sxm_vCopyInt2FiString(tU32 u32Int, midw_ext_fi_tclString &rFiString,tU32 u32MaxLen)
{
    char string_buffer[u32MaxLen + 1];
    char *pBufNew=OSAL_NULL;
    char *pBuf=string_buffer;
    if (!u32MaxLen) {
        u32MaxLen=FC_SXM_DEFAUL_SMS_STRING_LEN;
    }
    if (u32MaxLen>FC_SXM_DEFAUL_SMS_STRING_LEN) {
        pBufNew=OSAL_NEW char[u32MaxLen];
        pBuf=pBufNew;
    }

    if(OSAL_NULL != pBuf)
    {
        pBuf[0]=0;
        OSAL_s32PrintFormat((tChar*)pBuf,"%d",u32Int);
        fc_sxm_vString2Fi(pBuf, rFiString);
    }

    if (OSAL_NULL != pBufNew) {
        OSAL_DELETE[] pBufNew;
    }
}


/*********************************************************************
 *FUNCTION:     fc_sxm_fFixed2Float
 *DESCRIPTION:  
 *PARAMETER:  OSAL_FIXED_OBJECT hFixed
 *RETURNVALUE:  
 ********************************************************************/
float fc_sxm_fFixed2Float(OSAL_FIXED_OBJECT hFixed)
{
    float fReturnValue = 0.0;

    if(hFixed != OSAL_FIXED_INVALID_OBJECT)
    {
        double f1=OSAL_FIXED.n32Value(hFixed);
        unsigned long long l1=1;
        l1<<= OSAL_FIXED.un8NumFractionalBits(hFixed);
        fReturnValue = (tF32)(f1 / (double)l1);
    }

    return fReturnValue;
}


/*********************************************************************
 *FUNCTION:     fc_sxm_fKm2Miles
 *DESCRIPTION:  
 *PARAMETER:  float fMiles
 *RETURNVALUE:  Miles
 ********************************************************************/
float fc_sxm_fKm2Miles(float fMiles) {
    return fMiles * 0.62137119f ;
}

/*********************************************************************
 *FUNCTION:     fc_sxm_vString2Fi
 *DESCRIPTION:  
 *PARAMETER:  tCString sSrcString,  midw_ext_fi_tclString& rffiObj
 *RETURNVALUE:  
 ********************************************************************/
tVoid fc_sxm_vString2Fi(tCString sSrcString,  midw_ext_fi_tclString& rffiObj)
{
    if(OSAL_NULL != sSrcString)
    {
        /* Convert the string to ISO-8859-1 format Call the function to convert the string to ISO-8859-1 format */
        (tVoid) rffiObj.bSet(sSrcString, midw_ext_fi_tclString::FI_EN_ISO8859_1M);
    }
}

/*********************************************************************
 *FUNCTION:     fc_sxm_oSmsDataServiceState2Fi
 *DESCRIPTION:  
 *PARAMETER:  DATASERVICE_STATE_ENUM enState
 *RETURNVALUE:  
 ********************************************************************/
midw_ext_fi_tcl_e8_SxmDataServiceStatus fc_sxm_oSmsDataServiceState2Fi(DATASERVICE_STATE_ENUM enState) {
    midw_ext_fi_tcl_e8_SxmDataServiceStatus oFiRes;
    midw_ext_fi_tcl_e8_SxmDataServiceStatus::tenType &enFiStatus=oFiRes.enType;
    switch(enState)
    {
        case DATASERVICE_STATE_INITIAL:
        case DATASERVICE_STATE_STOPPED:
        case DATASERVICE_STATE_ERROR:
        case DATASERVICE_STATE_INVALID:
            enFiStatus=midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_UNKNOWN;
            break;

        case DATASERVICE_STATE_UNAVAILABLE:
            enFiStatus=midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_NOT_AVAILABLE;
            break;

        case DATASERVICE_STATE_UNSUBSCRIBED:
        case DATASERVICE_STATE_POI_UPDATES_ONLY:
            enFiStatus=midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_NOT_SUBSCRIBED;
            break;

        case DATASERVICE_STATE_READY:
            enFiStatus=midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_SUBSCRIBED;
            break;

        default:
            enFiStatus=midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_UNKNOWN;
            break;
    }
        
    return oFiRes;
}

/*********************************************************************
 *FUNCTION:     fc_sxm_szSmsDataServiceStateFiToString
 *DESCRIPTION:  
 *PARAMETER:  midw_ext_fi_tcl_e8_SxmDataServiceStatus enFiState
 *RETURNVALUE:  
 ********************************************************************/
char const *fc_sxm_szSmsDataServiceStateFiToString(midw_ext_fi_tcl_e8_SxmDataServiceStatus enFiState) {
    switch(enFiState.enType) {
        case midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_UNKNOWN: 
            return "FI_EN_UNKNOWN";
        case midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_SUBSCRIBED: 
            return "FI_EN_SUBSCRIBED";
        case midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_NOT_SUBSCRIBED: 
            return "FI_EN_NOT_SUBSCRIBED";
        case midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_NOT_AVAILABLE: 
            return "FI_EN_NOT_AVAILABLE";
        case midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_NO_ANTENNA: 
            return "FI_EN_NO_ANTENNA";
        case midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_NO_SIGNAL: 
            return "FI_EN_NO_SIGNAL";
        default:
            return "INVALID";
    }

}

static char chartolower(char c)
{
	return (char) tolower((int) c);
}

tVoid fc_sxm_vToLower(string &oName) {
    transform(oName.begin(), oName.end(), oName.begin(), chartolower);
}


tBool fc_sxm_bFileExists(string const &oName) {
    if (FILE * fp =fopen(oName.c_str(), "r")) {
        fclose(fp);
        return TRUE;
    }
    return FALSE;
}


/*********************************************************************
 *FUNCTION:     fc_sxm_pValidateString
 *DESCRIPTION:  
 *PARAMETER:  const tChar* lStringToCheck
 *RETURNVALUE:  
 ********************************************************************/
tBool fc_sxm_pValidateString(const tChar* lStringToCheck)
{
    tBool returnFlag = FALSE;
	if(strlen(lStringToCheck) != strspn(lStringToCheck," "))
	{
        returnFlag = TRUE;
	}

	return(returnFlag);
}
/*********************************************************************
 *FUNCTION:     vReplaceChars
 *DESCRIPTION:  Utility method that does a search and replace of a character
                in the given string
 *PARAMETER:    1) Handle to to std::string object which has to be searched. 
                2) Character to be searched
				3) Character to be replaced with
 *RETURNVALUE:  None
 ********************************************************************/
tVoid vReplaceChars(string& sInput, tChar chFind, tChar chReplace)
{
	size_t found = sInput.find_first_of(chFind);
	while(found != string::npos)
	{
		sInput[found] = chReplace;
		found = sInput.find_first_of(chFind, found+1);
	}
}

/*********************************************************************
 *FUNCTION:     vConvertTTFisString2FIString
 *DESCRIPTION:  Utility method reads TTFIs string input and converts it into
 *DESCRIPTION:   FI string object.
 *PARAMETER:    Pointer to the TTFIs string object, Handle to FI string object
 *RETURNVALUE:  None
 ********************************************************************/
tVoid vConvertTTFisString2FIString( tCString chInString, midw_ext_fi_tclString& rffiObj)
{
	//Method reads TTFIs string object and converts it into FI string
	//This method cannot be invoked directly from HMI and gets executed only when user enters
	// string inputs from TTFI
	string sTTFisString(chInString);
	vReplaceChars(sTTFisString, '+', ' ');
	fc_sxm_vString2Fi(sTTFisString.c_str() ,rffiObj);
}

