/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_config.h
* @brief       Configuration for fc_sxm
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_CONFIG_H_
#define _FC_SXM_CONFIG_H_

/*
  here defines to configure the build of fc_sxm should be placed
 */

#ifdef GEN3X86
#define FC_SXM_SERIAL_DEVICE                     "/dev/ttyS0"
#define FC_SXM_SMS_UART_PARAMS ("115200,N,8,1")
#elif SMS_64_BIT_SUPPORT
#define FC_SXM_SERIAL_DEVICE                      "/dev/ttySC3"
#define FC_SXM_SMS_UART_PARAMS ("115200,N,8,1")
#else 
#define FC_SXM_SERIAL_DEVICE                     "/dev/ttymxc2"
#define FC_SXM_SMS_UART_PARAMS ("921600,N,8,1")
#endif

#define FC_SXM_SMS_OSAL_BASE_PATH                "/dev/ffs/siriusxm/cfg-" // gets furter extended by ahl
#define FC_SXM_SMS_FFS_BASE_PATH                 "/var/opt/bosch/dynamic/ffs/siriusxm"
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AIVI_SRC_OFFSET_IN // todo: create specific feature-switch
#define FC_SXM_STATIC_SIRIUSXM_PATH              "/var/opt/bosch/static/dynamic_init/ffs/siriusxm"
#define FC_SXM_STATIC_SMS_CFG_PATH               "/var/opt/bosch/static/dynamic_init/ffs/siriusxm/sms_hb"
#define FC_SXM_STATIC_SDK_W_PATH                 "/var/opt/bosch/static/dynamic_init/ffs/siriusxm/W"
#define FC_SXM_STATIC_SDK_R_PATH                 "/var/opt/bosch/static/dynamic_init/ffs/siriusxm/R"
#else
#define FC_SXM_STATIC_SIRIUSXM_PATH              "/var/opt/bosch/static/siriusxm"
#define FC_SXM_STATIC_SMS_CFG_PATH               "/var/opt/bosch/static/siriusxm/sms_hb"
#define FC_SXM_STATIC_SDK_W_PATH                 "/var/opt/bosch/static/siriusxm/W"
#define FC_SXM_STATIC_SDK_R_PATH                 "/var/opt/bosch/static/siriusxm/R"
#endif
#define FC_SXM_STATIC_SDK_W_PARKING_PATH         FC_SXM_STATIC_W_SMS_CFG_PATH"/parking"
#define FC_SXM_DEFAULT_SMS_CFG_PATH              FC_SXM_SMS_FFS_BASE_PATH"/sms_hb"
#define FC_SXM_DEFAULT_SDK_W_PATH                FC_SXM_SMS_FFS_BASE_PATH"/W"
#define FC_SXM_DEFAULT_SDK_W_PARKING_PATH        FC_SXM_DEFAULT_SDK_W_PATH"/parking"
#define FC_SXM_DEFAULT_SDK_R_PATH                FC_SXM_SMS_FFS_BASE_PATH"/R"
#define FC_SXM_DEFAULT_T_SPORTS_BASE_PATH   	 FC_SXM_SMS_FFS_BASE_PATH"/T/sports/"
#define FC_SXM_DEFAULT_T_SPORTS_CYCLE_PATH   	 FC_SXM_SMS_FFS_BASE_PATH"/T/sports/cycle"
#define FC_SXM_DEFAULT_T_PARKING_BASE_PATH        FC_SXM_SMS_FFS_BASE_PATH"/T/parking/"
#define FC_SXM_DEFAULT_T_PARKING_CYCLE_PATH       FC_SXM_SMS_FFS_BASE_PATH"/T/parking/cycle"
//#define FC_SXM_SMS_TEMP_DIR_PATH                 FC_SXM_SMS_FFS_BASE_PATH"/tmp"
#define FC_SXM_SMS_TEMP_DIR_PATH                 "/tmp"
#define FC_SXM_AGW_SMS_AGW_RASTERS_PATH				 FC_SXM_DEFAULT_SMS_CFG_PATH"/agw/agw_rasters" //currently not in use, to be removed

//Raster Volatile memory path
#define TMP_FC_SXM_AGW_SMS_AGW_RASTERS_PATH            "/tmp/sxm_agw_rasters"

#define FC_SXM_RADIO_NAME                        "radio:"
#define FC_SXM_SRH_DRIVER_NAME                   "srh:"

//Phonetics dic files path
#define FC_SXM_DEFAULT_SMS_PHONETICS_DB_PATH         FC_SXM_DEFAULT_SMS_CFG_PATH"/phonetics/phonetics_ref.db"
#define FC_SXM_DEFAULT_SMS_PHONETICS_APP_PATH        FC_SXM_DEFAULT_SMS_CFG_PATH"/phonetics/app"
#define FC_SXM_DEFAULT_SMS_PHONETICS_TTS_PATH        FC_SXM_DEFAULT_SMS_PHONETICS_APP_PATH"/tts"
#define FC_SXM_DEFAULT_SMS_PHONETICS_REC_PATH        FC_SXM_DEFAULT_SMS_PHONETICS_APP_PATH"/rec"
#define FC_SXM_DEFAULT_SMS_PHONETICS_REC_ENG_PATH    FC_SXM_DEFAULT_SMS_PHONETICS_REC_PATH"/channels_eng.dic"
#define FC_SXM_DEFAULT_SMS_PHONETICS_REC_ESP_PATH    FC_SXM_DEFAULT_SMS_PHONETICS_REC_PATH"/channels_esp.dic"
#define FC_SXM_DEFAULT_SMS_PHONETICS_REC_FR_PATH     FC_SXM_DEFAULT_SMS_PHONETICS_REC_PATH"/channels_fr.dic"
//Phonetics file mode
#define PHONETICS_FILE_MODE "rb"
//Phonetics max string length
#define PHONETICS_MAX_NUMCHARS (80)


//agw-products enabled- nowrad,storm-track
#define FC_SXM_AGW_ENABLE_NOWRAD  			1
#define FC_SXM_AGW_ENABLE_STORM_TRACK 		1

//agw-products disabled- wind mag,wind dir,storm-attributes
#define FC_SXM_AGW_ENABLE_WIND_MAG 			1
#define FC_SXM_AGW_ENABLE_WIND_DIR 			1
#define FC_SXM_AGW_ENABLE_SURFACE 			1
#define FC_SXM_AGW_ENABLE_STORM_ATTRIBUTES 	1



// set to disable all
// #define FC_SXM_DISABLE_SMS

// set to disable specific data-services
//#define FC_SXM_DISABLE_AGW
//#define FC_SXM_DISABLE_FUEL
//#define FC_SXM_DISABLE_MOVIES
//#define FC_SXM_DISABLE_TRAFFIC
//#define FC_SXM_DISABLE_TABWEATHER
//#define FC_SXM_DISABLE_CHANNELART
//#define FC_SXM_DISABLE_STOCKS
//#define FC_SXM_DISABLE_SPORTS
//#define FC_SXM_DISABLE_CANADIAN_FUEL
#define FC_SXM_DISABLE_SAFEVIEW
//#define FC_SXM_DISABLE_AUDIOROUTING_LIB

#define FC_SXM_CVON_ENABLE         1
#define FC_SXM_SMSLIB_CVON_ENABLE  1

// time to wait before sms is started
#define FC_SXM_DELAY_STARTUP_SMS_MS 0
// time to wait after audio-decoder ready until data-services are started
#define FC_SXM_DELAY_STARTUP_DATA_MS 0
// time to wait after audio-decoder ready until audio-decoder is used
#define FC_SXM_DELAY_STARTUP_AUDIO_MS 0

#define FC_SXM_MAX_DATA_APP_RESTARTS 3
/* If !=0, data-services are started one by one.
   next service is started on timeout of if previous has gone to ready.
 */
#define FC_SXM_DATA_SERVICE_MAX_START_TIME 1000

/* Delay the device position updates, default is 5 second */
#define FC_SXM_DEVICE_POSITION_UPDATE_INTERVAL 15000

/* Enable the SXM watchdog timer */
#define FC_SXM_ENABLE_WATCHDOG_TIMER   0

#define FC_SXM_ENABLE_LCM_WATCHDOG_TIMER   1

/* Time interval for the SXM watch dog timer */
#define FC_SXM_WATCHDOG_INTERVAL 1000

#define FC_SXM_WATCHDOG_TIMER_MAX_CYCLES 60

/*
  Time we wait for all data-services to stop.
 */
#define FC_SXM_DATA_SERVICES_MAX_STOP_TIME 1000

/*
  Time to delay the update of List data
 */
#define FC_SXM_LIST_DATA_UPDATE_PERIOD  10000  // in ms

// Enable Sorting for Featured Favorite Category
#define FC_SXM_ENABLE_FEATURED_FAVORITE_SORTING   1



////////////////////////////////////////////////////////////////////////////////////
/***************              DSRL Configuration                *******************/
////////////////////////////////////////////////////////////////////////////////////


//Movies start [[
#define FC_SXM_MOVIES_DEVICE_DSRL_CAPACITY 60
#define FC_SXM_MOVIES_DEVICE_DSRL_RADIUS 30

#define FC_SXM_MOVIES_FAVORITE_DSRL_CAPACITY 12
#define FC_SXM_MOVIES_FAVORITE_DSRL_RADIUS 0
//Movies End ]]

//Fuel Start [[
#define FC_SXM_FUEL_DEVICE_DSRL_CAPACITY 60
#define FC_SXM_FUEL_DEVICE_DSRL_RADIUS 30

#define FC_SXM_FUEL_FAVORITE_DSRL_CAPACITY 15
#define FC_SXM_FUEL_FAVORITE_DSRL_RADIUS 0

#define FC_SXM_FUEL_DESTINATION_DSRL_CAPACITY 60
#define FC_SXM_FUEL_DESTINATION_DSRL_RADIUS 30
//Fuel End ]]

//Tab Weather Start [[
#define FC_SXM_TABWEATHER_DEVICE_DSRL_CAPACITY 1
#define FC_SXM_TABWEATHER_DEVICE_DSRL_RADIUS 500

#define FC_SXM_TABWEATHER_FAVORITE_DSRL_CAPACITY 5
#define FC_SXM_TABWEATHER_FAVORITE_DSRL_RADIUS 0

#define FC_SXM_TABWEATHER_DESTINATION_DSRL_CAPACITY 1
#define FC_SXM_TABWEATHER_DESTINATION_DSRL_RADIUS 500

#define FC_SXM_TABWEATHER_STANDARD_DSRL_CAPACITY 1
#define FC_SXM_TABWEATHER_STANDARD_DSRL_RADIUS 500
//Tab Weather]]

//Stocks Start [[
#define FC_SXM_STOCKS_FAVORITE_DSRL_CAPACITY 20
#define FC_SXM_STOCKS_FAVORITE_DSRL_RADIUS 0
//Stocks End ]]

//Weather/Security Alerts Start [[
#define FC_SXM_WSALERTS_DEVICE_DSRL_CAPACITY 60
#define FC_SXM_WSALERTS_DEVICE_DSRL_RADIUS 50

#define FC_SXM_WSALERTS_DESTINATION_DSRL_CAPACITY 60
#define FC_SXM_WSALERTS_DESTINATION_DSRL_RADIUS 50

#define FC_SXM_WSALERTS_STANDARD_DSRL_CAPACITY 500
#define FC_SXM_WSALERTS_STANDARD_DSRL_RADIUS 3100

#define FC_SXM_WSALERTS_TTS_TIMEOUT 1000
#define FC_SXM_WSALERTS_TTS_RETRY_COUNTER 3
//Weather/Security Alerts End ]]

//Parking Start [[
#define FC_SXM_PARKING_NEARBY_CAPACITY 60
#define FC_SXM_SXM_PARKING_NEARBY_RADIUS 0.40  //25miles

#define FC_SXM_PARKING_NEARDESTINATION_CAPACITY 60
#define FC_SXM_SXM_PARKING_NEARDEST_RADIUS 0.40  //25miles

#define FC_SXM_PARKING_FAVORITES_CAPACITY 12
//Parking End ]]

/* logging rx-data to serial port.
   note: has to be additionally enabled in config-file
 */
#define FC_SXM_SMS_ENABLE_SERIAL_RX_LOG_TO_FILE
#define FC_SXM_SMS_SERIAL_RX_LOG_FILE FC_SXM_SMS_TEMP_DIR_PATH"/serialRx.txt"

#define FC_SXM_ENABLE_AUTO_RESTORE_SMS_HB_SERVICE
//#define FC_SXM_ENABLE_AUTO_RESTORE_SMS_HB

#ifdef GEN3X86
#define FC_SXM_SMS_GPIO_CTRL
#endif

#ifndef FC_SXM_TIME_PROFILE
//#define FC_SXM_TIME_PROFILE
#endif //FC_SXM_TIME_PROFILE

#endif

