/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_base_thread.h
* @brief       Declaration of worker-thread that is part of each sxm-app class
*              and only used by framework
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_BASE_THREAD_H_
#define _FC_SXM_TCL_BASE_THREAD_H_



#define AHL_S_IMPORT_INTERFACE_THREAD
#include "ahl_if.h"

#include "fc_sxm_common.h"
#include "fc_sxm_tcl_prio_queue.h"

#define FC_SXM_FIRST_USER_EVT 0x100

class fc_sxm_tclBaseApp;




class fc_sxm_tclBaseThread:private ahl_tclEventThread
{
 public:
    fc_sxm_tclBaseThread(fc_sxm_tclBaseApp *poApp, tCString szThreadName);

    tVoid vStart();
    tVoid vStop();
    tVoid vPostTimerEvent();
    tVoid vPostUserEvent(tU32 u32Mask= FC_SXM_FIRST_USER_EVT);


    tBool bAccess(tU32 u32Ms=OSAL_C_TIMEOUT_FOREVER );
    tVoid vRelease();
    /*
      Method to allocate and post the message "rMsg" with action-id "rMsg.u32Action" 
      to the owner of this thread (_poApp)
    */
    template<class M>
        tVoid vPostMsgNew(M const &rMsg) {
        M *pMsg=OSAL_NEW M(rMsg);
        vPostMsg(pMsg);
    }

    /*
      Method to post the message "prMsg" with action-id "u32Action" to the owner of this thread (_poApp)
      note: memory "prMsg" is pointing to has to be allocated by caller
    */
    tVoid vPostMsg(fc_sxm_tclMessage *prMsg);

    tChar const *szGetName() const {
        return _as8ThreadName;
    }
 protected:
    // thread loop worker function
    virtual tBool bThreadFunction(OSAL_tEventMask u32EventMask);

    virtual tVoid vHandleUserEvent(tU32 u32Mask){(tVoid)u32Mask;};

 private:
    fc_sxm_tclBaseThread(); // default constructor, not to be used



    tVoid vClearQ();
    // pointer to application that shall handle messages received by the worker thread
    fc_sxm_tclBaseApp *_poApp;
    fc_sxm_tclSem _oAccessSem;

    fc_sxm_tclPrioQueue<fc_sxm_tclMessage *> _oQ;

};

#endif // _FC_SXM_TCL_AUDIO_THREAD_H_
