/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_ttfis_cmd.h
* @brief       CCA Application for TTFIS command.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef _FC_SXM_TTFIS_CMD_H_
#define _FC_SXM_TTFIS_CMD_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "fc_sxm_main.h"

struct fc_sxm_trMsgCmdTtfisCmd;
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_sxm_tclTtfisCmd : 
    public fc_sxm_tclSingleton<fc_sxm_tclTtfisCmd>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclTtfisCmd>;

  public:

    fc_sxm_tclTtfisCmd(tVoid);
    virtual ~fc_sxm_tclTtfisCmd(tVoid);

    tVoid vProcess(fc_sxm_trMsgCmdTtfisCmd const *prMsg) const;

    //Trace Commnad Manager
    static tVoid vTraceCmdManager(const tUChar* puchData);

    tVoid vSendSelfMessage(const fi_tclMessageBase& roSendFiObj) const;

  private:
    tVoid vHandleTtfisCmd(tU8 u8MsgCode, tU8 const *pu8Data) const;
    tVoid vHandleCmdDirect(fc_sxm_trMsgCmdTtfisCmd &rCmd) const;

}; 

#endif //_FC_SXM_MAIN_H_

