/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_service_sxm_traffic.cpp
* @brief       Implementation of CCA service for sxm_traffic.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


/******************************************************************************/
/*                                                                            */
/*                                INCLUDES                                    */
/*                                                                            */
/******************************************************************************/
#include "fc_sxm_tcl_sxmapp_manager.h"
#include "fc_sxm_tcl_traffic_properties.h"
#include "fc_sxm_tcl_traffic_app.h"
#include "fc_sxm_service_sxm_traffic.h"





#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_SERVICE_SXM_TRAFFIC
#include "trcGenProj/Header/fc_sxm_service_sxm_traffic.cpp.trc.h"
#endif


/*=============================================================================
=======                      VARIABLES & MESSAGES                       =======
=============================================================================*/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define FC_SXM_SERVICE_SXM_TRAFFIC_FI_MAJOR_VERSION  1	
#define FC_SXM_SERVICE_SXM_TRAFFIC_FI_MINOR_VERSION  0
#define FC_SXM_SERVICE_SXM_TRAFFIC_FI_PATCH_VERSION  0

/*******************************************************************************
*
* FUNCTION:         constructor
*
* DESCRIPTION:      call contructor of base-class fc_sxm_tclBaseService
*
* PARAMETER:        None.
*
* RETURNVALUE:      None.

*******************************************************************************/

fc_sxm_tclTrafficService::
  fc_sxm_tclTrafficService()
    :fc_sxm_tclBaseService(
      /* ID of offered Service            */ CCA_C_U16_SRV_SXM_TRAFFIC,
      /* MajorVersion of offered Service  */ FC_SXM_SERVICE_SXM_TRAFFIC_FI_MAJOR_VERSION,
      /* MinoreVersion of offered Service */ FC_SXM_SERVICE_SXM_TRAFFIC_FI_MINOR_VERSION,
      /* PatchVersion of offered Service  */ FC_SXM_SERVICE_SXM_TRAFFIC_FI_PATCH_VERSION)
{
  ETG_TRACE_USR4(("fc_sxm_tclTrafficService() entered."));
}

/*******************************************************************************
*
* FUNCTION:         destructor
*
* DESCRIPTION:      
*
* PARAMETER:        None.
*
* RETURNVALUE:      None.

*******************************************************************************/

fc_sxm_tclTrafficService::~fc_sxm_tclTrafficService(tVoid)
{
  ETG_TRACE_USR4(("~fc_sxm_tclTrafficService() entered."));
}

/*******************************************************************************
*
* FUNCTION:         vOnServiceAvailable()
*
* DESCRIPTION:      This function is called by the CCA framework when the service
*                   which is offered by this server has become available.
*
* PARAMETER:        None.
*
* RETURNVALUE:      None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_sxm_tclTrafficService::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("vOnServiceAvailable() entered."));
}

/*******************************************************************************
*
* FUNCTION:         vOnServiceUnavailable()
*
* DESCRIPTION:      This function is called by the CCA framework when the service
*                   which is offered by this server has become unavailable.
*
* PARAMETER:        None.
*
* RETURNVALUE:      None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_sxm_tclTrafficService::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));
}

/*******************************************************************************
*
* FUNCTION: tBool fc_sxm_tclTrafficService
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object and to copy it to the
*              referenced service data object 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = For the requested property the FI data object was
*                     successfully created and copied to the referenced service
*                     data object 'roOutMsg'. The CCA framework sends a 'STATUS'
*                     message of the updated property to each registered
*                     clients.
*              FALSE = Failed to create the FI data object for the requested
*                      property and to update the referenced service data object
*                      'roOutMsg' with the new property content. The CCA
*                      framework sends an error message to the requesting
*                      client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool fc_sxm_tclTrafficService
      ::bStatusMessageFactory(tU16 u16FunctionId,
                              amt_tclServiceData& roOutMsg,
                              amt_tclServiceData* poInMsg)
{
    (tVoid) poInMsg;  /* These lines are added to avoid LINT warnings. Please */
    (tVoid) roOutMsg; /* remove as soon as the variables are used. */

     tBool bResult = FALSE;

     ETG_TRACE_USR4(("bStatusMessageFactory() entered. FID = 0x%4x.", 
                                                           u16FunctionId));
   
     switch(u16FunctionId)
         {
             /* handle request for fi-status-messages.
                For each funtion-id use macro "SXM_PGET_ENTRY" to read the corresponding property 
                and write it to  "roOutMsg" */

             /* for RdbidActualList Property */
             SXM_PGET_ENTRY_FIMSG(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_RDBIDACTUALLIST,     /* the cca-function-id */
                                sxm_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus,     /* the fi-type of the response (status) */
                                fc_sxm_tclTrafficProperties::instance()->oUpdateRdbidActualList);  /* the property holding the needed values */

             /* for TunerStateMode Property */
             SXM_PGET_ENTRY_FIMSG(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_TUNERSTATEANDMODE,   /* the cca-function-id */
                                sxm_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus,   /* the fi-type of the response (status) */
                                fc_sxm_tclTrafficProperties::instance()->oUpdateTunerStateAndMode);  /* the property holding the needed values */

            /* for TmcData Property */
            SXM_PGET_ENTRY_FIMSG(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_TMCDATA, /* the cca-function-id */
                                sxm_tclMsgFID_TRAFFIC_G_TmcDataStatus, /* the fi-type of the response (status) */
                                fc_sxm_tclTrafficProperties::instance()->oUpdateTmcData);  /* the property holding the needed values */

            /* for TmcInfo Property */
            SXM_PGET_ENTRY_FIMSG(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_TMCINFO, /* the cca-function-id */
            		            sxm_tclMsgFID_TRAFFIC_G_TmcInfoStatus, /* the fi-type of the response (status) */
                                fc_sxm_tclTrafficProperties::instance()->oUpdateTmcInfo);  /* the property holding the needed values */



            // Handle creation of the FI data object for this function ID and the
            // handover to the referenced service data object 'roOutMsg' here ...

            // Set local variable 'bResult' to TRUE if the creation of the FI data 
            // object and the handover to 'roOutMsg' was successfull.

           //peha: for each property use MACRO SXM_PGET_ENTRY
          // bResult = TRUE;

           default:
               break;
     }
   


    // if (FALSE == bResult)
    // {
     //    ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.",
                                                                                //u16FunctionId));
     //    NORMAL_M_ASSERT_ALWAYS();
    // }
     return bResult;
}

/*******************************************************************************
*
*FUNCTION:          vOnMethodStart
*
*DESCRIPTION:       handle method-start message poMessage for function-id u16FunctionId  
*
*PARAMETERS:        u16FunctionId,  poMessage
*
*RETURNVALUES:      None
*                    
*********************************************************************************/

tVoid fc_sxm_tclTrafficService::vOnMethodStart(tU16 u16FunctionId, amt_tclServiceData* poMessage)
{

    ETG_TRACE_USR4(("vOnMethodStart() entered. FID = 0x%4x.", 
                  u16FunctionId));


    switch (u16FunctionId) 
    {
        /* use macro SXM_MSTART_ENTRY for each suported function-id:
           fill according thread-message for fiObject and adressing 
           according to "poMessage" and send message accoring to u32Action of thread-message */

        /* for rdbidWishList Method start */
        SXM_MSTART_ENTRY(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_S_SETRDBID, /* the cca function-id */
                       sxm_tcl_MsgFID_TRAFFIC_S_SetRdbIdMethodStart, /* the corresponding fi-type */
                       fc_sxm_trMsgTrafficMStartSetRdbIdWishList );  /* the message that shall be sent to app */
            
        default:
            vOnUnknownMessage(poMessage);
            break;
    }
}


/*******************************************************************************
*
* FUNCTION: tBool fc_sxm_tclTrafficService
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has 
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Property successfully set to the passed value. The CCA
*                     framework sends a 'STATUS' message to the requesting
*                     client if the opcode was 'SET'. Othwerwise if opcode
*                     was 'PURESET' there is no 'STATUS' message sent to the
*                     requesting client. The CCA framework will send a 'STATUS'
*                     message to other registered clients as well if the [OUT]
*                     parameter 'bPropertyChanged' is set to TRUE.
*             FALSE = Failed to set the property to the passed value. The CCA
*                     framework sends an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
/*
  not used, please try to avoid opcode "Set"
*/
/* to check for traffic */
tBool fc_sxm_tclTrafficService
      ::bProcessSet(amt_tclServiceData* poMessage,
                    tBool& bPropertyChanged,
                    tU16& u16ErrorCode)
{
    (tVoid) bPropertyChanged; // This line is added to avoid LINT warnings.
                              // Please remove as soon as the variable is used.

     tBool bResult = FALSE;

     tU16 u16FunctionId = poMessage->u16GetFunctionID();

     ETG_TRACE_USR4(("bProcessSet() entered. FID = 0x%4x.", u16FunctionId));

     fi_tclVisitorMessage oVisitorMsg(poMessage);

     //switch(u16FunctionId)
     //{
         /* Handle property setting for this function ID here ... 

            Set local variable 'bResult' to TRUE if setting the propery to the new
            value was successfull.

            Set [OUT] parameter 'bPropertyChanged' to TRUE if the value of the just
            set property has changed. */
     //}
     //if (FALSE == bResult)
     //{
         u16ErrorCode = CCA_C_U16_ERROR_UNKNOWN_FCT_ID;
         ETG_TRACE_ERR(("bProcessSet(). Setting of property with 'FID = %u' failed.",
                                                                         u16FunctionId));
         NORMAL_M_ASSERT_ALWAYS();
     //}

     return bResult;
}


/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tclTrafficService::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the vOnTimer() function of this
*              CCA application on the expiration of a previously via function
*              bStartTimer() started timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
*******************************************************************************/
/*
  not used: timers should only be used in worker-context
*/
tVoid fc_sxm_tclTrafficService::vProcessTimer(tU16 u16TimerId) const
{
    ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));

#if 0 /* TBD- for traffic */
  gm_tclU32Message oExampleMsg(_poMainAppl->u16GetAppId(),  // Source AppID 
                               _poMainAppl->u16GetAppId(),  // Target AppID 
                               0,                           // RegisterID   
                               0,                           // CmdCounter  
                               _u16ServiceID,               // ServiceID   
                               SXM_FUEL_C_U16_IFID_EXAMPLE_1,  // Function ID
                               AMT_C_U8_CCAMSG_OPCODE_STATUS  // Opcode
                              );

  oExampleMsg.vSetDWord(SXM_FUEL_C_U32_MSGID_EXAMPLE_1);  

  if ( oExampleMsg.bIsValid() )
  {
    if (_poMainAppl->enPostMessage(&oExampleMsg, TRUE) != AIL_EN_N_NO_ERROR)
    {  
      NORMAL_M_ASSERT_ALWAYS();
    }
  }
  else
  {  
    NORMAL_M_ASSERT_ALWAYS();
  }
#endif
}


