/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_service_sxm_tabweather.h
* @brief       CCA service sxm_tabweather.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef _FC_SXM_SERVICE_SXM_TABWEATHER_H_
#define _FC_SXM_SERVICE_SXM_TABWEATHER_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/


#include "fc_sxm_tabweather_fi.h"

#include "fc_sxm_tcl_base_service.h"

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

            /* Definition of internal Function IDs (iFIDs) and message        */
            /* content IDs (MSGID) which are not public and therefore are     */
            /* not in the public FI of our service. Such internal function    */
            /* and message content IDs are necessary for 'loopback' messages, */
            /* i.e. messages the application sends itself. These internal     */
            /* function IDs must be different to the ones from the public FI. */
            /* The developer has to take care about that. To have a maximum   */
            /* separation of the public and the internal FIDs we start the    */
            /* definition for the internal ones nearly at the end of the      */
            /* possible range and then count downwards.*/

                                                // Internal function ID defines.
#define SXM_TABWEATHER_C_U16_IFID_EXAMPLE_1 0xFFF0

                                                  // Message content ID defines.
#define SXM_TABWEATHER_C_U32_MSGID_EXAMPLE_1 0x00000001

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadService;

class fc_sxm_tclTabweatherService : 
public fc_sxm_tclBaseService,
public fc_sxm_tclSingleton<fc_sxm_tclTabweatherService>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclTabweatherService>;
 private:
    fc_sxm_tclTabweatherService();  
  public:

    virtual ~fc_sxm_tclTabweatherService();

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    tVoid vOnLoopbackService(amt_tclServiceData* poMessage) const;
    tVoid vProcessTimer(tU16 u16TimerId);

  protected:

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadService methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();
    virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
    virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
    virtual tVoid vOnMethodStart(tU16 u16FunctionId, amt_tclServiceData* poMessage);



};

#endif // _FC_SXM_SERVICE_SXM_TABWEATHER_H_

