/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_service_sxm_audio.cpp
* @brief       Implementation of CCA service sxm_audio.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "fc_sxm_types.h"
#include "fc_sxm_service_sxm_audio.h"
#include "fc_sxm_audio_app_if.h"


#include "fc_sxm_tcl_sxmapp_manager.h"
#include "fc_sxm_diag_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_SERVICE_SXM_AUDIO
#include "trcGenProj/Header/fc_sxm_service_sxm_audio.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define FC_SXM_SERVICE_SXM_AUDIO_FI_MAJOR_VERSION  2
#define FC_SXM_SERVICE_SXM_AUDIO_FI_MINOR_VERSION  7
#define FC_SXM_SERVICE_SXM_AUDIO_FI_PATCH_VERSION  8

/*
  constructor: call contructor of base-class fc_sxm_tclBaseService
*/
fc_sxm_tclAudioService::
  fc_sxm_tclAudioService()
    :fc_sxm_tclBaseService(
      /* ID of offered Service            */ CCA_C_U16_SRV_SXM_AUDIO,
      /* MajorVersion of offered Service  */ FC_SXM_SERVICE_SXM_AUDIO_FI_MAJOR_VERSION,
      /* MinoreVersion of offered Service */ FC_SXM_SERVICE_SXM_AUDIO_FI_MINOR_VERSION,
      /* PatchVersion of offered Service  */ FC_SXM_SERVICE_SXM_AUDIO_FI_PATCH_VERSION)
{
  ETG_TRACE_USR4(("fc_sxm_tclAudioService() entered."));
}

/*
  Destructor
*/
fc_sxm_tclAudioService::~fc_sxm_tclAudioService(tVoid)
{
  ETG_TRACE_USR4(("~fc_sxm_tclAudioService() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tclAudioService::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              which is offered by this server has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_sxm_tclAudioService::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("vOnServiceAvailable() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tclAudioService::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              which is offered by this server has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_sxm_tclAudioService::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));
}

/*******************************************************************************
*
* FUNCTION: tBool fc_sxm_tclAudioService
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object and to copy it to the
*              referenced service data object 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = For the requested property the FI data object was
*                     successfully created and copied to the referenced service
*                     data object 'roOutMsg'. The CCA framework sends a 'STATUS'
*                     message of the updated property to each registered
*                     clients.
*              FALSE = Failed to create the FI data object for the requested
*                      property and to update the referenced service data object
*                      'roOutMsg' with the new property content. The CCA
*                      framework sends an error message to the requesting
*                      client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool fc_sxm_tclAudioService
      ::bStatusMessageFactory(tU16 u16FunctionId,
                              amt_tclServiceData& roOutMsg,
                              amt_tclServiceData* /* poInMsg */)
{
  tBool bResult  = FALSE;

  ETG_TRACE_USR4(("bStatusMessageFactory() entered. FID = 0x%4x.", 
                  u16FunctionId));

  switch(u16FunctionId)
  {
      /* Channel list status */
      SXM_PGET_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_CHANNELLISTSTATUS,
                     midw_ext_sxm_audiofi_tclMsgChannelListStatusStatus,
                     fc_sxm_tclAudioProperties::instance()->oChannelListStatus)

      /* Channel information status */
      SXM_PGET_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_CHANNELINFORMATION,
                     midw_ext_sxm_audiofi_tclMsgChannelInformationStatus,
                     fc_sxm_tclAudioProperties::instance()->oChannelInformation)

      /* Auto Compare status */
      SXM_PGET_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_AUTOCOMPARE,
                     midw_ext_sxm_audiofi_tclMsgAutoCompareStatus,
                     fc_sxm_tclAudioProperties::instance()->oAutoCompare)

      /* System message */
      SXM_PGET_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SYSTEMMESSAGE,
                     midw_ext_sxm_audiofi_tclMsgSystemMessageStatus,
                     fc_sxm_tclAudioProperties::instance()->oSystemMessage)

      /* Instant Replay status */
      SXM_PGET_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_INSTANTREPLAYSTATUS,
                     midw_ext_sxm_audiofi_tclMsgInstantReplayStatusStatus,
                     fc_sxm_tclAudioProperties::instance()->oInstantReplayStatus)

      /* Instant Replay mode */
      SXM_PGET_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_INSTANTREPLAYMODE,
                     midw_ext_sxm_audiofi_tclMsgInstantReplayModeStatus,
                     fc_sxm_tclAudioProperties::instance()->oInstantReplayMode)

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SXMDATASERVICESTATUS, // the cca-function-id
                     midw_ext_sxm_audiofi_tclMsgSxmDataServiceStatusStatus, //the fi-type of the response (status)
                     fc_sxm_tclAppManager::instance()->oSxmDataServiceStatusFi)  // the property holding the needed values

      /* Data services antenna status */
      SXM_PGET_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SXMDATASERVICEANTENNASTATUS,
                     midw_ext_sxm_audiofi_tclMsgSxmDataServiceAntennaStatusStatus,
                     fc_sxm_tclAudioProperties::instance()->oDSAntennaStatus)

      /* Category list status */
      SXM_PGET_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_CATEGORYLISTSTATUS,
                     midw_ext_sxm_audiofi_tclMsgCategoryListStatusStatus,
                     fc_sxm_tclAudioProperties::instance()->oCategoryListStatus)

      /* Audio service subscription info */
      SXM_PGET_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SXMAUDIOSUBINFO,                        // the cca-function-id
                     midw_ext_sxm_audiofi_tclMsgSxmAudioSubInfoStatus,                  // the fi-type of the response (status)
                     fc_sxm_tclAudioProperties::instance()->oAudioSubscriptionStatus)  // the property holding the needed values

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_PRESETCHANNELUPDATE, // the cca-function-id
    		  	  	 midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus, //the fi-type of the response (status)
    		  	  	 fc_sxm_tclAudioProperties::instance()->oPresetInfo)  // the property holding the needed values

	 SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_PRESETLISTUPDATE, // the cca-function-id
					 midw_ext_sxm_audiofi_tclMsgPresetListUpdateStatus, //the fi-type of the response (status)
					 fc_sxm_tclAudioProperties::instance()->oPresetListUpdate)  // the property holding the needed values

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGTESTMODEDATA, // the cca-function-id
                     midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus, //the fi-type of the response (status)
                     fc_sxm_tclDiagProperties::instance()->oTestModeData)  // the property holding the needed values

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SXMDIAGSIGNALQUALITY, // the cca-function-id
                     midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus, //the fi-type of the response (status)
                     fc_sxm_tclDiagProperties::instance()->oSignalQuality)  // the property holding the needed values

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SXMDIAGANTENNASTATE, // the cca-function-id
                     midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus, //the fi-type of the response (status)
                     fc_sxm_tclDiagProperties::instance()->oAntennaState)  // the property holding the needed values

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SXMRADIOID, // the cca-function-id
                     midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus, //the fi-type of the response (status)
                     fc_sxm_tclDiagProperties::instance()->oSxmRadioId)  // the property holding the needed values

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SXMSMSDBVERSIONS, // the cca-function-id
                     midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus, //the fi-type of the response (status)
                     fc_sxm_tclDiagProperties::instance()->oSxmDbVersions)  // the property holding the needed values

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SXMMODULESUBINFO, // the cca-function-id
                     midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus, //the fi-type of the response (status)
                     fc_sxm_tclDiagProperties::instance()->oSxmModuleSubInfo)  // the property holding the needed values

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_FIRMWAREDOWNLOADPROGRESS, // the cca-function-id
                     midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus, //the fi-type of the response (status)
                     fc_sxm_tclDiagProperties::instance()->oSxmDownloadProgress)  // the property holding the needed values

      SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_TWNOWSERVICESTATUS, // the cca-function-id
    		  	  	 midw_ext_sxm_audiofi_tclMsgTWNowServiceStatusStatus, //the fi-type of the response (status)
					 fc_sxm_tclAudioProperties::instance()->oTWNowServiceStatus)  // the property holding the needed values

	  SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_TWNOWBULLETINSTATUS, // the cca-function-id
			  	  	 midw_ext_sxm_audiofi_tclMsgTWNowBulletinStatusStatus, //the fi-type of the response (status)
					 fc_sxm_tclAudioProperties::instance()->oTWNowBulletinStatus)  // the property holding the needed values
					 
	  SXM_PGET_ENTRY_FIMSG( MIDW_EXT_SXM_AUDIOFI_C_U16_TUNESCANCONTENTSTATUS, // the cca-function-id
			  	  	 midw_ext_sxm_audiofi_tclMsgTuneScanContentStatusStatus, //the fi-type of the response (status)
					 fc_sxm_tclAudioProperties::instance()->oTuneScanContentStatus)  // the property holding the needed values

	  SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_FAVORITECONTENTALERTINFO,  // the cca-function-id
	                 midw_ext_sxm_audiofi_tclMsgFavoriteContentAlertInfoStatus,//the fi-type of the response (status)
	                 fc_sxm_tclAudioProperties::instance()->oAlertInfo)// the property holding the needed values

     SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_ALERTNOTICELISTUPDATE,  // the cca-function-id
                     midw_ext_sxm_audiofi_tclMsgAlertNoticeListUpdateStatus,//the fi-type of the response (status)
                     fc_sxm_tclAudioProperties::instance()->oAlertNoticListUpdate)// the property holding the needed values

	  SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASH_SERVICESTATUS,  // the cca-function-id
			  	  	 midw_ext_sxm_audiofi_tclMsgSportsFlash_ServiceStatusStatus,//the fi-type of the response (status)
					 fc_sxm_tclAudioProperties::instance()->oSportsFlashServiceStatus)// the property holding the needed values

	  SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASH_GAMEEVENTNOTIFICATION,  // the cca-function-id
			  	  	 midw_ext_sxm_audiofi_tclMsgSportsFlash_GameEventNotificationStatus,//the fi-type of the response (status)
					 fc_sxm_tclAudioProperties::instance()->oSportsFlashGameEvent)// the property holding the needed values

	  SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASH_FLASHEVENTNOTIFICATION,  // the cca-function-id
			  	  	 midw_ext_sxm_audiofi_tclMsgSportsFlash_FlashEventNotificationStatus,//the fi-type of the response (status)
					 fc_sxm_tclAudioProperties::instance()->oSportsFlashFlashEvent)// the property holding the needed values

	  SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_TWNOWPLAYBACKSTATUS,  // the cca-function-id
			  	  	 midw_ext_sxm_audiofi_tclMsgTWNowPlaybackStatusStatus,//the fi-type of the response (status)
					 fc_sxm_tclAudioProperties::instance()->oTWNowPlaybackStatus)// the property holding the needed values

	  SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASH_PLAYBACKSTATUS,  // the cca-function-id
			  	  	 midw_ext_sxm_audiofi_tclMsgSportsFlash_PlaybackStatusStatus,//the fi-type of the response (status)
					 fc_sxm_tclAudioProperties::instance()->oSportsFlashPlaybackStatus)// the property holding the needed values

	  SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_RAPIDCHANNELBROWSEINFO,  // the cca-function-id
			  	  	 midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseInfoStatus,//the fi-type of the response (status)
					 fc_sxm_tclAudioProperties::instance()->oRapidChannelBrowseInfo)// the property holding the needed values

	  SXM_PGET_ENTRY_FIMSG(MIDW_EXT_SXM_AUDIOFI_C_U16_SETCLOCKPARAMS,// the cca-function-id
			  	  	midw_ext_sxm_audiofi_tclMsgSetClockParamsStatus,//the fi-type of the response (status)
				    fc_sxm_tclAudioProperties::instance()->oClockParmsUpdate)// the property holding the needed values

      default:
          break;
  } 
   

  if (FALSE == bResult)
  {
    ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.",
                   u16FunctionId));
    //    NORMAL_M_ASSERT_ALWAYS();
  }

  return bResult;
}

/*
  handle method-start message poMessage for function-id u16FunctionId
*/
tVoid fc_sxm_tclAudioService::vOnMethodStart(tU16 u16FunctionId, amt_tclServiceData* poMessage) 
{
    ETG_TRACE_USR4(("fc_sxm_tclAudioService::vOnMethodStart. u16FunctionId=%d",
                    u16FunctionId));


    switch (u16FunctionId) 
    {
        /* Channel list */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_GETCHANNELLIST,
                         midw_ext_sxm_audiofi_tclMsgGetChannelListMethodStart,
                         fc_sxm_trMsgAudioMStartGetChnList);

        /* Channel select */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SELECTCHANNEL,
                         midw_ext_sxm_audiofi_tclMsgSelectChannelMethodStart, 
                         fc_sxm_trMsgAudioMStartSelChn);

        /* Channel select with dwell time */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SELECTCHANNELWITHDWELLTIME,
                         midw_ext_sxm_audiofi_tclMsgSelectChannelWithDwellTimeMethodStart,
                         fc_sxm_trMsgAudioMStartSelChnWitDwellTime);

        /* Category list */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_GETCATEGORYLIST,
                         midw_ext_sxm_audiofi_tclMsgGetCategoryListMethodStart,
                         fc_sxm_trMsgAudioMStartGetCatList);

        /* Recall preset */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_RECALLPRESET,
                         midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart,
                         fc_sxm_trMsgAudioMStartRecallPreset);

        /* Store Preset */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_STOREPRESET,
                         midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart,
                         fc_sxm_trMsgAudioMStartStorePreset);

        /* Set auto compare parameters */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SETAUTOCOMPAREPARAMETERS,
                         midw_ext_sxm_audiofi_tclMsgSetAutoCompareParametersMethodStart,
                         fc_sxm_trMsgAudioMStartSetAutoCompare);

        /* Set destination position */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SETDESTINATIONPOSITION,
                         midw_ext_sxm_audiofi_tclMsgSetDestinationPositionMethodStart,
                         fc_sxm_trMsgAudioMStartSetDestinationPostion);

        /* enable or disable sending of test-mode data */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGTESTMODEENABLE,
                         midw_ext_sxm_audiofi_tclMsgDiagTestModeEnableMethodStart,
                         fc_sxm_trMsgDiagMStartTestModeEnable);

        /* enable the collection of UPC values */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGUPCVALUES,
                         midw_ext_sxm_audiofi_tclMsgDiagUpcValuesMethodStart,
                         fc_sxm_trMsgDiagMFetchUpcValue);

          /* enable the reset of Data service data bases */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGSXMRESET,
                         midw_ext_sxm_audiofi_tclMsgDiagSxmResetMethodStart,
                         fc_sxm_trMsgDiagRestoreSmsDb);

          /* Start the X65 firmware update */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_FIRMWAREDOWNLOAD,
                         midw_ext_sxm_audiofi_tclMsgFirmwareDownloadMethodStart,
                         fc_sxm_trMsgDiagDownloadMStart);

         /* Start or stop the External diagnosis mode */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_EXTERNALDIAGNOSISMODE,
                         midw_ext_sxm_audiofi_tclMsgExternalDiagnosisModeMethodStart,
                         fc_sxm_trMsgDiagExtMode);      

        /* Audio Playback Control */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_INSTANTREPLAYCONTROL,
                         midw_ext_sxm_audiofi_tclMsgInstantReplayControlMethodStart,
                         fc_sxm_trMsgAudioMStartIRPlaybackControl);

        /* Tune start Control */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_ENABLETUNESTART,
                         midw_ext_sxm_audiofi_tclMsgEnableTuneStartMethodStart,
                         fc_sxm_trMsgAudioMStartTuneStart);

        /* Smart favorite list control */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SMARTFAVORITELISTCONTROL,
                         midw_ext_sxm_audiofi_tclMsgSmartFavoriteListControlMethodStart,
                         fc_sxm_trMsgAudioMStartSFListControl);

        /* Set current volume */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SETCURRENTVOLUME,
                         midw_ext_sxm_audiofi_tclMsgSetCurrentVolumeMethodStart,
                         fc_sxm_trMsgAudioMStartCurrentVolume);

        /* Get Preset List */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_GETPRESETLIST,
		 				 midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart,
						 fc_sxm_trMsgAudioMStartGetPresetList);

        /* Disable Mature Channels */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_DISABLEMATURECHANNELS,
						 midw_ext_sxm_audiofi_tclMsgDisableMatureChannelsMethodStart,
						 fc_sxm_trMsgAudioMStartDisableMatureChannels);

        /* Skip Channel */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SKIPCHANNEL,
				  		 midw_ext_sxm_audiofi_tclMsgSkipChannelMethodStart,
						 fc_sxm_trMsgAudioMStartSkipChannels);
				
		/* Tune Scan Control */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_TUNESCANCONTROL,
						 midw_ext_sxm_audiofi_tclMsgTuneScanControlMethodStart,
				 		 fc_sxm_trMsgAudioMStartTuneScanControl);

        /* Save Favorite */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SAVEFAVORITE,
                         midw_ext_sxm_audiofi_tclMsgSaveFavoriteMethodStart,
                         fc_sxm_trMsgAudioMStartSaveFavorite);

        /* Get Favorite List */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_GETFAVORITELIST,
                         midw_ext_sxm_audiofi_tclMsgGetFavoriteListMethodStart,
                         fc_sxm_trMsgAudioMStartGetFavoriteList);

        /* Modify Favorite */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_MODIFYFAVORITE,
                         midw_ext_sxm_audiofi_tclMsgModifyFavoriteMethodStart,
                         fc_sxm_trMsgAudioMStartModifyFavorite);

        /* Get Alert Notification List */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_GETALERTNOTICELIST,
                         midw_ext_sxm_audiofi_tclMsgGetAlertNoticeListMethodStart,
                         fc_sxm_trMsgAudioMStartGetAlertNoticeList);
						 
		/* TWNow SetMarket */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_TWNOWSETMARKET,
        				 midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart,
        				 fc_sxm_trMsgAudioMStartTWNowSetMarket);

		/* TWNow GetActive Market */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_TWNOWGETACTIVEMARKET,
        				 midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart,
        		  	     fc_sxm_trMsgAudioMStartTWNowGetActiveMarket);

		/* TWNow Bulletin Playback */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_TWNOWBULLETINPLAYBACK,
        				 midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart,
        				 fc_sxm_trMsgAudioMStartTWNowBulletinPlayback);

		/* TWNow GetBulletinID */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_TWNOWGETBULLETINID,
        				 midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart,
        				 fc_sxm_trMsgAudioMStartTWNowGetBulletinID);

		/* TWNow GetAvailableMarkets */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_TWNOWGETAVAILABLEMARKETS,
        		 		 midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart,
        				 fc_sxm_trMsgAudioMStartTWNowGetAvailableMarkets);

		/* TWNow Enable */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_TWNOWENABLE,
        				 midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart,
        				 fc_sxm_trMsgAudioMStartTWNowEnable);						 

        /* SportsFlash Enable */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHENABLENOTIFICATION,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashEnableNotification);

        /* SportsFlash Add Favorite Team */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHADDFAVORITETEAM,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashAddFavoriteTeam);

        /* SportsFlash Remove Favorite  */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHREMOVEFAVORITETEAM,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashRemoveFavoriteTeam);

        /* SportsFlash Remove All Favorites */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHREMOVEALLFAVORITETEAMS,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashRemoveAllFavoriteTeams);

        /* SportsFlash Get All Favorite Teams */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHGETALLFAVORITES,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashGetAllFavorites);

        /* SportsFlash Get Current Games involving favorite teams*/
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHGETCURRENTGAMES,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashGetCurrentGames);

        /* SportsFlash Set games Monitor */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHSETGAMESMONITOR,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashSetGamesMonitor);

        /* SportsFlash Get current flash events */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHGETCURRENTFLASHEVENTS,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashGetCurrentFlashEvents);

        /* SportsFlash PLAY FLASH EVENT */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHPLAYFLASHEVENT,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashPlayFlashEvent);

        /* SportsFlash Abort Flash Event */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHABORTFLASHEVENT,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashAbortFlashEvent);

        /* SportsFlash Get Current playing event's flash ID */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHGETCURRENTFLASHEVENTID,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashGetCurrentFlashEventID);

        /* SportsFlash Get Flash Enabled Leagues */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHENABLEDLEAGUES,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashEnabledLeagues);

        /* SportsFlash Get Teams from a League */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHGETTEAMS,
        		midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart,
        		fc_sxm_trMsgAudioMStartSportsFlashGetTeams);

        /* SportsFlash Monitor Team */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SPORTSFLASHMONITORTEAMS,
				midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart,
				fc_sxm_trMsgAudioMStartSportsFlashMonitorTeam);
				        /* Get Channel info list */
        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_GETCHANNELINFO,
        		midw_ext_sxm_audiofi_tclMsgGetChannelInfoMethodStart,
        		fc_sxm_trMsgAudioMStartGetChnInfo);

        SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SETDEVICEPOSITION,
        		midw_ext_sxm_audiofi_tclMsgSetDevicePositionMethodStart,
        		fc_sxm_trMsgAudioMStartSetDevicePostion);

        /* Set Category Monitor */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SETCATEGORYMONITOR,
				midw_ext_sxm_audiofi_tclMsgSetCategoryMonitorMethodStart,
				fc_sxm_trMsgAudioMStartSetCategoryMonitor);

		/* RapidChannelBrowseStart */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_RAPIDCHANNELBROWSESTART,
				midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStartMethodStart,
				fc_sxm_trMsgAudioMStartRapidChannelBrowseStart);

		/* RapidChannelBrowseStop */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_RAPIDCHANNELBROWSESTOP,
				midw_ext_sxm_audiofi_tclMsgRapidChannelBrowseStopMethodStart,
				fc_sxm_trMsgAudioMStartRapidChannelBrowseStop);

		/* ResetSxmModule */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_RESETSXMMODULE,
				midw_ext_sxm_audiofi_tclMsgResetSXMModuleMethodStart,
				fc_sxm_trMsgAudioMStartResetSxmModule);

		/* User profile actions */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_USERPROFILE,
				midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart,
				fc_sxm_trMsgAudioMStartUserProfile);

		/* Get preset configuration */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_GETPRESETSCONFIG,
				midw_ext_sxm_audiofi_tclMsgGetPresetsConfigMethodStart,
				fc_sxm_trMsgAudioMStartGetPresetsConfig);

		/* Set preset list */
		SXM_MSTART_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SETPRESETLIST,
				midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart,
				fc_sxm_trMsgAudioMStartSetPresetList);

        /* Unknown messages */
        default:
        {
            vOnUnknownMessage(poMessage);
            break;   
        }
    }
}

/*******************************************************************************
*
* FUNCTION: tBool fc_sxm_tclAudioService
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has 
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Property successfully set to the passed value. The CCA
*                     framework sends a 'STATUS' message to the requesting
*                     client if the opcode was 'SET'. Othwerwise if opcode
*                     was 'PURESET' there is no 'STATUS' message sent to the
*                     requesting client. The CCA framework will send a 'STATUS'
*                     message to other registered clients as well if the [OUT]
*                     parameter 'bPropertyChanged' is set to TRUE.
*             FALSE = Failed to set the property to the passed value. The CCA
*                     framework sends an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
/*
  not used, please try to avoid opcode "Set"
*/
tBool fc_sxm_tclAudioService
      ::bProcessSet(amt_tclServiceData* poMessage,
                    tBool& bPropertyChanged,
                    tU16& u16ErrorCode)
{
  (tVoid) bPropertyChanged; // This line is added to avoid LINT warnings.
                            // Please remove as soon as the variable is used.
  tBool bResult = FALSE;  // This line is removed to avoid LINT warnings.

  tU16 u16FunctionId = poMessage->u16GetFunctionID();

  ETG_TRACE_USR4(("bProcessSet() entered. FID = 0x%4x.", u16FunctionId));

  switch(u16FunctionId)
  {
     SXM_PSET_ENTRY(MIDW_EXT_SXM_AUDIOFI_C_U16_SETCLOCKPARAMS, // the cca function-id
             midw_ext_sxm_audiofi_tclMsgSetClockParamsSet, // the corresponding fi-type
             fc_sxm_trMsgAudioPropSetClockParams );  // the message that shall be sent to app
  default:
      break;
  }

  if (FALSE == bResult)
  {
     u16ErrorCode = CCA_C_U16_ERROR_UNKNOWN_FCT_ID;

     ETG_TRACE_ERR(("bProcessSet(). Setting of property with 'FID = %u' failed.",
                  u16FunctionId));

     NORMAL_M_ASSERT_ALWAYS();
  }

  return bResult;
}


/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_tclAudioService::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the vOnTimer() function of this
*              CCA application on the expiration of a previously via function
*              bStartTimer() started timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
*******************************************************************************/
/*
  not used: timers should only be used in worker-context
*/
tVoid fc_sxm_tclAudioService::vProcessTimer(tU16 u16TimerId)
{
  ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));

  gm_tclU32Message oExampleMsg(_poMainAppl->u16GetAppId(),  // Source AppID 
                               _poMainAppl->u16GetAppId(),  // Target AppID 
                               0,                           // RegisterID   
                               0,                           // CmdCounter  
                               _u16ServiceID,               // ServiceID   
                               SXM_AUDIO_C_U16_IFID_EXAMPLE_1,  // Function ID
                               AMT_C_U8_CCAMSG_OPCODE_STATUS  // Opcode
                              );

  oExampleMsg.vSetDWord(SXM_AUDIO_C_U32_MSGID_EXAMPLE_1);  

  if ( oExampleMsg.bIsValid() )
  {
    if (_poMainAppl->enPostMessage(&oExampleMsg, TRUE) != AIL_EN_N_NO_ERROR)
    {  
      NORMAL_M_ASSERT_ALWAYS();
    }
  }
  else
  {  
    NORMAL_M_ASSERT_ALWAYS();
  }
}



