/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_diaglibhandler.h
* @brief       Demo Server diagnosis handler using the new diagnosis
*              library.
*              In order to use diaglib to provide diagnostic services, include a
*              diaghandler object like this one in your component. Adjust it to your
*              needs and create an instance of it in your main application. This class
*              does not use traces by purpose in order not to pollute the important
*              information for the diaglib-use. Look at the other parts of this
*              demoserver to get an idea of the general concept of application, CCA-
*              communication and trace functionality. This part concentrates on the
*              diaglib.
*              Parts that need modification by you are marked by special comments.
*              depending on the file.
*              - ccademo_diaghandler.x              => // +++ Comment +++
*              - ccademo_IncreaseDecreaseHandler.x  => // +++ Comment +++
*              - ccademo_main.x                     => // +++diaglib+++ comment
*              - ccademo_msgtypes.h                 => // +++diaglib+++ comment
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef SXM_DIAGLIBHANDLER_H
#define SXM_DIAGLIBHANDLER_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

// +++ Specify what kind of diagnostic services you provide. Consult documentation for details +++
//#define DIAGLIB_INCLUDE_SYSTEM_SET
#define DIAGLIB_INCLUDE_IO_CONTROL
#include "diaglib_if.h"

// +++ Application forward declaration +++
class fc_sxm_tclApp;


// +++ Listener forward declarations +++
class fc_sxm_diagLibSysSetListener;
class fc_sxm_diagLibIoControlListener;



struct fc_sxm_trMsgDiagSmsEvtTuneState: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Cca, 1);
    TUNE_STATE_ENUM eTuneState;
};

struct fc_sxm_trMsgDiagDownloadResult: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Cca, 1);
    fc_sxm_trMsgDiagDownloadResult(fc_sxm_tenDiagResult enResult_=fc_sxm_enDiagResult_Ok):
        enResult(enResult_)
    {}
    fc_sxm_tenDiagResult enResult;
};

struct fc_sxm_trMsgDiagDefSetResult: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Cca, 1);

    fc_sxm_trMsgDiagDefSetResult(fc_sxm_tenDiagResult enResult=fc_sxm_enDiagResult_Ok):
                      enDiagResult(enResult)
    {}

    fc_sxm_tenDiagResult enDiagResult;
};

/**
* Message are received by implementing ListenerInterfaces and registering 
* them with diagnosis library. This demo shows two ways to achieve this.
* SystemSets are handled in this class. For RoutineControl we create an
* extra classe that handles requests for two different routines.
*/
// +++ Adjust class prefix according to your component +++
class fc_sxm_diagLibHandler:
    public fc_sxm_tclSingleton <fc_sxm_diagLibHandler>
{
public:
    fc_sxm_diagLibHandler();

    virtual tVoid vInit();

    virtual ~fc_sxm_diagLibHandler();

    tVoid vProcess(fc_sxm_trMsgDiagSmsEvtTuneState const *prMsg) const;

    tVoid vProcess(fc_sxm_trMsgDiagDownloadResult const *prMsg) const;

    tVoid vProcess(fc_sxm_trMsgDiagDefSetResult const *prMsg) const;

protected:

private:
    // Singleton class must be friend 
    friend class fc_sxm_tclSingleton<fc_sxm_diagLibHandler>;

    //forbidden
    fc_sxm_diagLibHandler(const fc_sxm_diagLibHandler& rhs); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
    fc_sxm_diagLibHandler& operator=(const fc_sxm_diagLibHandler& rhs);


    // +++ Pointer to application +++
    //fc_sxm_tclApp* m_poGWMain;

    diaglib::tclServiceDiaglib* m_poServiceDiaglib; 
    /* diaglib::tclDiagnosisIF* m_poDiagIF;
    diaglib::tclCCAServiceIF* m_poCcaIF;*/

    // +++ Interfaces you need +++
    diaglib::tclSystemSetIF* m_poSystemSetIF;
    diaglib::tclIoControlIF* m_poIoControlIF;
    diaglib::tclRoutineControlIF* m_poRoutineCtrlIF;


    // +++ Listeners you create +++
    //fc_sxm_diagLibSysSetListener*  m_poSystemSetListener;
    //fc_sxm_diagLibIoControlListener*  m_poIoControlListener;

};

#endif //SXM_DIAGLIBHANDLER_H

