/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_diaglibhandler.cpp
* @brief       Demo Server diagnosis handler using the new diagnosis
*              library.
*              In order to use diaglib to provide diagnostic services, include a
*              diaghandler object like this one in your component. Adjust it to your
*              needs and create an instance of it in your main application. This class
*              does not use traces by purpose in order not to pollute the important
*              information for the diaglib-use. Look at the other parts of this
*              demoserver to get an idea of the general concept of application, CCA-
*              communication and trace functionality. This part concentrates on the
*              diaglib.
*              Parts that need modification by you are marked by special comments.
*              depending on the file.
*              - ccademo_diaghandler.x              => // +++ Comment +++
*              - ccademo_IncreaseDecreaseHandler.x  => // +++ Comment +++
*              - ccademo_main.x                     => // +++diaglib+++ comment
*              - ccademo_msgtypes.h                 => // +++diaglib+++ comment
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------

// +++ Look at the diaglib header file Version.h and
// change the major number here to the one given there +++
//#define SXM_U8_EXPECTED_DIAGLIB_MAJOR 1

#include "fc_sxm_main.h"

#include "fc_sxm_tcl_diag_defset.h"
#include "fc_sxm_diaglibhandler.h"
#include "fc_sxm_diaglib_sysset_listener.h"
#include "fc_sxm_diaglib_iocontrollistener.h"
#include "fc_sxm_diaglib_routine_control.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_DIAGHANDLER 
#include "trcGenProj/Header/fc_sxm_diaglibhandler.cpp.trc.h"
#endif


#ifndef SYSSETID_TUNE_SXM
// todo remove, when updated dianosis is released

//#pragma message ("SYSSETID_TUNE_SXM undefined, defaulting to 64.")

// todo: get value from diagnosis
//#define SYSSETID_TUNE_SXM 64
#endif

//#define FC_SXMTUNER_SYSTEMSET_ID    SYSSETID_TUNE_SXM
//#define FC_SXMTUNER_IOCONTROL_ID    15

/*************************************************************************
*
* FUNCTION: Constructor
* 
* DESCRIPTION: Init Members and setup connection with diaglib
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*************************************************************************/
fc_sxm_diagLibHandler::fc_sxm_diagLibHandler():
m_poServiceDiaglib(OSAL_NULL),m_poSystemSetIF(OSAL_NULL),
m_poIoControlIF(OSAL_NULL),m_poRoutineCtrlIF(OSAL_NULL)
{
    ETG_TRACE_USR1(("fc_sxm_diagLibHandler::fc_sxm_diagLibHandler"));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_diagLibHandler::vInit
*(
*  tVoid
*) 
*
* DESCRIPTION: This method is used for initialising the Diaglib parameters
*
* PARAMETER: NONE
*
* RETURNVALUE:NONE
*
*******************************************************************************/
tVoid fc_sxm_diagLibHandler::vInit() 
{
    m_poServiceDiaglib = OSAL_NEW diaglib::tclServiceDiaglib(fc_sxm_tclApp::instance(), 0x01);

    if (OSAL_NULL != m_poServiceDiaglib) 
    {
        ETG_TRACE_USR4(("MAIN :: DiagLib interface started!"));

        /*IO CONTROL*/           

        // +++ Get IOCtrl Interface
        m_poIoControlIF = m_poServiceDiaglib->poGetIoCtrl();

        // +++ Create your listener objects here +++
        //m_poIoControlListener = OSAL_NEW fc_sxm_diagLibIoControlListener(m_poIoControlIF, fc_sxm_tclApp::instance());
        fc_sxm_diagLibIoControlListener::instance() -> vInit(m_poIoControlIF);

        // +++ Register your listeners here +++

        m_poIoControlIF->vRegisterListener(IOCONTROLID_SXM_AUDIOTEST,fc_sxm_diagLibIoControlListener::instance());


        // Routine control =========================================================

        // +++ Get SysSet Interface
        m_poRoutineCtrlIF = m_poServiceDiaglib->poGetRoutineCtrl();

        // +++ Create your listener objects here +++
        //m_poSystemSetListener = OSAL_NEW vd_dimming_tclDiagSystemSetListener(m_poSystemSetIF, this);
        fc_sxm_diagLibRoutineControl::instance() -> vInit(m_poRoutineCtrlIF);

        // +++ Register your listeners here +++            
        m_poRoutineCtrlIF->vRegisterListener( ROUTINECONTROLID_SXM_DEFSET, fc_sxm_diagLibRoutineControl::instance() );

        // SYSTEM SET =========================================================

        // +++ Get SysSet Interface
        m_poSystemSetIF = m_poServiceDiaglib->poGetSysSet();

        // +++ Create your listener objects here +++
        //m_poSystemSetListener = OSAL_NEW vd_dimming_tclDiagSystemSetListener(m_poSystemSetIF, this);
        fc_sxm_diagLibSysSetListener::instance() -> vInit(m_poSystemSetIF);

        // +++ Register your listeners here +++            
        m_poSystemSetIF->vRegisterListener( SYSSETID_FC_SXM, fc_sxm_diagLibSysSetListener::instance() );

    }
    else
    {
        ETG_TRACE_ERR(("OSAL_NULL ==m_poServiceDiaglib"));
    } 
}

/*************************************************************************
*
* FUNCTION:tVoid Destructor
* 
* DESCRIPTION: make sure we are unregistered
*
* PARAMETER:  void
*
* RETURNVALUE: void
*
*************************************************************************/
fc_sxm_diagLibHandler::~fc_sxm_diagLibHandler()
{
    ETG_TRACE_USR1(("fc_sxm_diagLibHandler::~fc_sxm_diagLibHandler"));

    // +++diaglib+++ Delete Diag handler
    if (OSAL_NULL != m_poServiceDiaglib) 
    {
        OSAL_DELETE m_poServiceDiaglib;
        m_poServiceDiaglib = NULL;
    }  

    m_poIoControlIF = OSAL_NULL;

    m_poRoutineCtrlIF = OSAL_NULL;

    m_poSystemSetIF = OSAL_NULL;

    OSAL_DELETE fc_sxm_diagLibIoControlListener::instance();

    OSAL_DELETE fc_sxm_diagLibRoutineControl::instance();

    OSAL_DELETE fc_sxm_diagLibSysSetListener::instance();
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_diagLibHandler::vProcess
(
 fc_sxm_trMsgDiagSmsEvtTuneState const *prMsg
 ) const
*
* DESCRIPTION: This method is used to handle the tune state event process
*
* PARAMETER: prMsg : The pointer to the populated message
*
* RETURNVALUE: tVoid 
*
*******************************************************************************/
tVoid fc_sxm_diagLibHandler::vProcess
(
 fc_sxm_trMsgDiagSmsEvtTuneState const *prMsg
 ) const
{
    fc_sxm_diagLibIoControlListener::instance()->vProcess(prMsg);
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_diagLibHandler::vProcess
(
 fc_sxm_trMsgDiagDownloadResult const *prMsg
 ) const
*
* DESCRIPTION: This method is used to handle the download result process
*
* PARAMETER: prMsg : The pointer to the populated message
*
* RETURNVALUE: tVoid 
*
*******************************************************************************/
tVoid fc_sxm_diagLibHandler::vProcess
(
 fc_sxm_trMsgDiagDownloadResult const *prMsg
 ) const 
{
    fc_sxm_diagLibIoControlListener::instance()->vProcess(prMsg);    
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_diagLibHandler::vProcess
(
 fc_sxm_trMsgDiagDefSetResult const *prMsg
 ) const
*
* DESCRIPTION: This method is used to handle the result of Defset
*
* PARAMETER: prMsg : The pointer to the populated message
*
* RETURNVALUE: tVoid 
*
*******************************************************************************/
tVoid fc_sxm_diagLibHandler::vProcess
(
 fc_sxm_trMsgDiagDefSetResult const *prMsg
 ) const
{
    fc_sxm_diagLibSysSetListener::instance()->vProcess(prMsg);
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_sxm_diagLibHandler::vDispatchMsgFromQ
*(
*  fc_sxm_tclMessage const *poThreadMsg
*) const
*
* DESCRIPTION: This is the dispatch method for Diagnosis.All diagnosis message 
*              exchange happens through this dispatch message.All the diagnosis 
*              related messages will be delegated to this dispatch function by 
*              audio diapatch function
*
* PARAMETER: poThreadMsg : The pointer to the populated message
*
* RETURNVALUE: tVoid - True : If action found
*                      False:If action not found
*
*******************************************************************************/
//tVoid fc_sxm_diagLibHandler::vDispatchMsgFromQ
//(
// fc_sxm_tclMessage const *poThreadMsg
// ) 
//{
//    ETG_TRACE_USR4(("fc_sxm_diagLibHandler::vDispatchMsgFromQ: SID=%x action=%d",
//        ETG_CENUM(fc_sxm_tenServiceID, poThreadMsg->enGetServiceId()), 
//        poThreadMsg->u16GetActionOnly()));
//
//    tU32 u32Action=poThreadMsg->u32GetAction();
//    switch (u32Action) {
//        // use macro SXM_MSGQ_DISPATCH  for each message specific for fc_sxm_diagLibHandler
//        /* next line to call vProcess(fc_sxm_trMsgAudioSmsEvtSrmState *) */        
//        //SXM_MSGQ_DISPATCH_TO_OBJ(fc_sxm_trMsgAudioSmsEvtTuneState, fc_sxm_diagLibIoControlListener::instance());
//
//        default:
//            /* forward to diag */
//            ETG_TRACE_ERR(("fc_sxm_diagLibHandler::vDispatchMsgFromQ(): unknown u32Action=0x%x",
//                poThreadMsg->u32GetAction()));
//            break;         
//    }
//}


//tVoid fc_sxm_diagLibHandler::vProcess(DAB::trMsgSrvRspDefSet *poSrvRspDefSet) {
//    if (m_poSystemSetListener==OSAL_NULL) {
//        return;
//    }
//    m_poSystemSetListener->vOnSysSetResult(poSrvRspDefSet);
//}
//
//tVoid fc_sxm_diagLibHandler::vProcess(DAB::trMsgSrvRspTestOperation *poSrvRspTestOperation) {
//    if (m_poIoControlListener==OSAL_NULL) {
//        return;
//    }
//    m_poIoControlListener->vOnIoControlResult(poSrvRspTestOperation);
//}


