/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_diaglib_sysset_listener.cpp
* @brief       Definition of diagnosis system set default listener
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#include "fc_sxm_tcl_diag_defset.h"
#include "fc_sxm_diaglibhandler.h"
#include "fc_sxm_diaglib_sysset_listener.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_DIAGHANDLER 
#include "trcGenProj/Header/fc_sxm_diaglib_sysset_listener.cpp.trc.h"
#endif

/*************************************************************************
*
* FUNCTION: Constructor
* 
* DESCRIPTION: Init Members and setup connection with diaglib
*
* PARAMETER: NONE
*
* RETURNVALUE: NONE
*
*************************************************************************/
fc_sxm_diagLibSysSetListener::fc_sxm_diagLibSysSetListener() :
m_poSystemSetIF(OSAL_NULL),
m_MsgContext(0)
//m_bSysSetRunning(FALSE)
{
   ETG_TRACE_USR4(("fc_sxm_diagLibSysSetListener:fc_sxm_diagLibSysSetListener"));

}

/*************************************************************************
*
* FUNCTION:tVoid Destructor
* 
* DESCRIPTION: make sure we are unregistered
*
* PARAMETER:  void
*
* RETURNVALUE: void
*
*************************************************************************/
fc_sxm_diagLibSysSetListener::~fc_sxm_diagLibSysSetListener
()
{
   ETG_TRACE_USR4(("fc_sxm_diagLibSysSetListener:~fc_sxm_diagLibSysSetListener"));
   m_poSystemSetIF = OSAL_NULL;
   m_MsgContext = 0;
   //m_bSysSetRunning = FALSE;
}

/*************************************************************************
*
* FUNCTION:tVoid fc_sxm_diagLibSysSetListener::vInit
*(
* diaglib::tclSystemSetIF* poSystemSetIF
* )
* 
* DESCRIPTION: //method to initialise the IO control listener
*
* PARAMETER:  diaglib::tclIoControlIF* pIoControlIF,
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid fc_sxm_diagLibSysSetListener::vInit
(
 diaglib::tclSystemSetIF* poSystemSetIF
 )
{
   ETG_TRACE_USR4(("fc_sxm_diagLibSysSetListener:vInit"));

   m_poSystemSetIF = poSystemSetIF;
}


/*************************************************************************
*
* FUNCTION: tU32 fc_sxm_diagLibSysSetListener::vOnSystemSet
*(
*    tU32 u32SystemSetID, 
*    diaglib::tenSystemSetType u32SystemSetType,
*    diaglib::tContext MsgContext
*)
* 
* DESCRIPTION: System set trigger
*
* PARAMETER: u32SystemSetID, 
*            tenSystemSetType u32SystemSetType,
*            diaglib::tContext MsgContext
*
* RETURNVALUE: tU32
*
*************************************************************************/
tU32 fc_sxm_diagLibSysSetListener::vOnSystemSet
(
 tU32 u32SystemSetID, 
 diaglib::tenSystemSetType u32SystemSetType,
 diaglib::tContext MsgContext
 )
{
   tU32 u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;

   ETG_TRACE_ERR(("fc_sxm_diagLibSysSetListener:vOnSystemSet: u32SystemSetID=%u u32SystemSetType=%u",
      u32SystemSetID, u32SystemSetType));

   SXM_ASSERT_RETURN_VAL(OSAL_NULL != m_poSystemSetIF, u32RetValue); 

   m_MsgContext=MsgContext;

   fc_sxm_tenDiagDefsetType enDefsetType=fc_sxm_enDiagDefsetType_Invalid;
   fc_sxm_tenDefsetState enState = fc_sxm_en_Defset_Idle;

   if (diaglib::EN_TYPE_DEFAULT_HMI == u32SystemSetType) 
   {
      enDefsetType=fc_sxm_enDiagDefsetType_User; 
   }
   else if (diaglib::EN_TYPE_DEFAULT_TEF == u32SystemSetType)
   {
      enDefsetType=fc_sxm_enDiagDefsetType_Factory; 
      enState = fc_sxm_en_Defset_Pending;
   }

   fc_sxm_trMsgDiagDefset rMsg(enDefsetType,enState);
   fc_sxm_tclAudioApp::instance()->vPostMsgNew(rMsg);


   ETG_TRACE_USR4(("fc_sxm_diagLibSysSetListener:vOnSystemSet: u32RetValue=%u", u32RetValue));

   return u32RetValue;
}



/*************************************************************************
*
* FUNCTION: tU32 fc_sxm_diagLibSysSetListener::vSendResult
*(
*  tU8 u8Result
*)
* 
* DESCRIPTION: System set result
*
* PARAMETER: tU8 u8Result
*
* RETURNVALUE: NONE
*
*************************************************************************/
tVoid fc_sxm_diagLibSysSetListener::vSendResult(fc_sxm_tenDiagResult enResult) 
{
   diaglib::tenSystemSetResult enSysSetResult = diaglib::EN_SYSTEMSET_NOT_OK;

   if (fc_sxm_enDiagResult_Ok == enResult) 
   {
      enSysSetResult = diaglib::EN_SYSTEMSET_OK;
   }
   ETG_TRACE_USR4(("fc_sxm_diagLibSysSetListener::vOnDefsetResult:enResult=%d",
      ETG_CENUM(fc_sxm_tenDiagResult, enResult)));
   // send result to diaglib
   diaglib::tclParameterVector oErrorList;

   if(OSAL_NULL != m_poSystemSetIF)
   {
      if ( !m_poSystemSetIF->bSendSystemSetResult( enSysSetResult,
         oErrorList,
         m_MsgContext) )
      {
         ETG_TRACE_USR2(("fc_sxm_diagLibSysSetListener:vSendResult: could not bSendSystemSetResult"));
      }
   }
   else
   {
      ETG_TRACE_USR2(("fc_sxm_diagLibSysSetListener:vSendResult:Result not send m_poSystemSetIF=0"));
   }
}


/*************************************************************************
*
* FUNCTION: tU32 fc_sxm_diagLibSysSetListener::vOnSystemSetFinished
*(
*   tU32 u32SystemSetID, 
*   diaglib::tenSystemSetType u32SystemSetType,
*   diaglib::tContext MsgContext
*)
*
* DESCRIPTION: System set finished trigger
*
* PARAMETER: poSrvRspDefSet
*
* RETURNVALUE: NONE
*
*************************************************************************/
tU32 fc_sxm_diagLibSysSetListener::vOnSystemSetFinished
(
 tU32 u32SystemSetID, 
 diaglib::tenSystemSetType u32SystemSetType,
 diaglib::tContext MsgContext
 )
{
    ETG_TRACE_USR4(("fc_sxm_diagLibSysSetListener:vOnSystemSetFinished: u32SystemSetID=%u u32SystemSetType=%u",
      u32SystemSetID, u32SystemSetType));

   m_MsgContext = MsgContext;

   vSendResult(fc_sxm_enDiagResult_Ok);

   return diaglib::U32_DIAGLIB_RETURN_OK;
}

// handler method for preparing of system setting
/*************************************************************************
*
* FUNCTION: tU32 fc_sxm_diagLibSysSetListener::vOnSystemSetPrepare
*(
*   tU32 u32SystemSetID, 
*   diaglib::tenSystemSetType u32SystemSetType,
*   diaglib::tContext MsgContext
*)
*
* DESCRIPTION: System set prepare trigger
*
* PARAMETER:  tU32 u32SystemSetID, 
*             diaglib::tenSystemSetType u32SystemSetType,
*             diaglib::tContext MsgContext
*
*
* RETURNVALUE: NONE
*
*************************************************************************/
tU32 fc_sxm_diagLibSysSetListener::vOnSystemSetPrepare
(
 tU32 u32SystemSetID, 
 diaglib::tenSystemSetType u32SystemSetType,
 diaglib::tContext MsgContext
 )
{
   ETG_TRACE_USR4(("fc_sxm_diagLibSysSetListener:vOnSystemSetPrepare: u32SystemSetID=%u u32SystemSetType=%u",
      u32SystemSetID, u32SystemSetType));

   m_MsgContext = MsgContext;

   vSendResult(fc_sxm_enDiagResult_Ok);

   return diaglib::U32_DIAGLIB_RETURN_OK;
}


/*************************************************************************
*
* FUNCTION: tVoid fc_sxm_diagLibSysSetListener::vProcess
*(
* fc_sxm_trMsgDiagDefSetResult const *prMsg
* )
*
* DESCRIPTION: Function to handle the Defset result
*
* PARAMETER: fc_sxm_trMsgDiagDefSetResult const *prMsg //Defset result
*
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid fc_sxm_diagLibSysSetListener::vProcess
(
 fc_sxm_trMsgDiagDefSetResult const *prMsg
 )
{

   ETG_TRACE_USR1(("fc_sxm_diagLibSysSetListener:vProcess(fc_sxm_trMsgDiagDefSetResult) : entered"));

   if (OSAL_NULL != prMsg) 
   {
      vSendResult(prMsg->enDiagResult);
   }        

}
