/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_diaglib_iocontrollistener.h
* @brief       Declaration of diagnosis IO control  listener
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef SXM_DIAGLIBIOCONTROLLISTENER_H
#define SXM_DIAGLIBIOCONTROLLISTENER_H

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"

#define IOCONTROLID_SXM_AUDIOTEST IOCONTROLID_TUNERXM_CHANNEL
// forward definition of own application class
//lint -esym(763, fc_sxm_tclApp)  Redundant declaration for symbol
class fc_sxm_tclApp;

// class definition
class fc_sxm_diagLibIoControlListener : public diaglib::tclIoControlListenerIF, public fc_sxm_tclSingleton <fc_sxm_diagLibIoControlListener>
{
public:
    // +++ Depending on the type of listener you need the associated interface to send responses +++
    fc_sxm_diagLibIoControlListener();

    //method to initialise the IO control listener
    tVoid vInit(diaglib::tclIoControlIF* pIoControlIF);

    // default destructor
    virtual ~fc_sxm_diagLibIoControlListener();


    // handler method for system setting
    virtual tU32 vOnIoControl (
                               tU32 u32IoControlId, 
                               diaglib::tenIoControlAction enActionId, 
                               const diaglib::tclParameterVector& oParameterVector,
                               diaglib::tContext MsgContext
                              );

    // handler method for finaling of system setting

	virtual tU32 vOnIoControlFreeze (
                                     tU32 u32IoControlId,
                                     diaglib::tContext MsgContext
                                   );
	virtual tU32 vOnIoControlUnfreeze (
                                       tU32 u32IoControlId,
                                       diaglib::tContext MsgContext
                                           );

    tVoid vProcess(fc_sxm_trMsgDiagSmsEvtTuneState const *prMsg );
    tVoid vProcess(fc_sxm_trMsgDiagDownloadResult const *prMsg ) const;

private:
    // Singleton class must be friend 
    friend class fc_sxm_tclSingleton<fc_sxm_diagLibIoControlListener>;
    // copy constructor
    fc_sxm_diagLibIoControlListener(const fc_sxm_diagLibIoControlListener& rhs); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
    // assignment operator
    fc_sxm_diagLibIoControlListener& operator=(const fc_sxm_diagLibIoControlListener& rhs);

    // attribute: reference to system set interface
    diaglib::tclIoControlIF* m_IoControlIF;

    // attribute: reference of own application object
    //fc_sxm_tclApp* m_poGWMain;

    tVoid vSendResult(diaglib::tContext MsgContext, diaglib::tenIoControlAction enAction, diaglib::tenInternalError enError=diaglib::EN_ERROR_NO_ERROR);
    diaglib::tContext m_MsgContext;

    tBool m_bIoControlRunning;



};

#endif //SXM_DIAGLIBIOCONTROLLISTENER_H

