/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_clienthandler_profilemgr.h
* @brief       CCA client-handler for the Profile Manager.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef _FC_SXM_CLIENT_PROFILEMGR_H_
#define _FC_SXM_CLIENT_PROFILEMGR_H_

#ifndef FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"
#endif


#ifndef AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "fc_sxm_trace_macros.h"
#include "fc_sxm_tcl_base_client.h"
#include "fc_sxm_clienthandler_profilemgr_fi.h"
#include "fc_sxm_tcl_singleton.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class fc_sxm_tclProfileMgrClient :
   public fc_sxm_tclBaseClient,
   public fc_sxm_tclSingleton<fc_sxm_tclProfileMgrClient>
{
friend class fc_sxm_tclSingleton<fc_sxm_tclProfileMgrClient>;
public:
   virtual ~fc_sxm_tclProfileMgrClient(tVoid);

   // Overriding ahl_tclBaseOneThreadClientHandler methods
   virtual tVoid vOnServiceAvailable(tVoid);
   virtual tVoid vOnServiceUnavailable(tVoid);

   // Handler function declarations used by message map
   virtual tVoid vOnStatus(tU16, amt_tclServiceData*);
   virtual tVoid vOnMethodResult(tU16, amt_tclServiceData*);
   virtual tVoid vOnError(tU16, amt_tclServiceData*);

   tBool bAckChangeProfileStatus(const tULong bStatus);
   tBool bAckCopyProfileStatus(const tULong bStatus);
   tBool bAckDeleteProfileStatus(const tULong bStatus);

private:
   fc_sxm_tclProfileMgrClient(tVoid);
};

#endif // _FC_SXM_CLIENT_PROFILEMGR_H_
