/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_client_spm.h
* @brief       File provides Client handler for SPM.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/



#ifndef _FC_SXM_CLIENT_SPM_H_
#define _FC_SXM_CLIENT_SPM_H_

#include "fc_sxm_tcl_base_client.h"
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/


class fc_sxm_tclSpmClient : 
public fc_sxm_tclBaseClient,
    public fc_sxm_tclSingleton<fc_sxm_tclSpmClient>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclSpmClient>;

 private:
    fc_sxm_tclSpmClient(tVoid); 

  public:

    virtual ~fc_sxm_tclSpmClient();

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    tVoid vProcessTimer(tU16 u16TimerId) {(tVoid)u16TimerId;};

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/
    virtual tVoid vOnStatus(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);
    virtual tVoid vOnMethodResult(tU16 u16FID, amt_tclServiceData* pServiceDataMessage);


    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

};

#endif // _FC_SXM_CLIENTHANDLER_FC_AUDIO_H_

