/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_client_spm.cpp
* @brief       Implementation for SPM Client handler.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#include "fc_sxm_tcl_sxmapp_manager.h"
#include "fc_sxm_client_spm.h"
#include "fc_sxm_client_spm_fi.h"
#include "fc_sxm_tcl_states.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_APPLICATION
#include "trcGenProj/Header/fc_sxm_client_spm.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


/*
  constructor: call contructor of base-class accordingly
*/
#ifdef VARIANT_S_FTR_ENABLE_SPM_CORE_FI
fc_sxm_tclSpmClient::
fc_sxm_tclSpmClient()
    : fc_sxm_tclBaseClient(
                           /* ID of used Service           */ CCA_C_U16_SRV_SPM,
                           /* MajorVersion of used Service */ FC_SXM_C_U16_SERVICE_SPM_CORE_MAJOR_VERSION ,
                           /* MinorVersion of used Service */ FC_SXM_C_U16_SERVICE_SPM_CORE_MINOR_VERSION )
{
    ETG_TRACE_USR4(("fc_sxm_tclSpmClient() entered."));

    // upregs:
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_CVMEVENT); 
}

#else
fc_sxm_tclSpmClient::
fc_sxm_tclSpmClient()
    : fc_sxm_tclBaseClient(
                           /* ID of used Service           */ CCA_C_U16_SRV_SPM,
                           /* MajorVersion of used Service */ CFC_SPMFI_C_U16_SERVICE_MAJORVERSION ,
                           /* MinorVersion of used Service */ CFC_SPMFI_C_U16_SERVICE_MINORVERSION )
{
    ETG_TRACE_USR4(("fc_sxm_tclSpmClient() entered."));

    // upregs:
   vAddAutoRegisterForProperty(CFC_SPMFI_C_U16_CVMEVENT); 
}

#endif

/*
  Destructor
*/
fc_sxm_tclSpmClient::
~fc_sxm_tclSpmClient(tVoid)
{
    ETG_TRACE_USR4(("~fc_sxm_tclSpmClient() entered."));
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_sxm_tclSpmClient::vOnServiceAvailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              this client-handler has registered for has become available.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
 *******************************************************************************/
tVoid fc_sxm_tclSpmClient::vOnServiceAvailable()
{
    ETG_TRACE_USR4(("fc_sxm_tclSpmClient:vOnServiceAvailable() entered. AppID = %u.",
                    u16GetServerAppID()));
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_sxm_tclAudioClient::vOnServiceUnavailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              this client-handler has registered for has become unavailable.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
 *******************************************************************************/
tVoid fc_sxm_tclSpmClient::vOnServiceUnavailable()
{
    ETG_TRACE_USR4(("fc_sxm_tclSpmClient:vOnServiceUnavailable() entered. AppID = %u.",
                    u16GetServerAppID()));
}

/*
  Handle all received status-fi-messages.
  For each function-id of interest use the macro SXM_PSTATUS_ENTRY 
  to create the corresponding thread-message and send its app
*/

tVoid fc_sxm_tclSpmClient::vOnStatus(tU16 u16FID, amt_tclServiceData* pServiceDataMessage) {
    ETG_TRACE_USR4(("fc_sxm_tclSpmClient::vOnStatus FID=%u", u16FID));
    switch (u16FID) {
#ifdef VARIANT_S_FTR_ENABLE_SPM_CORE_FI		
        SXM_PSTATUS_ENTRY(SPM_COREFI_C_U16_CVMEVENT, 
                          spm_corefi_tclMsgCvmEventStatus, 
                          fc_sxm_trMsgAudioCvmEvent);
#else	
        SXM_PSTATUS_ENTRY(CFC_SPMFI_C_U16_CVMEVENT, 
                          cfc_spmfi_tclMsgCvmEventStatus, 
                          fc_sxm_trMsgAudioCvmEvent);
#endif		  
        default:
            vOnUnknownMessage(pServiceDataMessage);
            break;
    }
}

/*
  Handle all received method-result fi-messages.
  For each function-id of interest use the macro SXM_MRESULT_ENTRY 
  to create the corresponding thread-message and send its app
*/

tVoid fc_sxm_tclSpmClient::vOnMethodResult(tU16 u16FID, amt_tclServiceData* pServiceDataMessage) {
    ETG_TRACE_USR4(("fc_sxm_tclSpmClient::vOnMethodResult FID=%u", u16FID));
    vOnUnknownMessage(pServiceDataMessage);
}

