/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_twnow_proxy_if.h
* @brief       Interface for Traffic and Weather Now proxy class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_TWNOW_PROXY_IF_H_
#define FC_SXM_TCL_TWNOW_PROXY_IF_H_


#include "fc_sxm_types.h"
#include "fc_sxm_audio_types.h"

/*
 * messages send from cca-context from timer class to audio app
 * for advisory message timeout updates.
 */
struct fc_sxm_trMsgTWNowMarketsTimer
    : public fc_sxm_tclMessage
{
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio,
    		FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 7);
};

struct fc_sxm_trMsgTWNowEventAlert : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 8);
	TW_NOW_BULLETIN_ID u32BulletinID;
	TW_NOW_BULLETIN_STATUS_ENUM enStatus;

	fc_sxm_trMsgTWNowEventAlert(TW_NOW_BULLETIN_ID bulletinID = TW_NOW_INVALID_BULLETIN_ID, TW_NOW_BULLETIN_STATUS_ENUM enNewStatus = TW_NOW_NO_BULLETIN_AVAILABLE) :
		u32BulletinID(bulletinID), enStatus(enNewStatus)
	{ /* Default Constructor*/ }

    bool operator == (fc_sxm_trMsgTWNowEventAlert const& b) const
	{
		return ( (u32BulletinID == b.u32BulletinID) &&
				(enStatus == b.enStatus) );
	}
};

class Ifc_sxm_tclTWNowMarketReport {
public:
	virtual tVoid vGetAvailableMarkets() = 0;
	virtual ~Ifc_sxm_tclTWNowMarketReport() { /*Virtual DTOR for the interface*/ };
};

class Ifc_sxm_tclTWNow {
public:
	virtual tVoid vHandleTWNowEvent(DECODER_OBJECT, TW_NOW_BULLETIN_ID, TW_NOW_BULLETIN_STATUS_ENUM, CID_OBJECT) const = 0;
	virtual tBool bAddTWNowMarket(const char*, const char*, CID_OBJECT) = 0;

	virtual ~Ifc_sxm_tclTWNow() { /*Virtual DTOR for the interface*/ };
};

class Ifc_sxm_tclTWNowProxy {
public:
	// TWNow content report wrappers
	virtual tBool bIsTWNowReportContentComplete() const = 0;
	virtual tBool bGetTWNowMarkets (Ifc_sxm_tclTWNow*) const = 0;

	// TWNow object wrappers
	virtual SMSAPI_RETURN_CODE_ENUM enStartTWNow(DECODER_OBJECT , Ifc_sxm_tclTWNow* ) const = 0;
	virtual tVoid vStopTWNow(DECODER_OBJECT ) const = 0;
	virtual SMSAPI_RETURN_CODE_ENUM enSetTWNowMarket(DECODER_OBJECT , CID_OBJECT ) const = 0;
	virtual CID_OBJECT hGetCurrentTWNowMarket(DECODER_OBJECT ) const = 0;
	virtual SMSAPI_RETURN_CODE_ENUM enPlayTWNowBulletin(DECODER_OBJECT , tU32 ) const = 0;
	virtual SMSAPI_RETURN_CODE_ENUM enAbortTWNowBulletin(DECODER_OBJECT ) const = 0;
	virtual tU32 u32GetCurrentTWNowBulletinID(DECODER_OBJECT ) const = 0;

	//TWNow specific CID object wrappers
	virtual tVoid vDestroyCIDObject(CID_OBJECT ) const = 0;
	virtual tS16 s16CompareCIDObjects(CID_OBJECT , CID_OBJECT ) const = 0;
	virtual tVoid vStartPollingAvailableMarkets(tU32 , Ifc_sxm_tclTWNowMarketReport* ) = 0;

	virtual ~Ifc_sxm_tclTWNowProxy() { /*Virtual DTOR for the interface*/ }
};


#endif /* FC_SXM_TCL_TWNOW_PROXY_IF_H_ */
