/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_twnowproxy.h
* @brief       Interface declaration between fc_sxm app and SMS library for 
*              TWNow specific calls.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_TWNOW_PROXY_H_
#define FC_SXM_TCL_TWNOW_PROXY_H_

#include "fc_sxm_tcl_twnow_proxy_if.h"
#include "fc_sxm_tcl_timer.h"
#include "fc_sxm_tcl_audio_app.h"


class fc_sxm_tclTWNowProxy :
	public Ifc_sxm_tclTWNowProxy,
	public fc_sxm_tclSingleton<fc_sxm_tclTWNowProxy>
{
public:
    virtual ~fc_sxm_tclTWNowProxy() {  _poAvlMarkets = OSAL_NULL; }

    // Call back method for SMS
	static tBool cb_bTWNowReportIterator (const char* pacId,
			const char* pacName,
			CID_OBJECT hId,
			void* pvContentIteratorCbArg);

    // Over-ride TWNow content report wrappers
    tBool bIsTWNowReportContentComplete() const;
    tBool bGetTWNowMarkets (Ifc_sxm_tclTWNow* poTWNow) const;

    // Over-ride TWNow object wrappers
    SMSAPI_RETURN_CODE_ENUM enStartTWNow(DECODER_OBJECT hDecoder, Ifc_sxm_tclTWNow* poTWNow) const;
	tVoid vStopTWNow(DECODER_OBJECT hDecoder) const;
	SMSAPI_RETURN_CODE_ENUM enSetTWNowMarket(DECODER_OBJECT hDecoder, CID_OBJECT hMarketID) const;
	CID_OBJECT hGetCurrentTWNowMarket(DECODER_OBJECT hDecoder) const;
	SMSAPI_RETURN_CODE_ENUM enPlayTWNowBulletin(DECODER_OBJECT hDecoder, tU32 u32BulletinID) const;
	SMSAPI_RETURN_CODE_ENUM enAbortTWNowBulletin(DECODER_OBJECT hDecoder) const;
	tU32 u32GetCurrentTWNowBulletinID(DECODER_OBJECT hDecoder) const;

	// Over-ride CID object wrappers
	tVoid vDestroyCIDObject(CID_OBJECT hCID) const;
	tS16 s16CompareCIDObjects(CID_OBJECT hCID1, CID_OBJECT hCID2) const;

	// TWNow Markets timer methods
	tVoid vStartPollingAvailableMarkets(tU32 u32DelayTime, Ifc_sxm_tclTWNowMarketReport* poAvlMarkets);

	tVoid vProcessTimer(fc_sxm_trMsgTWNowMarketsTimer const * /* prMsg */ );

	static tVoid cb_TWNowEvent(DECODER_OBJECT, TW_NOW_BULLETIN_ID, TW_NOW_BULLETIN_STATUS_ENUM,
				CID_OBJECT, tVoid*);
private:
	friend class fc_sxm_tclSingleton<fc_sxm_tclTWNowProxy>;

	/* Timer to notify if TWNow markets list has been received OTA */
	fc_sxm_tclTimer<fc_sxm_tclAudioApp,
					fc_sxm_trMsgTWNowMarketsTimer,
					fc_sxm_tclTWNowProxy> _mTWNowMarketsTimer;

	Ifc_sxm_tclTWNowMarketReport* _poAvlMarkets;

	tVoid vStopPollingAvailableMarkets();
	fc_sxm_tclTWNowProxy():_poAvlMarkets(OSAL_NULL) { /*Default CTOR*/ }
};

#endif /* FC_SXM_TCL_TWNOW_PROXY_H_ */
