/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_twnow.h
* @brief       Declaration for Traffic and Weather Now service handler.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_TWNOW_H_
#define FC_SXM_TCL_TWNOW_H_

#include "fc_sxm_tcl_twnow_proxy_if.h"
#include "fc_sxm_tcl_audio_member.h"
#include "fc_sxm_audio_fi.h"

class Ifc_sxm_tclAudioApp;

struct fc_sxm_trMsgAudioMStartTWNowSetMarket : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 1);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgTWNowSetMarketMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartTWNowGetActiveMarket : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 2);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgTWNowGetActiveMarketMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartTWNowBulletinPlayback : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 3);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgTWNowBulletinPlaybackMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartTWNowGetBulletinID : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 4);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgTWNowGetBulletinIDMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartTWNowGetAvailableMarkets : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 5);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartTWNowEnable : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 6);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgTWNowEnableMethodStart oFiMsg;
};

struct fc_sxm_trTWNowMarkets {
	string sAbbrName; // abrreviated name of the market/region
	string sFullName; // full name of the market/region
	CID_OBJECT hCID; // Market ID in CID_OBJECT format;

	fc_sxm_trTWNowMarkets(string sAbbreviation = "", string sFull = "", CID_OBJECT cidObj = CID_INVALID_OBJECT) :
		sAbbrName(sAbbreviation), sFullName(sFull), hCID(cidObj) {  /* Default CTOR*/  }

	bool bValidMarket() const {
		// Method returns if the reported market is valid.
		// Since comparison with string "Unknown" is done in CLI, it is retained here.
		return ((!sFullName.empty()) &&
				(sFullName.compare("Unknown") != 0) &&
				(hCID != CID_INVALID_OBJECT));
	}

	tVoid vPrintMarketInfo () const ;
};

struct fc_sxm_trMsgAudioSmsEvtTuneState;

class fc_sxm_tclTWNow
    : public fc_sxm_tclAudioMember
    , public Ifc_sxm_tclTWNow
    , public Ifc_sxm_tclTWNowMarketReport
    , public fc_sxm_tclSingleton<fc_sxm_tclTWNow>
{
public:
    virtual ~fc_sxm_tclTWNow();
    // Start TWNow service once decoder is up and is in ready state
    virtual tVoid vUpdateDecoderState(
                DECODER_OBJECT hDecoderObject,
                DECODER_STATE_ENUM enDecoderState);

    tVoid vInit();
	tVoid vDeInit();
	//  Clear class member variables
	tVoid vClearMemberData(tVoid);

	// Set Audio App Pointer Reference
	tVoid vSetApp(Ifc_sxm_tclAudioApp* poAudioApp, Ifc_sxm_tclTWNowProxy* poTWNow);

	tVoid vHandleTWNowEvent(DECODER_OBJECT, TW_NOW_BULLETIN_ID, TW_NOW_BULLETIN_STATUS_ENUM, CID_OBJECT) const;
	tBool bAddTWNowMarket(const char*, const char*, CID_OBJECT);
	tVoid vGetAvailableMarkets();

	static tVoid fc_sxm_vString2Fi(tCString sSrcString,  midw_ext_fi_tclString& rffiObj);

	// Handle MethodStarts
	tVoid vProcess(fc_sxm_trMsgAudioMStartTWNowSetMarket const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartTWNowGetActiveMarket const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartTWNowBulletinPlayback const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartTWNowGetBulletinID const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartTWNowGetAvailableMarkets const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartTWNowEnable const *prMsg);
	tVoid vProcess(fc_sxm_trMsgTWNowEventAlert const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioSmsEvtTuneState const *);
	SMSAPI_RETURN_CODE_ENUM enAbortTWNowBulletin(tU32 u32BulletinID) const;
	tBool bIsTWNowPlaybackInProgress() const { return _bIsTWNowPlayback; }

private:
    friend class fc_sxm_tclSingleton<fc_sxm_tclTWNow>;
    fc_sxm_tclTWNow();

#ifdef UNITTEST_FC_SXM
    // For unit test product, to perform effective unit-testing of all private members,
    // the private methods/variables are made public.
    // In production-code, the methods and variables still remain private
public:
#endif //UNITTEST_FC_SXM
    // Using SMS Specific API's
    SMSAPI_RETURN_CODE_ENUM enStartTWNow(DECODER_OBJECT hDecoder);
    tVoid vStopTWNow() const;
    SMSAPI_RETURN_CODE_ENUM enSetTWNowMarket(CID_OBJECT marketID) const;
    CID_OBJECT hGetCurrentTWNowMarket() const;
    SMSAPI_RETURN_CODE_ENUM enPlayTWNowBulletin(tU32 u32BulletinID) const;
    tU32 u32GetCurrentTWNowBulletinID() const;

    tVoid vNotifyTWNowServiceState(const SMSAPI_RETURN_CODE_ENUM enRetCode, tBool bStartService = TRUE) const;
    DECODER_OBJECT hGetDecoder() const;

    tBool bGetAvailableMarkets();
    tVoid vFillMarkets(midw_ext_sxm_audiofi_tclMsgTWNowGetAvailableMarketsMethodResult& oMRes) const;
    tVoid vFillMarketListEntry(midw_ext_fi_tcl_MarketListEntry&, const fc_sxm_trTWNowMarkets&, CID_OBJECT, tBool& ) const;

    tBool bSetMarket(const string& sMarketFullName) ;
    tBool bDisableMonitoring() const;
    tVoid vPrintMarkets() const;

    tBool bGetCurrentMarketInfo(fc_sxm_trTWNowMarkets& trMarket) const;

    tVoid vSendTWNowFiMsg(fc_sxm_trAdressing const &, const midw_ext_sxm_audiofi_tclMsgBaseMessage& );
    tVoid vSendTWNowFiError(fc_sxm_trAdressing const &, tInt );

    tVoid vDestroyCIDObject(CID_OBJECT hCID) const;
    tS16 s16CompareCIDObjects(CID_OBJECT hCID1, CID_OBJECT hCID2) const;

    // Access specifier commented to avoid prio-3 lint warning as the access specifier mentioned here is redundant
//private:
    Ifc_sxm_tclAudioApp* _poAudioApp;
    Ifc_sxm_tclTWNowProxy* _poTWNowProxy;
    vector <fc_sxm_trTWNowMarkets> _vectMarkets;
    tBool _bIsTWNowInitialized;
    tBool _bEnableTWNow;
    tBool _bIsTWNowPlayback;
};

#endif /* FC_SXM_TCL_TWNOW_H_ */
