/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_flash_proxy.h
* @brief       Interface declaration between fc_sxm app and SMS library for 
*              SportsFlash specific calls.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_SPORTS_FLASH_PROXY_H_
#define FC_SXM_TCL_SPORTS_FLASH_PROXY_H_

#include "fc_sxm_tcl_sports_flash_proxy_if.h"

class fc_sxm_tclSportsFlashProxy :
	public Ifc_sxm_tclSportsFlashProxy,
	public fc_sxm_tclSingleton<fc_sxm_tclSportsFlashProxy>
{
public:
	virtual ~fc_sxm_tclSportsFlashProxy() ;

	// Set audio app's instance
	tVoid vSetDecoder(Ifc_sxm_tclDecoder* );
	// Use all SMS calls specific for sports flash
	SMSAPI_RETURN_CODE_ENUM enStartSportsFlash( DECODER_OBJECT,
			tUInt* ,
			SPORTS_FLASH_GAME_EVENT_CALLBACK,
			tVoid*) const;
	tVoid vStopSportsFlash() const;
	SMSAPI_RETURN_CODE_ENUM enAddFavoriteTeam(CID_OBJECT, CID_OBJECT) const;
	SMSAPI_RETURN_CODE_ENUM enRemoveFavoriteTeam(CID_OBJECT, CID_OBJECT) const;
	SMSAPI_RETURN_CODE_ENUM enRemoveAllFavoriteTeams() const;
	SMSAPI_RETURN_CODE_ENUM enIterateFavoriteTeams(SPORTS_FLASH_TEAMS_ITERATOR_CALLBACK,
			tVoid*) const;
	SMSAPI_RETURN_CODE_ENUM enIterateCurrentGames(SPORTS_FLASH_GAMES_ITERATOR_CALLBACK,
			tVoid*) const;
	SMSAPI_RETURN_CODE_ENUM enSetGamesMonitor(CHANNEL_ID*,
			tU16,
			SPORTS_FLASH_FLASH_EVENT_CALLBACK,
			tVoid*) const;
	SMSAPI_RETURN_CODE_ENUM enIterateCurrentFlashEvents(SPORTS_FLASH_EVENTS_ITERATOR_CALLBACK,
			tVoid*) const;
	SMSAPI_RETURN_CODE_ENUM enPlayFlashEvent(SPORTS_FLASH_EVENT_ID) const;
	SMSAPI_RETURN_CODE_ENUM enAbortFlashEvent() const;
	SPORTS_FLASH_EVENT_ID u32CurrentFlashEventID() const;
	SMSAPI_RETURN_CODE_ENUM enEnableNotification(tBool) const;
	tBool bIsNotificationEnabled() const;
	// Fill Channel Attributes
	tVoid vExtractChannelAttributes(CHANNEL_ID, fc_sxm_trSFChannel&) const;
	// Extract Team Attributes
	tBool bExtractTeamInfo(LEAGUE_OBJECT, TEAM_OBJECT, fc_sxm_trSFTeam&) const;
	//Extract League Attributes
	tBool bExtractLeagueInfo(LEAGUE_OBJECT, fc_sxm_trSFLeague&) const;
	// Sports, League and Team Iterate content Callbacks
	tBool bSportsIterateContent(SPORTS_CONTENT_ITERATOR_CALLBACK,
			tVoid*) const;
	tBool bLeagueIterateContent(LEAGUE_CONTENT_ITERATOR_CALLBACK,
			tVoid*) const;
	tBool bTeamIterateContent(LEAGUE_OBJECT,
			TEAM_CONTENT_ITERATOR_CALLBACK,
			tVoid*) const;
	tS16 s16CompareCIDObjects(CID_OBJECT, CID_OBJECT) const;

private:
	friend class fc_sxm_tclSingleton<fc_sxm_tclSportsFlashProxy>;
	fc_sxm_tclSportsFlashProxy();

	DECODER_OBJECT hGetDecoder() const;

	Ifc_sxm_tclDecoder* _poDecoder;
};


#endif /* FC_SXM_TCL_SPORTS_FLASH_PROXY_H_ */
