/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_flash.h
* @brief       Declaration for sports flash service handler.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_SPORTS_FLASH_H_
#define FC_SXM_TCL_SPORTS_FLASH_H_

#include "fc_sxm_tcl_sports_flash_proxy_if.h"
#include "fc_sxm_tcl_audio_member.h"
#include "fc_sxm_audio_fi.h"

struct fc_sxm_trMsgAudioMStartSportsFlashEnableNotification : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 11);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashEnableNotificationMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashAddFavoriteTeam : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 12);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashAddFavoriteTeamMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashRemoveFavoriteTeam : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 13);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveFavoriteTeamMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashRemoveAllFavoriteTeams : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 14);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashRemoveAllFavoriteTeamsMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashGetAllFavorites : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 15);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashGetCurrentGames : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 16);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashSetGamesMonitor : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 17);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashSetGamesMonitorMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashGetCurrentFlashEvents : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 18);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashPlayFlashEvent : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 19);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashPlayFlashEventMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashAbortFlashEvent : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 20);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashAbortFlashEventMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashGetCurrentFlashEventID : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 21);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventIDMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashEnabledLeagues : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 22);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashGetTeams : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 23);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodStart oFiMsg;
};

struct fc_sxm_trMsgAudioMStartSportsFlashMonitorTeam : public fc_sxm_tclMessage
{
	/* Service and service ID */
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_FLASHEVENTS + 24);
	/* Re-addressing info */
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_audiofi_tclMsgSportsFlashMonitorTeamsMethodStart oFiMsg;
};

class fc_sxm_tclSportsFlash;

struct fc_sxm_trTeamIteratorCBArg {
	fc_sxm_tclSportsFlash* poSportsFlash;
	fc_sxm_trSFLeague* poLeague;
};

class Ifc_sxm_tclAudioApp;

struct fc_sxm_trFlashEvents {
	Ifc_sxm_tclAudioApp* _poAudioApp;
	fc_sxm_tclSportsFlash* poSportsFlash;
};


struct fc_sxm_trSFTeamInfo {
	tU8 u8LeagueID;
	tU16 u16TeamID;
	tBool bIsFavorite;
	tBool bIsMonitored;
};

struct fc_sxm_trSFFlashEventDetails {
	SPORTS_FLASH_EVENT_ID tFlashEventID;
	SPORTS_FLASH_EVENT_STATUS_ENUM enFlashEventStatus;
	tU32 u32TimeStamp;

	fc_sxm_trSFFlashEventDetails():
		tFlashEventID((UN32)SPORTS_FLASH_INVALID_EVENT_ID),  enFlashEventStatus(SPORTS_FLASH_EVENT_EXPIRED), u32TimeStamp(0U)
	{ /* Default Constructor */ }
	fc_sxm_trSFFlashEventDetails (SPORTS_FLASH_EVENT_ID, SPORTS_FLASH_EVENT_STATUS_ENUM);
};

struct fc_sxm_trFlashGameEvent {
	fc_sxm_trSFChannel  trChannel;
	fc_sxm_trSFTeamInfo trHomeTeam;
	fc_sxm_trSFTeamInfo trAwayTeam;
	tU32 u32HashCode;
	tU16 u16Bias;
	deque <fc_sxm_trSFFlashEventDetails> eventQueue;

	// Overloading comparison and assignment operators
	bool operator != (fc_sxm_trFlashGameEvent const& b) const
	{
		return !(u32HashCode == b.u32HashCode);
	}

	bool operator == (fc_sxm_trFlashGameEvent const& b) const
	{
		return (u32HashCode == b.u32HashCode);
	}

	bool bIsHomeTeam(const tU8 u8LeagueID, const tU16 u16TeamID) const
	{
		// Return true if the given team is the home team
		return ((trHomeTeam.u8LeagueID == u8LeagueID) &&
				(trHomeTeam.u16TeamID == u16TeamID));
	}

	bool bIsAwayTeam(const tU8 u8LeagueID, const tU16 u16TeamID) const
	{
		// Return true if the given team is the away team
		return ((trAwayTeam.u8LeagueID == u8LeagueID) &&
				(trAwayTeam.u16TeamID == u16TeamID));
	}

	tVoid vUpdateEventQueue(SPORTS_FLASH_EVENT_ID eventID, SPORTS_FLASH_EVENT_STATUS_ENUM enStatus);

	fc_sxm_trFlashGameEvent() : trChannel(), trHomeTeam(), trAwayTeam(),
			u32HashCode(0U), u16Bias(0U)
			{ /* CTOR*/ }
};

struct fc_sxm_trMsgAudioSmsEvtTuneState;
struct fc_sxm_trMsgAudioSmsEvtChannelEvt;
struct fc_sxm_tcl_trAudioPropertySportsFlash_FlashEventNotification;

class fc_sxm_tclSportsFlash
    : public fc_sxm_tclAudioMember
    , public fc_sxm_tclSingleton<fc_sxm_tclSportsFlash>
{
public:
    virtual ~fc_sxm_tclSportsFlash();

    // Start SportsFlash service once decoder is up and is in ready state
	virtual tVoid vUpdateDecoderState(
				DECODER_OBJECT hDecoderObject,
				DECODER_STATE_ENUM enDecoderState);

	tVoid vInit();
	tVoid vDeInit();
	//  Clear class member variables
	tVoid vClearMemberData(tVoid);

	// Set Audio App Pointer Reference
	tVoid vSetApp(Ifc_sxm_tclAudioApp* poAudioApp, Ifc_sxm_tclSportsFlashProxy* poSFProxy);

	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashEnableNotification const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashAddFavoriteTeam const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashRemoveFavoriteTeam const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashRemoveAllFavoriteTeams const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashGetAllFavorites const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashGetCurrentGames const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashSetGamesMonitor const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashGetCurrentFlashEvents const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashPlayFlashEvent const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashAbortFlashEvent const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashGetCurrentFlashEventID const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashEnabledLeagues const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashGetTeams const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioMStartSportsFlashMonitorTeam const *prMsg);

	tVoid vProcess(fc_sxm_trMsgSFGameAlert const *prMsg);
	tVoid vProcess(fc_sxm_trMsgSFFlashEventAlert const *prMsg);
	tVoid vProcess(fc_sxm_trMsgAudioSmsEvtTuneState const *);
	tVoid vProcess(fc_sxm_trMsgAudioSmsEvtChannelEvt const *);

	static tVoid cb_GameEventCallback(DECODER_OBJECT hDecoder, SPORTS_FLASH_PROGRAM_STATUS_ENUM enProgramStatus,
			const SPORTS_FLASH_GAME_EVENT_INFO_STRUCT* poGameInfo, tVoid* poEventCallBackArg);
	static tVoid cb_FlashEventCallback(DECODER_OBJECT hDecoder, CHANNEL_ID tChannelID, SPORTS_FLASH_EVENT_ID tFlashEventID,
			SPORTS_FLASH_EVENT_STATUS_ENUM eFlashEventStatus, tVoid *poEventCallBackArg);
	static tBool cb_SportsIteratorCallback(const tChar* chPacID, const tChar* chPacNam, SPORTS_ENUM enSport, CID_OBJECT hID, tVoid* poContentIteratorCBArg);
	static tBool cb_LeagueIteratorCallback(LEAGUE_OBJECT hLeague, tVoid* poContentIteratorCBArg);
	static tBool cb_TeamIteratorCallback(TEAM_OBJECT hTeam, tVoid* poContentIteratorCBArg);
	static tBool cb_FavoritesIteratorCallback(CID_OBJECT hLeagueId, CID_OBJECT hTeamId, tVoid* poContentIteratorCBArg);
	static tBool cb_ActiveGamesIteratorCallback( const SPORTS_FLASH_GAME_EVENT_INFO_STRUCT *poGameInfo, tVoid* poContentIteratorCBArg);
	static tBool cb_ActiveFlashEventsIteratorCallback( CHANNEL_ID tChannelID, SPORTS_FLASH_EVENT_ID tFlashEventID, tVoid* poContentIteratorCBArg);
	static midw_ext_fi_tcl_e8_SportsFlash_Sport::tenType enGetSportType(SPORTS_ENUM enSport);

	tBool bHandleSportsIteratorCB(const tChar* chPacID, const tChar* chPacNam, SPORTS_ENUM enSport, CID_OBJECT hID);
	tBool bHandleLeagueIteratorCB(LEAGUE_OBJECT hLeague);
	tBool bHandleTeamIteratorCB(fc_sxm_trSFLeague* poSFLeague, TEAM_OBJECT hTeam) const;
	tBool bHandleFavoriteTeamIteratorCB(CID_OBJECT hLeagueId, CID_OBJECT hTeamId);
	tBool bHandleGamesIteratorCB(const SPORTS_FLASH_GAME_EVENT_INFO_STRUCT *poGameInfo);
	tBool bHandleFlashEventsIteratorCB( CHANNEL_ID tChannelID, SPORTS_FLASH_EVENT_ID tFlashEventID );
	tVoid vMetaDataUpdateStart();
	tVoid vMetaDataUpdateComplete();
	SMSAPI_RETURN_CODE_ENUM enAbortFlashEvent() const;
	tBool bIsSFPlaybackInProgress() const { return _bIsSFPlayback; }

	typedef enum enBiasState
	{
	    enActiveGameBiasState_Replace_NewGameEntry = 0,
	    enActiveGameBiasState_Discard_NewGameEntry,
	    enActiveGameBiasState_Unknown_Action
	} enActiveGameBiasState;

private:
    friend class fc_sxm_tclSingleton<fc_sxm_tclSportsFlash>;
    fc_sxm_tclSportsFlash();

#ifdef UNITTEST_FC_SXM
    // For unit test product, to perform effective unit-testing of all private members,
    // the private methods/variables are made public.
    // In production-code, the methods and variables still remain private
public:
#endif //UNITTEST_FC_SXM

    SMSAPI_RETURN_CODE_ENUM enStartSF(DECODER_OBJECT hDecoder);
    tVoid vStopSF(tBool bIsBroadscopeChange = FALSE);
    tVoid vNotifySFServiceState(SMSAPI_RETURN_CODE_ENUM enRetCode, tBool bStartService);
    tBool bCollectSports();
    tBool bCollectLeagues();
    tBool bCollectTeams();
    tBool bCollectFavorites();
    tVoid vFillSportsInfo(fc_sxm_trSFLeague& trSFLeague) const;

    /*
     * Methods for performing Set/Unset Favorite Activities....
     */
    tBool bSetFavoritebyCID(fc_sxm_trSFLeague* poLeague, CID_OBJECT hTeamId) const;
    tBool bUnSetFavoritebyCID(fc_sxm_trSFLeague* poLeague, CID_OBJECT hTeamId) const;
    tBool bSetFavoritebyTID(fc_sxm_trSFLeague* poLeague, const tU16 u16TeamId) const;
	tBool bUnSetFavoritebyTID(fc_sxm_trSFLeague* poLeague, const tU16 u16TeamId) const;
	tBool bUnsetAllFavorites();

	// Method for changing the Monitor status
	tBool bSetTeamMonitorStatusbyTID(fc_sxm_trSFLeague* poLeague, const tU16 u16TeamId, tBool bMonitorStatus) const;

	tBool bRemoveAllFavorites() const;
	tVoid vClearFavoritesList();

    /*
	 * Methods for identifying a league or team based on CID_OBJECT or league/team ids
	 */
    fc_sxm_trSFLeague* poFindLeaguebyCID(CID_OBJECT hLeagueId);
    fc_sxm_trSFTeam* poFindTeambyCID(fc_sxm_trSFLeague* poLeague, CID_OBJECT hTeamId) const;
    fc_sxm_trSFLeague* poFindLeaguebyLID(const tU8 u8LeagueID);
    fc_sxm_trSFTeam* poFindTeambyTID(fc_sxm_trSFLeague* poLeague, const tU16 u16TeamId) const;

    /*
     * Methods for filling up FI structures based on request issued
     */
    tVoid vFillSFEnabledLeagueList(midw_ext_sxm_audiofi_tclMsgSportsFlashEnabledLeaguesMethodResult& oMRes) const;
    tVoid vFillLeagueInfo(const fc_sxm_trSFLeague& trLeague, midw_ext_fi_tcl_SportsFlash_League& fiLeague) const;
    tVoid vFillTeamList(const fc_sxm_trSFLeague* poLeague, midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult& oMRes) const;
    tVoid vFillTeamListBySort(const fc_sxm_trSFLeague* poLeague, midw_ext_sxm_audiofi_tclMsgSportsFlashGetTeamsMethodResult& oMRes) const;
    tVoid vFillTeamInfo(const fc_sxm_trSFTeam& trTeam, midw_ext_fi_tcl_SportsFlash_Team& fiTeam) const;
    tVoid vFillFavoriteTeamsList(midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult& oMRes) const;
    tVoid vFillFavoriteTeamsListBySort(midw_ext_sxm_audiofi_tclMsgSportsFlashGetAllFavoritesMethodResult& oMRes) const;
	tVoid vFillFavoriteTeamInfo(const fc_sxm_trSFLeague& trLeague, const fc_sxm_trSFTeam& trTeam, midw_ext_fi_tcl_SportsFlash_FavoriteTeam& fiTeam) const;

    tS16 s16CompareCIDObjects(CID_OBJECT hCID1, CID_OBJECT hCID2) const;

    tBool bAddFavoriteTeam(const midw_ext_fi_tcl_e8_SportsFlash_Sport::tenType enType, const tU8 u8LeagueID, const tU16 u16TeamId);
    tBool bRemoveFavoriteTeam(const midw_ext_fi_tcl_e8_SportsFlash_Sport::tenType enType, const tU8 u8LeagueID, const tU16 u16TeamId);

    SMSAPI_RETURN_CODE_ENUM enPlayFlashEvent(SPORTS_FLASH_EVENT_ID tEventID) const;
	SPORTS_FLASH_EVENT_ID u32CurrentFlashEventID() const;
	SMSAPI_RETURN_CODE_ENUM enIterateCurrentGames();
	SMSAPI_RETURN_CODE_ENUM enIterateFlashEvents();

	tVoid vExtractGameEventDetails(const SPORTS_FLASH_GAME_EVENT_INFO_STRUCT *poGameInfo, fc_sxm_trFlashGameEvent& trGameEvent);
	string sExtractGameEventTeam(CID_OBJECT hLeagueID, CID_OBJECT hTeamID, fc_sxm_trSFTeamInfo& trTeamInfo);
	tVoid vFillGamesList(midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentGamesMethodResult& oMRes);
	tVoid vFillGameDetails(const fc_sxm_trFlashGameEvent& trGameEvent, midw_ext_fi_tcl_SportsFlash_Game& fiGame);
	tVoid vFillFlashEventsList(midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult& oMRes);
	tVoid vPrintFlashEventsList(const midw_ext_sxm_audiofi_tclMsgSportsFlashGetCurrentFlashEventsMethodResult& oMRes) const;
	tBool bAddActiveGame(const fc_sxm_trFlashGameEvent& trGame);
	tBool bRemoveActiveGame(const fc_sxm_trFlashGameEvent& trGame);
	tVoid vRemoveTeamFromActiveGamesList(const tU8 u8LeagueID, const tU16 u16TeamID);

	tVoid vSFSetup();
	tVoid vHandleGameEventCB(SPORTS_FLASH_PROGRAM_STATUS_ENUM enProgramStatus, const SPORTS_FLASH_GAME_EVENT_INFO_STRUCT* poGameInfo);
	tVoid vHandleFlashEventCB(CHANNEL_ID tChannelID, SPORTS_FLASH_EVENT_ID tFlashEventID, SPORTS_FLASH_EVENT_STATUS_ENUM eFlashEventStatus);

	tVoid vNotifyGameEventUpdate(SPORTS_FLASH_PROGRAM_STATUS_ENUM enProgramStatus, const fc_sxm_trFlashGameEvent& trGame);
	tVoid vNotifyFlashEventUpdate(const fc_sxm_trFlashGameEvent& trGame, SPORTS_FLASH_EVENT_ID tFlashEventID, SPORTS_FLASH_EVENT_STATUS_ENUM eFlashEventStatus);

	tBool bUpdateMonitorStatus(tU8 u8LeagueID, tU16 u16TeamID, tBool bMonitorStatus);

	enActiveGameBiasState enCalculateBias(const fc_sxm_trFlashGameEvent& trExistingGameEntry, const fc_sxm_trFlashGameEvent& trNewGameEntry) const;
	tVoid vRetrieveChannelInfo(CHANNEL_ID, fc_sxm_trSFChannel&);

	SMSAPI_RETURN_CODE_ENUM enSetGamesMonitor();
	SMSAPI_RETURN_CODE_ENUM enSetGamesMonitor(const vector<tU16, allocator<tU16> > & vectChannelIDs);
	SMSAPI_RETURN_CODE_ENUM enEnableSFNotifications(tBool bEnable) const;
	tBool bIsSFNotificationEnabled() const;

    tVoid vSendSFFiMsg(fc_sxm_trAdressing const &rAddr, const midw_ext_sxm_audiofi_tclMsgBaseMessage& oMessage);
    tVoid vSendSFFiError(fc_sxm_trAdressing const &rAddr, tInt s32ErrorMsg);
    tVoid vSortFavorites(vector<midw_ext_fi_tcl_SportsFlash_FavoriteTeam, allocator<midw_ext_fi_tcl_SportsFlash_FavoriteTeam> > &teamList) const;
    tVoid vSortTeams(vector<midw_ext_fi_tcl_SportsFlash_Team, allocator<midw_ext_fi_tcl_SportsFlash_Team> > &teamList) const;
    tBool bNotifyFlashEvent(CHANNEL_ID) const;
    tVoid vNotifyPendingAlerts();
    tBool bUpdatePendingAlertsList(const fc_sxm_tcl_trAudioPropertySportsFlash_FlashEventNotification& );
    tVoid vClearActiveGameEvents(fc_sxm_trFlashGameEvent& );
    tVoid vResetAlerts() const;
    tVoid vResetGameEventAlerts() const;
    tVoid vResetFlashEventAlerts() const;


    Ifc_sxm_tclAudioApp* _poAudioApp;
    Ifc_sxm_tclSportsFlashProxy* _poSFProxy;

    tBool _bIsSFInitialized;
    tBool _bEnableSF;
    tBool _bIsMetaDataChanged;
    tBool _bIsSFPlayback;

    tUInt _uMaxSFChannels;
    CHANNEL_ID _channelID;

    vector<fc_sxm_trSFSport> _vectSports;
    vector<fc_sxm_trSFLeague> _vectLeague;
    vector<fc_sxm_trFlashGameEvent> _vectActiveGames;
    vector <fc_sxm_tcl_trAudioPropertySportsFlash_FlashEventNotification> _vectPendingAlerts;
};


#endif /* FC_SXM_TCL_SPORTS_FLASH_H_ */
