/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_content_alert_proxy.h
* @brief       Content alert proxy class declaration.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_CONTENT_ALERT_PROXY_H
#define FC_SXM_TCL_CONTENT_ALERT_PROXY_H

#include "fc_sxm_tcl_content_alert_proxy_if.h"

class fc_sxm_tclContentAlertProxy :
   public Ifc_sxm_tclContentAlertProxy,
   public fc_sxm_tclSingleton<fc_sxm_tclContentAlertProxy>
{
public :
   virtual ~fc_sxm_tclContentAlertProxy() { /* Default DTOR */}
   SMSAPI_RETURN_CODE_ENUM enStart(DECODER_OBJECT hDecoderObject) const;
   tVoid vStop(DECODER_OBJECT hDecoderObject) const;

   tVoid vIterateFavorites(DECODER_OBJECT hDecoderObject,
      SEEK_CONTENT_ITERATOR_CALLBACK bSeekContentIterator,
      void *pvSeekContentIteratorArg) const;

   tVoid vIterateAlertChannels(DECODER_OBJECT hDecoder,
      CATEGORY_ID hCategoryId,
      CATEGORY_ITERATION_HANDLER n16IterateFxn,
      void *pvIterateArg) const;

   CHANNEL_ID hGetTunedChannel(DECODER_OBJECT) const;
   CHANNEL_OBJECT hGetChannel(SEEK_EVENT_OBJECT hSeekEvent) const;
   SEEK_CONTENT_OBJECT hGetSeekContent(SEEK_EVENT_OBJECT hSeekEvent) const;
   CATEGORY_ID hGetSeekCategoryId(DECODER_OBJECT hDecoder) const;
   tU32 u32GetSeekChannelSize(DECODER_OBJECT, CATEGORY_ID) const;
   SERVICE_ID hGetServiceId(CHANNEL_OBJECT hChannel) const;
   CHANNEL_ID hGetChannelId(CHANNEL_OBJECT hChannel) const;
   string sGetSmsStringAsStl(STRING_OBJECT hRegisteredContentTest) const;
   midw_ext_fi_tclString hGetSmsStringAsFi(STRING_OBJECT hRegisteredContentText) const;
   STRING_OBJECT hGetChannelName(CHANNEL_OBJECT hChannel) const;
   STRING_OBJECT hGetArtistName(SEEK_CONTENT_OBJECT hSeekContent) const;
   STRING_OBJECT hGetSongName(SEEK_CONTENT_OBJECT hSeekContent) const;
   STRING_OBJECT hGetArtistName(CHANNEL_OBJECT) const;
   STRING_OBJECT hGetSongName(CHANNEL_OBJECT) const;
   AT_SEEK_ENUM enGetFavoriteType(SEEK_CONTENT_OBJECT hSeekContent) const;
   SEEK_EVENT_OBJECT hGetNextAlertEvent(DECODER_OBJECT hDecoder) const;
   SMSAPI_RETURN_CODE_ENUM enGetNextEndedEventAttributes(DECODER_OBJECT,
         CHANNEL_ID* ,
         STRING_OBJECT* ,
         STRING_OBJECT* ) const;
   tBool bGetFavoriteStatus(SEEK_CONTENT_OBJECT hSeekContent) const;
   tBool bGetAlertsFinishedStatus(DECODER_OBJECT hDecoder) const;

   SMSAPI_RETURN_CODE_ENUM enRegisterFavorite(DECODER_OBJECT hDecoderObject,
      AT_SEEK_ENUM enFavoriteType,
      CHANNEL_ID hChannelID,
      SEEK_CONTENT_OBJECT* oSeekContentObject) const;
   tVoid vIsAvailableToRegister(DECODER_OBJECT hDecoderObject,
      CHANNEL_ID hChannelID,
      SEEK_AVAILABILTY_ENUM* enTitleAvailability,
      SEEK_AVAILABILTY_ENUM* enArtistAvailability) const;
   SMSAPI_RETURN_CODE_ENUM enEnableFavorite(SEEK_CONTENT_OBJECT hSeekContent) const;
   SMSAPI_RETURN_CODE_ENUM enDisableFavorite(SEEK_CONTENT_OBJECT hSeekContent) const;
   SMSAPI_RETURN_CODE_ENUM enDeleteFavorite(SEEK_CONTENT_OBJECT hSeekContent) const;
   SMSAPI_RETURN_CODE_ENUM enEnableAlertsTuned(DECODER_OBJECT hDecoder,
         BOOLEAN bEnable) const;
   SMSAPI_RETURN_CODE_ENUM enEnableAlertsFinished(DECODER_OBJECT,
         BOOLEAN) const;

   midw_ext_fi_tcl_AlertInfo oFillAlertInfo(SEEK_EVENT_OBJECT hSeekEvent) const;
private:
   friend class fc_sxm_tclSingleton<fc_sxm_tclContentAlertProxy>;
   fc_sxm_tclContentAlertProxy() { /* Default CTOR */ };
};

#endif // FC_SXM_TCL_CONTENT_ALERT_PROXY_H

