/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_channel_list_if.h
* @brief       Interface for channel list related functionalities. 
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_CHANNEL_LIST_IF_H_
#define FC_SXM_TCL_CHANNEL_LIST_IF_H_

typedef enum FCSXM_SelectMode
{
    e_SELECT_CHANNEL = 0
   ,e_RECALL_PRESET   // 1
   ,e_TUNING_CHANNEL  // 2
   ,e_TUNED_CHANNEL   // 3
   ,e_UNAVAILABLE_CHANNEL // 4
   ,e_UNAVAILABLE_CHANNEL_STARTUP // 5
   ,e_MATURE_LOCKED_CHANNEL // 6
   ,e_MATURE_LOCKED_CHANNEL_STARTUP // 7
   ,e_SKIPPED_CHANNEL // 8
   ,e_SKIPPED_CHANNEL_STARTUP // 9
   ,e_ADVISORY_TIMEOUT // 10
   ,e_ADVISORY_UPDATE // 11
   ,e_CHANNEL_ART_UPDATE // 12
   ,e_CHANNEL_BROWSE // 13
   ,e_SUBSCRIPTION_UPDATED // 14
   ,e_RADIO_ID_CHANNEL // 15
   ,e_FACTORY_RESET // 16
} tFCSXM_SelectMode;

/*=============================================================================
=======               CONSTANTS & MACROS FOR GENERAL PURPOSE            =======
=============================================================================*/

#define FC_SXM_AUDIO_THRESHOLD_CHANNEL_NO    1000

/*****************************************************************************
 * CLASS        : fc_sxm_tclChannelListIF                                      *
 * ------------------------------------------------------------------------- *
 * DESCRIPTION  : Abstract Class for interfaces offered by class fc_sxm_tclChannelList*
 *****************************************************************************/
class midw_ext_fi_tcl_PresetListEntry;
class midw_ext_fi_tcl_ChannelList;

class Ifc_sxm_tclChannelList {
public:
	/* Will be accessed by preset class to handle unavailable and
	   unauthorised channels */
	CHANNEL_ID _u16RequestedUnavailableChannel;

	// Methods
	Ifc_sxm_tclChannelList () : _u16RequestedUnavailableChannel(CHANNEL_INVALID_ID) {  }
	virtual tVoid vNotifyChannelInformationUpdate(tFCSXM_SelectMode ) = 0;
	virtual midw_ext_fi_tcl_PresetListEntry enGetPresetChannelInfo(
	            CHANNEL_ID ,
	            tBool , tTunable& ) = 0;
    virtual tBool bIsDwellTimerRunning() = 0;
    virtual tVoid vStopDwellTimer() = 0;
    virtual SERVICE_ID u16GetSIDOfTunedChannel() const = 0;
	virtual SERVICE_ID u16GetSIDOfPreviewChannel()const  = 0;
	virtual CHANNEL_ID u16GetCurrentTunedChannel() const = 0;
	virtual tVoid vUpdateAllChannels(midw_ext_fi_tcl_ChannelList &) = 0;
	virtual tVoid vUpdateCurrentTunedChannel() = 0;
	virtual tVoid vRestorePreviewChannel() = 0;
	virtual tBool bGetChannelBrowseStatus(CHANNEL_ID) const = 0;
	virtual tBool bGetMatureChannelLockStatus() const = 0;
	virtual ~Ifc_sxm_tclChannelList() { };
};


#endif /* FC_SXM_TCL_CHANNEL_LIST_IF_H_ */
