/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_category_list_if.h
* @brief       Category List Handler Interface.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_CATEGORY_LIST_IF_H_
#define FC_SXM_TCL_CATEGORY_LIST_IF_H_

#define FC_SXM_AUDIO_CATEGOEY_CHANNEL_UP      +1
#define FC_SXM_AUDIO_CATEGOEY_CHANNEL_DOWN    -1
#define FC_SXM_AUDIO_TUNE_PROGRAM_UP          +1
#define FC_SXM_AUDIO_TUNE_PROGRAM_DOWN        -1

class Ifc_sxm_tclCategoryList {
public:
	virtual ~Ifc_sxm_tclCategoryList() { }

	virtual CHANNEL_ID u16GetCidFromCategoryListIndex (tU16, tU16) = 0;
	virtual CHANNEL_ID u16GetCidFromCategoryListRelativeIndex (CATEGORY_ID, CHANNEL_ID, tS16) = 0;
	virtual CHANNEL_ID u16GetCidOfNextProgramFromCategoryList (tU16, tS16) = 0;
	virtual tVoid vCategoryListUpdate() = 0;
	virtual tVoid vFetchCategoryChannels(vector<CHANNEL_ID>& , CATEGORY_ID ) const = 0;
};


#endif /* FC_SXM_TCL_CATEGORY_LIST_IF_H_ */
