/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_audio_member.h
* @brief       List Template definition for Audio Functionalities.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AUDIO_MEMBER_H_
#define _FC_SXM_TCL_AUDIO_MEMBER_H_

#include "fc_sxm_tcl_ahl_object_list.h"




class fc_sxm_tclAudioMember {
 public:
    virtual ~fc_sxm_tclAudioMember() { }
    virtual tVoid vInit() { }
    virtual tVoid vDeInit() { }
    virtual tVoid vUpdateDecoderState(DECODER_OBJECT /* hDecoderObject */,
                                      DECODER_STATE_ENUM /* enDecoderState */) { }
};

class fc_sxm_tclAudioMemberList: 
public fc_sxm_tclObjectList<fc_sxm_tclAudioMember> {
 public:

    tVoid vInit() {
        SXM_FOREACH(deque<fc_sxm_tclAudioMember *>, iter, _oQ) {
            fc_sxm_tclAudioMember *poMember=*iter;
            if (OSAL_NULL != poMember) {
                poMember->vInit();
            }
        }
    }

    tVoid vDeInit() {
        for (deque<fc_sxm_tclAudioMember * >::reverse_iterator iter=_oQ.rbegin();
             iter!=_oQ.rend();
             ++iter) {
            if (OSAL_NULL != (*iter)) {
                (*iter)->vDeInit();
            }
        }
    }
    tVoid vUpdateDecoderState(DECODER_OBJECT hDecoderObject, 
                                      DECODER_STATE_ENUM enDecoderState) {
        SXM_FOREACH(deque<fc_sxm_tclAudioMember *>, iter, _oQ) {
            fc_sxm_tclAudioMember *poMember=*iter;
            if (OSAL_NULL != poMember) {
                poMember->vUpdateDecoderState(hDecoderObject, enDecoderState);
            }
        }
    }
};

#endif
