/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diaghandler.h
* @brief       SXM Diagnosis handler.Responsible for creation, Mediator for other 
*              Diagnosis helper classes and also destruction.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_DIAG_HANDLER_H_
#define _FC_SXM_TCL_DIAG_HANDLER_H_

#include "fc_sxm_common.h"
#include "fc_sxm_sms.h"
#include "fc_sxm_tcl_reg_util.h"
#include "fc_sxm_audio_fi.h"
#include "fc_sxm_client_diaglog_fi.h"
#include "fc_sxm_tcl_base_app.h"
#include "fc_sxm_tcl_audio_app.h"
#include "fc_sxm_tcl_states.h"
#include "fc_sxm_diag_types.h"



//Definitions for registry keys and values.
#define SXM_DIAG_REG_VERSIONS_PATH       "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS"
#define SXM_DIAG_REG_SERIAL_NUM_KEY     "SXM_SERIALNO_VER"
#define SXM_DIAG_REG_HW_VER_KEY         "SXM_HW_VER"
#define SXM_DIAG_REG_SW_VER_KEY         "SXM_SW_VER"



struct fc_sxm_trModuleVerInfo {
    string oRadioId;
    string oHwRev;
    string oSwRev;
};

class fc_sxm_tclDiagUsrDataClear;

class fc_sxm_tclDiagTestActivity: public fc_sxm_tclActivityBase {
 public:
        
        virtual tVoid vRun();
};


class fc_sxm_tclDiagHandler:
	public fc_sxm_tclAudioMember,
    public fc_sxm_tclSingleton<fc_sxm_tclDiagHandler> 
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagHandler>;
    friend class fc_sxm_tclDiagUsrDataClear; 
public:


    /*Destructor*/
    virtual ~fc_sxm_tclDiagHandler();

    virtual tVoid vInit();
    virtual tVoid vDeInit();

    /*Method to update the decoder state to Diag handler*/
    tVoid vUpdateDecoderState(DECODER_OBJECT hDecoderObject, 
        DECODER_STATE_ENUM enDecoderState);


    /*Method to dispatch message to Diagnosis classes*/
    tBool bDispatchMsg(fc_sxm_tclMessage const *poThreadMsg) const;    


    // has to be called in context of sms-module callback
    static tVoid vHandleModuleCallBack(MODULE_OBJECT hModule, 
                                       MODULE_EVENT_MASK tEventMask);

    /* ttfis-commands */
    tVoid vProcess(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);

    //Method to update Antenna state
    tVoid vProcess(fc_sxm_trMsgAudioSmsEvtAntennaQuality const *prMsg) const;

    //Method to update SXM antenna DTC values to diaglog
    tVoid vProcess(fc_sxm_trMsgAudioDiagSetSXMAntennaDTC const * /* prMsg */ ) const;

    //Method to update Signal state
    tVoid vProcess(fc_sxm_trMsgAudioSmsEvtSignalState const *prMsg) const;

    /* fetch version-info once the module has gone to ready */
    tVoid vProcess(fc_sxm_trMsgAudioSmsEvtModuleState const *prMsg);

    //For testing
    tBool bReadVerRegKey(char const *pKey, char *pValue, tU32 u32Len) const;

    // handle result of test-activitiy
    virtual tVoid vHandleResult(fc_sxm_tenDiagResult enResult);

    fc_sxm_trModuleVerInfo const &rGetModuleVersInfo() const {
        return _rModuleVerInfo; //returns module information
    }
protected:



private:
    /*Constructor*/
    fc_sxm_tclDiagHandler();

    // fetch version-info from module
    tVoid vFetchModuleVerInfo(fc_sxm_trModuleVerInfo *prVerInfo) const;

    /*Method to write to registry.Used by FC_Diagnosis*/
    tVoid vWriteSxmVerRegistry(fc_sxm_trModuleVerInfo const &rVerInfo) const;

    // utility to write single key to version registry used by vWriteSxmVerRegistry()
    tVoid vWriteSxmVerRegistryKey(fc_sxm_tclRegUtil &oReg, const char *pcKey, string const &oValString) const;

    /*Method to update antenna state*/
    tVoid vUpdateAntennaState(ANTENNA_STATE_ENUM hAntennaState) const;

    /*Method to update signal quality*/
    tVoid vUpdateSignalQuality(SIGNAL_QUALITY_STRUCT lSignalQuality) const;

    fc_sxm_tclDiagTestActivity _oTestActivity;
    
    fc_sxm_trModuleVerInfo _rModuleVerInfo;

    fc_sxm_tclObjectList<fc_sxm_tclDiagMember> _oMemberList;

};








#endif //_FC_SXM_TCL_DIAG_HANDLER_H_
