/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_usr_data_clear.h
* @brief       Declarations for clearing user data.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_DIAG_USR_DATA_CLEAR
#define FC_SXM_TCL_DIAG_USR_DATA_CLEAR

#include "fc_sxm_common.h"
#include "fc_sxm_diag_types.h"

// command to clear user-data of all apps
struct fc_sxm_trMsgCmdClearUserData: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_CLEAR_USER + 1);
};


// answer messgage when all apps are cleared
struct fc_sxm_trMsgCmdClearUserDataFinalize: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_CLEAR_USER + 2);
    //constructor
    fc_sxm_trMsgCmdClearUserDataFinalize() {};
};



class fc_sxm_tclDiagUsrDataClear:
public fc_sxm_tclDiagMember,
public fc_sxm_tclSingleton<fc_sxm_tclDiagUsrDataClear>
{
 public:
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagUsrDataClear>;

    ~fc_sxm_tclDiagUsrDataClear();

    // to be called by fc_sxm_tclDiag to start clearing of user-data
    tBool bStart();

    // called in context of app
    tVoid vSetResult(fc_sxm_tenServiceID enServiceId, fc_sxm_tenDiagResult enRes);

    // call in diag-context (audio)
    tVoid vProcessTimer(fc_sxm_trMsgCmdClearUserDataFinalize const *prMsg);

    /* clearing of user-date using class fc_sxm_tclDiagUsrDataClear.
       we will notified in our context with vOnClearUserDataResult()*/
    tVoid vProcess(fc_sxm_trMsgCmdClearUserData const *prMsg);


 private:
    fc_sxm_tclDiagUsrDataClear();

    tBool bIsActive() const;
    tBool bIsReady() const;
    tBool bIsSuccess() const;

    map<fc_sxm_tenServiceID, fc_sxm_tenDiagResult> _mapResults;
    fc_sxm_tclTimer<fc_sxm_tclAudioApp, fc_sxm_trMsgCmdClearUserDataFinalize, fc_sxm_tclDiagUsrDataClear> _oSupervisonTimer;
    fc_sxm_tclSem _oSem;
    
};

#endif
