/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_smslog.h
* @brief       SMS library logs handler.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_DIAG_SMSLOG_H_
#define _FC_SXM_TCL_DIAG_SMSLOG_H_

#include "fc_sxm_common.h"
#include "fc_sxm_sms.h"
#include "fc_sxm_diag_types.h"



typedef enum {
    fc_sxm_enSmsLogCmd_List,
    fc_sxm_enSmsLogCmd_Clear,
    fc_sxm_enSmsLogCmd_PrintToConsole,
    fc_sxm_enSmsLogCmd_PrintToFile,
    fc_sxm_enSmsLogCmd_Enable,
    fc_sxm_enSmsLogCmd_Disable,
    fc_sxm_enSmsLogCmd_LAST
} fc_sxm_tenSmsLogCmd;


class fc_sxm_tclDiagSmsLog:
public fc_sxm_tclDiagMember,
public fc_sxm_tclSingleton<fc_sxm_tclDiagSmsLog>
{
 public:
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagSmsLog>;
    // receive, check and dispatch commmand
    tVoid vHandleLogCmd(fc_sxm_tenSmsLogCmd enCmd, string oSmsObjName) const;



 private:
    fc_sxm_tclDiagSmsLog() {};

    // get sms-obj matching oSmsObjName
    OSAL_OBJECT_HDL hGetSmsLogHandle(string oSmsObjName) const;

    // handling of specific commands
    tVoid vHandleList() const;

    tVoid vHandleClear(OSAL_OBJECT_HDL hLog, string oSmsObjName, tBool bEnable=TRUE) const;


    tVoid vHandlePrint(OSAL_OBJECT_HDL hLog, string oSmsObjName, tBool bToFile) const;

};

#endif

