/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_reporter.h
* @brief       Class Declaration for printing reports of all SXM services.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_DIAG_REPORTER_H
#define FC_SXM_TCL_DIAG_REPORTER_H

#include "fc_sxm_common.h"
#include "fc_sxm_diag_types.h"
#include "fc_sxm_tcl_diag_for_each_base.h"

// self-message of diagReporter to print report for all apps one by one
struct fc_sxm_trMsgCmdDiagPrintReport: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_REPORTER + 1);
    //constructor
    fc_sxm_trMsgCmdDiagPrintReport() {};
};

// Self-mesage of diag-reporter when an app has finished printing the report
struct fc_sxm_trMsgCmdDiagPrintReportDone: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_REPORTER + 2);
    //constructor
    fc_sxm_trMsgCmdDiagPrintReportDone() {};
};

// start reporter-class
class fc_sxm_tclDiagReporter:
    public fc_sxm_tclDiagForEach<fc_sxm_tclDiagReporter>,
    public fc_sxm_tclDiagMember,
    public fc_sxm_tclSingleton<fc_sxm_tclDiagReporter>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagReporter>;

 public:
    using fc_sxm_tclDiagForEachBase::vProcessTimer;
    virtual ~fc_sxm_tclDiagReporter();

    // request to print all reports 

   tVoid vProcess(fc_sxm_trMsgCmdDiagPrintReport const *prMsg);

    /*
      receive this message when all is done (dont send this message, it will be sent by vOnDone)
    */
   tVoid vProcess(fc_sxm_trMsgCmdDiagPrintReportDone const *prMsg);




 protected:
    // Base class will call us with vQueryApp to send request to specified application
    virtual tVoid vQueryApp(fc_sxm_tclBaseApp* poBaseApp);

    /* Base-class will call this method when all is done.
       This can be called from any thread-context.
       So we send the result-message fc_sxm_trMsgCmdDiagPrintReportDone to our own
       thread to handle the result.
    */
    virtual tVoid vOnDone();
    
 private:
    fc_sxm_tclDiagReporter();


};


#endif
