/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_properties.h
* @brief       Declaration of messages used for property notifications within SXM Diagnosis.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef SXM_DIAG_PROPERTIES_H
#define SXM_DIAG_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_audio_fi.h"


/* start diag-property Test Mode Data*/
struct fc_sxm_tcl_trDiagPropertyTestModeData 
{
    /* Constructor */
    fc_sxm_tcl_trDiagPropertyTestModeData()
    {}


    /* Overloading comparision operator */
    bool operator!=(fc_sxm_tcl_trDiagPropertyTestModeData const& b) const
    {
        return !(oFiMsg == b.oFiMsg);
    }

    /* Overloading conversion operator */
    operator midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus() 
    {
        return oFiMsg;
    }

    tVoid vTrace() const;

    midw_ext_sxm_audiofi_tclMsgDiagTestModeDataStatus oFiMsg;

};


struct fc_sxm_tcl_trDiagPropertyAntennaState 
{
    /* Constructor */
    fc_sxm_tcl_trDiagPropertyAntennaState()
    {}


    /* Overloading comparision operator */
    bool operator!=(fc_sxm_tcl_trDiagPropertyAntennaState const& b) const
    {
        return !(oFiMsg == b.oFiMsg);
    }

    /* Overloading conversion operator */
    operator midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus() 
    {
        return oFiMsg;
    }

    tVoid vTrace() const;

    midw_ext_sxm_audiofi_tclMsgSxmDiagAntennaStateStatus oFiMsg;

};

struct fc_sxm_tcl_trDiagPropertySignalQuality 
{
    /* Constructor */
    fc_sxm_tcl_trDiagPropertySignalQuality()
    {}


    /* Overloading comparision operator */
    bool operator!=(fc_sxm_tcl_trDiagPropertySignalQuality const& b) const
    {
        return !(oFiMsg == b.oFiMsg);
    }

    /* Overloading conversion operator */
    operator midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus() 
    {
        return oFiMsg;
    }

    tVoid vTrace() const;

    midw_ext_sxm_audiofi_tclMsgSxmDiagSignalQualityStatus oFiMsg;

};

struct fc_sxm_tcl_trDiagSxmRadioId 
{
    /* Constructor */
    fc_sxm_tcl_trDiagSxmRadioId()
    {}


    /* Overloading comparision operator */
    bool operator!=(fc_sxm_tcl_trDiagSxmRadioId const& b) const
    {
        return !(oFiMsg == b.oFiMsg);
    }

    /* Overloading conversion operator */
    operator midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus() 
    {
        return oFiMsg;
    }

    tVoid vTrace() const;

    midw_ext_sxm_audiofi_tclMsgSxmRadioIdStatus oFiMsg;

};

struct fc_sxm_tcl_trSxmDbVersionStatus 
{
    /* Constructor */
    fc_sxm_tcl_trSxmDbVersionStatus()
    {}


    /* Overloading comparision operator */
    bool operator!=(fc_sxm_tcl_trSxmDbVersionStatus const& b) const
    {
        return !(oFiMsg == b.oFiMsg);
    }

    /* Overloading conversion operator */
    operator midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus() 
    {
        return oFiMsg;
    }

    tVoid vTrace() const;

    midw_ext_sxm_audiofi_tclMsgSxmSmsDbVersionsStatus oFiMsg;

};

struct fc_sxm_tcl_trSxmModuleSubStatus 
{
    /* Constructor */
    fc_sxm_tcl_trSxmModuleSubStatus()
    {}


    /* Overloading comparision operator */
    bool operator!=(fc_sxm_tcl_trSxmModuleSubStatus const& b) const
    {
        return !(oFiMsg == b.oFiMsg);
    }

    /* Overloading conversion operator */
    operator midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus() 
    {
        return oFiMsg;
    }

    tVoid vTrace() const;

    midw_ext_sxm_audiofi_tclMsgSxmModuleSubInfoStatus oFiMsg;

};

struct fc_sxm_tcl_trSxmDownloadProgress 
{
    /* Constructor */
    fc_sxm_tcl_trSxmDownloadProgress()
    {}


    /* Overloading comparision operator */
    bool operator!=(fc_sxm_tcl_trSxmDownloadProgress const& b) const
    {
        return !(oFiMsg == b.oFiMsg);
    }

    /* Overloading conversion operator */
    operator midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus() 
    {
        return oFiMsg;
    }

    tVoid vTrace() const;

    midw_ext_sxm_audiofi_tclMsgFirmwareDownloadProgressStatus oFiMsg;

};



/* diag-properties*/
class fc_sxm_tclDiagProperties:
    public fc_sxm_tclSingleton<fc_sxm_tclDiagProperties> 
{
private:
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagProperties>;

public:
    //Using Auto property with tracing facility on notification
    fc_sxm_tclAutoPropertyTr<fc_sxm_tcl_trDiagPropertyTestModeData, 
        CCA_C_U16_SRV_SXM_AUDIO, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AUDIOFI_C_U16_DIAGTESTMODEDATA /* give FID if notification to service is needed  */
    > oTestModeData;

     //Using Auto property with tracing facility on notification
    fc_sxm_tclAutoPropertyTr<fc_sxm_tcl_trDiagPropertyAntennaState, 
        CCA_C_U16_SRV_SXM_AUDIO, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AUDIOFI_C_U16_SXMDIAGANTENNASTATE /* give FID if notification to service is needed  */
    > oAntennaState;

    //Using Auto property with tracing facility on notification
    fc_sxm_tclAutoPropertyTr<fc_sxm_tcl_trDiagPropertySignalQuality, 
        CCA_C_U16_SRV_SXM_AUDIO, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AUDIOFI_C_U16_SXMDIAGSIGNALQUALITY /* give FID if notification to service is needed  */
    > oSignalQuality;

    //Using Auto property with tracing facility on notification
    fc_sxm_tclAutoPropertyTr<fc_sxm_tcl_trDiagSxmRadioId, 
        CCA_C_U16_SRV_SXM_AUDIO, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AUDIOFI_C_U16_SXMRADIOID /* give FID if notification to service is needed  */
    > oSxmRadioId;   

    //Using Auto property with tracing facility on notification
    fc_sxm_tclAutoPropertyTr<fc_sxm_tcl_trSxmDbVersionStatus, 
        CCA_C_U16_SRV_SXM_AUDIO, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AUDIOFI_C_U16_SXMSMSDBVERSIONS /* give FID if notification to service is needed  */
    > oSxmDbVersions; 

    //Using Auto property with tracing facility on notification
    fc_sxm_tclAutoPropertyTr<fc_sxm_tcl_trSxmModuleSubStatus, 
        CCA_C_U16_SRV_SXM_AUDIO, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AUDIOFI_C_U16_SXMMODULESUBINFO /* give FID if notification to service is needed  */
    > oSxmModuleSubInfo; 

    //Using Auto property with tracing facility on notification
    fc_sxm_tclAutoPropertyTr<fc_sxm_tcl_trSxmDownloadProgress, 
        CCA_C_U16_SRV_SXM_AUDIO, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AUDIOFI_C_U16_FIRMWAREDOWNLOADPROGRESS /* give FID if notification to service is needed  */
    > oSxmDownloadProgress; 

};




/*
* Audio property class that holds property update data
*/

#endif


