/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_log.h
* @brief       SXM Diagnosis handler for Diag log.Writes the Diagnosis DTC.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_DIAG_LOG_H_
#define _FC_SXM_TCL_DIAG_LOG_H_

#include "fc_sxm_common.h"
#include "fc_sxm_sms.h"
#include "fc_sxm_client_diaglog_fi.h"
#include "fc_sxm_diag_types.h"


// Status from cca client-handler
struct fc_sxm_trMsgFiDiaglogNextTestStatus: public fc_sxm_tclMessage {
    // Generate unique id, take care not to use a number twice
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_LOG + 1);
    /* payload is the received fi-message
       note: the name must always be "oFiMsg"
    */
    midw_diaglogfi_tclMsgSendNextTestResultStatus oFiMsg;
};

// Method-result from cca client handler
struct fc_sxm_trMsgFiDiaglogMethodResultSaveTest: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Audio, FC_SXM_AUDIO_ACTION_BASE_DIAG_LOG + 2);
    /* payload is the received fi-message
       note: the name must always be "oFiMsg"
    */
    midw_diaglogfi_tclMsgSaveTestResultMethodResult oFiMsg;
};


class fc_sxm_tclDiagLog:
	public fc_sxm_tclDiagMember,
    public fc_sxm_tclSingleton<fc_sxm_tclDiagLog> 
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclDiagLog>;

public:
    /*Destructor*/
    virtual ~fc_sxm_tclDiagLog();

     // Process status-msg for Diaglog
    tVoid vProcess(fc_sxm_trMsgFiDiaglogNextTestStatus const *prMsg);

    // Process smethod result  for Diaglog
    tVoid vProcess(fc_sxm_trMsgFiDiaglogMethodResultSaveTest const *prMsg);

    //Method to send the test result to diaglog
    tVoid vSendMethodStartSaveTestResult(tBool bUpdateAlways);
   
protected:

private:
    /*Constructor*/
    fc_sxm_tclDiagLog();

    ANTENNA_STATE_ENUM m_eAntennaState;
    tBool m_bFirstUpdate;

};








#endif //_FC_SXM_TCL_DIAG_HANDLER_H_
