/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_diag_for_each_base.cpp
* @brief       Implementation of diagnosis functionalities that has to be 
*              carried out in each of the services.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_common.h"
#include "fc_sxm_main.h"

#include "fc_sxm_tcl_timer.h"
#include "fc_sxm_common.h"
#include "fc_sxm_tcl_timer.h"
#include "fc_sxm_tcl_sxmapp_manager.h"

#include "fc_sxm_tcl_diaghandler.h"
#include "fc_sxm_tcl_diag_for_each_base.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_DIAGHANDLER
#include "trcGenProj/Header/fc_sxm_tcl_diag_for_each_base.cpp.trc.h"
#endif

//start fc_sxm_tclDiagForEachBase
fc_sxm_tclDiagForEachBase::fc_sxm_tclDiagForEachBase(tU32 u32TimeoutMs):
    _bOk(FALSE),
    _u32TimeoutMs(u32TimeoutMs),
    _bFirst(TRUE),
    _enCurServiceId(fc_sxm_enServiceID_All)
{
    _oSem.vOpen();
    _iter=_mapResults.begin(); //pointer to the begining
    ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase CTOR"));
}

fc_sxm_tclDiagForEachBase::~fc_sxm_tclDiagForEachBase()
{
    ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase DTOR"));
    _bOk=FALSE;
    _u32TimeoutMs=0;
    _enCurServiceId=fc_sxm_enServiceID_All;
    _bFirst=TRUE;
    _mapResults.clear(); //clear map result
    _iter=_mapResults.end();
}


tBool fc_sxm_tclDiagForEachBase::bStart() {
    ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase bStart"));

    _oSem.vGet();
    if (bIsActive()) {
        _oSem.vPost();
        return FALSE;
    }  
    _mapResults.clear(); //clear the map result
    _bOk=TRUE;
    _enCurServiceId = fc_sxm_enServiceID_All;
    _bFirst=TRUE;
    map<fc_sxm_tenServiceID, fc_sxm_tclBaseApp*> const &mapOfApps = fc_sxm_tclAppManager::instance()->oGetMapOfApps();       
    SXM_FOREACH_MAP_CONST(fc_sxm_tenServiceID, fc_sxm_tclBaseApp*, iter, mapOfApps) {
       /* _mapResults[iter->second]=fc_sxm_enDiagResult_Pending;*/
        _mapResults[iter->first]=fc_sxm_enDiagResult_Pending;
    }
    ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase bStart():nApp=%u", _mapResults.size()));

    _iter=_mapResults.begin(); //point to the begining of the map

    ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase bStart():_iter->first=0x%08x", fc_sxm_tclAppManager::instance()->poGetApp(_iter->first)));
    _oSem.vPost();
    vQueryNextApp();
    return TRUE;
}

tBool fc_sxm_tclDiagForEachBase::bIsActive() {
    return poGetTimer()->bIsRunning(); //return the timer state
}

tVoid fc_sxm_tclDiagForEachBase::vHandleAppAnswer(fc_sxm_tenServiceID enServiceId, tBool bOk) 
{
    ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase vHandleAppAnswer(%d):bOk=%u", 
                    ETG_CENUM(fc_sxm_tenServiceID, enServiceId), bOk));
    if (enServiceId != _enCurServiceId ||  enServiceId == fc_sxm_enServiceID_All) {
        ETG_TRACE_ERR(("fc_sxm_tclDiagForEachBase vHandleAppAnswer(%d):bOk=%u wrong enServiceId, expected %d", 
                       ETG_CENUM(fc_sxm_tenServiceID, enServiceId), bOk, 
                       ETG_CENUM(fc_sxm_tenServiceID, _enCurServiceId)));
        return;
    }
    _oSem.vGet();

    if (!bOk) {
        _bOk=FALSE;
    }
    /*Update the result*/
    _iter->second= bOk ? fc_sxm_enDiagResult_Ok : fc_sxm_enDiagResult_Failed;
    _enCurServiceId = fc_sxm_enServiceID_All;
    _oSem.vPost();
    /*Check for the next service*/
    vQueryNextApp();
}



tVoid fc_sxm_tclDiagForEachBase::vQueryNextApp() {
    _oSem.vGet();

   /*Iterate the map to find the services*/
    if (_iter!=_mapResults.end() && !_bFirst) {
    ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase vQueryNextApp():++"));
        ++_iter;
    }
    _bFirst=FALSE;
    if (_iter==_mapResults.end()) {
        ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase vQueryNextApp():LAST"));
        /*final service found*/
        poGetTimer()->vStop();
        _enCurServiceId=fc_sxm_enServiceID_All;
        _oSem.vPost();
        vOnDone();
        return;
    }
    else {
        ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase vQueryNextApp():QUERY NEXT"));
        fc_sxm_tclTimerBase *poTimer=poGetTimer();
        SXM_ASSERT_RETURN(OSAL_NULL != poTimer);
        ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase vQueryNextApp: Got Timer"));

        /*Start the timer*/
        poTimer->vStart(_u32TimeoutMs);
        ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase vQueryNextApp: Started Timer"));
       /* _enCurServiceId = _iter->first->enGetServiceId();*/
         _enCurServiceId = _iter->first;
        ETG_TRACE_USR4(("fc_sxm_tclDiagForEachBase vQueryNextApp():QUERY NEXT: poApp=0x%08x", fc_sxm_tclAppManager::instance()->poGetApp(_iter->first)));
        _oSem.vPost();
       /*Query the app*/
        /*vQueryApp(_iter->first);*/
        vQueryApp(fc_sxm_tclAppManager::instance()->poGetApp(_iter->first));
    }

}

tVoid fc_sxm_tclDiagForEachBase::vProcessTimer(fc_sxm_trMsgCmdDiagForEachTimeout const *prMsg) {

    (tVoid)prMsg;
    ETG_TRACE_USR4(("fc_sxm_trMsgCmdDiagForEachTimeout _enCurServiceId=%d", 
                    ETG_CENUM(fc_sxm_tenServiceID, _enCurServiceId)));
    _oSem.vGet();
    fc_sxm_tenServiceID enCurServiceId = _enCurServiceId;
    _oSem.vPost();

    vHandleAppAnswer(enCurServiceId, FALSE);
}



